/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.utils.collections;

import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class CombinedList<T>
extends AbstractList<T> {
    private List<List<T>> lists;

    public CombinedList(List<List<T>> lists) {
        this.lists = new ArrayList<List<T>>(lists);
    }

    public CombinedList(List<T> ... lists) {
        this.lists = Arrays.asList(lists);
    }

    @Override
    public T get(int index) {
        int listId = 0;
        while (listId < this.lists.size() && index > this.lists.get(listId).size()) {
            index -= this.lists.get(++listId).size();
        }
        if (listId > this.lists.size()) {
            throw new IndexOutOfBoundsException("Index: " + index);
        }
        return this.lists.get(listId).get(index);
    }

    @Override
    public int size() {
        int totalSize = 0;
        for (List<T> list : this.lists) {
            totalSize += list.size();
        }
        return totalSize;
    }
}

