/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.concurrency;

import cz.cuni.amis.tests.ConcurrencyTest;
import cz.cuni.amis.tests.ConcurrentTask;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.junit.Test;

public class Test01_HashMap
extends ConcurrencyTest {
    private Map<Integer, Integer> ints = new HashMap<Integer, Integer>();
    private static final int COUNT = 10000;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int get(int i) {
        Integer result = this.ints.get(i);
        if (result != null) {
            return result;
        }
        Map<Integer, Integer> map = this.ints;
        synchronized (map) {
            log.info(Thread.currentThread().getName() + ": get(" + i + ") regetting...");
            result = this.ints.get(i);
            if (result != null) {
                log.info(Thread.currentThread().getName() + ": get(" + i + ") sync get success!");
                return result;
            }
            log.info(Thread.currentThread().getName() + ": get(" + i + ") inserting...");
            this.ints.put(i, i);
            return i;
        }
    }

    @Test
    public void test() {
        int i;
        int i2;
        int threadCount = 30;
        ArrayList<InsertJob> tasks = new ArrayList<InsertJob>();
        for (int i3 = 0; i3 < threadCount; ++i3) {
            tasks.add(new InsertJob());
        }
        this.runConcurrent(tasks, threadCount);
        log.info("Checking results...");
        Object[] keys = this.ints.keySet().toArray(new Integer[10000]);
        Object[] values = this.ints.values().toArray(new Integer[10000]);
        if (keys.length != 10000) {
            this.testFailed("keys.length != 10000 == number of inserted pairs");
        }
        if (values.length != 10000) {
            this.testFailed("values.length != 10000 == number of inserted pairs");
        }
        for (i2 = 0; i2 < keys.length; ++i2) {
            if (keys[i2] != null) continue;
            this.testFailed("keys[" + i2 + "] == null");
        }
        for (i2 = 0; i2 < values.length; ++i2) {
            if (values[i2] != null) continue;
            this.testFailed("values[" + i2 + "] == null");
        }
        Arrays.sort(keys);
        Arrays.sort(values);
        for (i2 = 0; i2 < 10000; ++i2) {
            if ((Integer)keys[i2] != i2) {
                this.testFailed("keys[i] == " + keys[i2] + " != " + i2 + " which is expected value");
            }
            if ((Integer)values[i2] == i2) continue;
            this.testFailed("values[i] == " + values[i2] + " != " + i2 + " which is expected value");
        }
        Integer[] keyRegs = new Integer[10000];
        Integer[] valueRegs = new Integer[10000];
        for (int i4 = 0; i4 < 10000; ++i4) {
            keyRegs[i4] = i4;
            valueRegs[i4] = i4;
        }
        for (Map.Entry<Integer, Integer> entry : this.ints.entrySet()) {
            if (entry.getKey() == null) {
                this.testFailed("map contains entry with key==null");
            }
            if (entry.getValue() == null) {
                this.testFailed("map contains entry with value==null");
            }
            int key = entry.getKey();
            int value = entry.getValue();
            if (keyRegs[key] == null) {
                this.testFailed("key " + key + " appears in the map twice");
            }
            keyRegs[key] = null;
            if (valueRegs[value] == null) {
                this.testFailed("value " + value + " appears in the map twice");
            }
            valueRegs[value] = null;
        }
        for (i = 0; i < 10000; ++i) {
            if (keyRegs[i] != null) {
                this.testFailed("key " + i + " is not in the map");
            }
            if (valueRegs[i] == null) continue;
            this.testFailed("value " + i + " is not in the map");
        }
        for (i = 0; i < 10000; ++i) {
            Integer result = this.ints.get(i);
            if (result == null) {
                this.testFailed("key " + i + " is not in the map");
            }
            if (result == i) continue;
            this.testFailed("value under the key " + i + " is not " + i + " but " + result);
        }
        this.testOk();
    }

    private class InsertJob
    extends ConcurrentTask {
        private InsertJob() {
        }

        protected void runImpl() {
            for (int i = 0; i < 10000; ++i) {
                Test01_HashMap.this.get(i);
            }
        }
    }
}

