/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.utils.collections;

import cz.cuni.amis.utils.ObjectFilter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Random;

public class MyCollections {
    private static Random random = new Random(System.currentTimeMillis());
    public static final IToString TO_STRING = new IToString(){

        @Override
        public String toString(Object obj) {
            return obj.toString();
        }
    };

    public static <T> T getRandom(Collection<T> col) {
        if (col == null) {
            return null;
        }
        if (col instanceof List) {
            return MyCollections.getRandom((List)col);
        }
        if (col.size() == 0) {
            return null;
        }
        int rnd = random.nextInt(col.size());
        Iterator<T> iter = col.iterator();
        for (int i = 0; i < rnd - 1; ++i) {
            iter.next();
        }
        return iter.next();
    }

    public static <T> T getRandom(List<T> list) {
        if (list == null) {
            return null;
        }
        if (list.size() == 0) {
            return null;
        }
        return list.get(random.nextInt(list.size()));
    }

    public static <T> T getRandom(T[] array) {
        if (array == null) {
            return null;
        }
        if (array.length == 0) {
            return null;
        }
        return array[random.nextInt(array.length)];
    }

    public static <T> void toList(T[] objects, List<T> list) {
        if (objects == null) {
            return;
        }
        if (list == null) {
            return;
        }
        for (T obj : objects) {
            list.add(obj);
        }
    }

    public static <T> void toList(T[] objects, List<T> list, ObjectFilter filter) {
        if (filter == null) {
            MyCollections.toList(objects, list);
            return;
        }
        if (objects == null) {
            return;
        }
        if (list == null) {
            return;
        }
        for (T obj : objects) {
            if (!filter.accept(obj)) continue;
            list.add(obj);
        }
    }

    public static <T> List<T> asList(T[] objects) {
        if (objects == null) {
            return null;
        }
        ArrayList<T> list = new ArrayList<T>(objects.length);
        for (T object : objects) {
            list.add(object);
        }
        return list;
    }

    public static <T> List<T> asList(Collection<T> objects) {
        if (objects == null) {
            return null;
        }
        ArrayList<T> list = new ArrayList<T>(objects.size());
        for (T object : objects) {
            list.add(object);
        }
        return list;
    }

    public static <T> List<T> asList(T[] objects, ObjectFilter filter) {
        if (filter == null) {
            return MyCollections.asList(objects);
        }
        if (objects == null) {
            return null;
        }
        ArrayList<T> list = new ArrayList<T>(objects.length);
        for (T object : objects) {
            if (!filter.accept(object)) continue;
            list.add(object);
        }
        return list;
    }

    public static <T> List<T> asList(Collection<T> objects, ObjectFilter filter) {
        if (filter == null) {
            return MyCollections.asList(objects);
        }
        if (objects == null) {
            return null;
        }
        ArrayList<T> list = new ArrayList<T>(objects.size());
        for (T object : objects) {
            if (!filter.accept(object)) continue;
            list.add(object);
        }
        return list;
    }

    public static String toString(Object objToString, String[] prefixes, String[] postfixes, String[] separators, IToString toString) {
        String separator;
        StringBuffer sb = new StringBuffer(200);
        String[] newPrefixes = null;
        String[] newPostfixes = null;
        String[] newSeparators = null;
        boolean first = true;
        sb.append(prefixes != null && prefixes.length > 0 ? prefixes[0] : "");
        String string = separator = separators != null && separators.length > 0 ? separators[0] : "";
        if (objToString.getClass().isArray()) {
            objToString = MyCollections.asList((Object[])objToString);
        }
        if (objToString instanceof Collection) {
            for (Object obj : (Collection)objToString) {
                if (first) {
                    first = false;
                } else {
                    sb.append(separator);
                }
                if (obj instanceof Collection) {
                    if (newPrefixes == null) {
                        if (prefixes != null && prefixes.length > 1) {
                            newPrefixes = new String[prefixes.length - 1];
                            System.arraycopy(prefixes, 1, newPrefixes, 0, prefixes.length - 1);
                        } else {
                            newPrefixes = new String[]{};
                        }
                        if (postfixes != null && postfixes.length > 1) {
                            newPostfixes = new String[postfixes.length - 1];
                            System.arraycopy(postfixes, 1, newPostfixes, 0, postfixes.length - 1);
                        } else {
                            newPostfixes = new String[]{};
                        }
                        if (separators != null && separators.length > 1) {
                            newSeparators = new String[separators.length - 1];
                            System.arraycopy(separators, 1, newSeparators, 0, separators.length - 1);
                        } else {
                            newSeparators = new String[]{};
                        }
                    }
                    sb.append(MyCollections.toString(obj, newPrefixes, newPostfixes, newSeparators, toString));
                    continue;
                }
                sb.append(toString.toString(obj));
            }
        } else {
            sb.append(toString.toString(objToString));
        }
        sb.append(postfixes != null && postfixes.length > 0 ? postfixes[0] : "");
        return sb.toString();
    }

    public static String toString(Object obj, String prefix, String postfix, String separator) {
        return MyCollections.toString(obj, new String[]{prefix}, new String[]{postfix}, new String[]{separator}, TO_STRING);
    }

    public static String toString(Object obj, String prefix, String postfix, String separator, IToString toString) {
        return MyCollections.toString(obj, new String[]{prefix}, new String[]{postfix}, new String[]{separator}, toString);
    }

    public static interface IToString {
        public String toString(Object var1);
    }
}

