/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.utils.maps;

import cz.cuni.amis.utils.exception.PogamutInterruptedException;
import cz.cuni.amis.utils.maps.WeakHashTriMap;
import org.junit.Test;

public class Test02_WeakHashTriMap {
    static int counter = 0;

    @Test
    public void testWeakReferencing() {
        WeakHashTriMap testMap = new WeakHashTriMap();
        for (int primary = 0; primary < 100; ++primary) {
            StringKey priKey = new StringKey("Key" + primary);
            for (int secondary = 0; secondary < 10; ++secondary) {
                for (int tertiary = 0; tertiary < 20; ++tertiary) {
                    testMap.put((Object)priKey, (Object)secondary, (Object)tertiary, (Object)(primary * secondary * tertiary));
                }
            }
            System.out.println("Primary key exists: " + counter);
        }
        for (int i = 0; counter > 0 && i < 20; ++i) {
            System.gc();
            System.out.println("Waiting for gc()...");
            try {
                Thread.sleep(100L);
                continue;
            }
            catch (InterruptedException e) {
                throw new PogamutInterruptedException((Throwable)e, (Object)this);
            }
        }
        int c = counter;
        System.out.println("Primary key exists: " + c);
        if (c > 0) {
            System.out.println("[ERROR] Not all primary keys have been gc()ed!");
            throw new RuntimeException("[ERROR] Not all primary keys have been gc()ed!");
        }
        System.out.println("[OK] All primary keys have been gc()ed!");
        System.out.println("---/// TEST OK ///---");
    }

    public class StringKey {
        private String s;

        StringKey(String in) {
            this.s = in;
            ++counter;
            System.out.println("Created : " + in);
        }

        public void finalize() {
            --counter;
            System.out.println("Finalized : " + this.s);
        }
    }
}

