/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.utils.flag;

import cz.cuni.amis.utils.flag.FlagListener;

public interface ReasonFlagListener<TYPE, REASON>
extends FlagListener<TYPE> {
    public void flagChanged(TYPE var1, REASON var2);

    public static class FlagListenerAdapter<T, R>
    implements ReasonFlagListener<T, R> {
        private FlagListener<T> listener;

        public FlagListenerAdapter(FlagListener<T> listener) {
            this.listener = listener;
        }

        @Override
        public void flagChanged(T changedValue, R reason) {
            this.listener.flagChanged(changedValue);
        }

        @Override
        public void flagChanged(T changedValue) {
            this.listener.flagChanged(changedValue);
        }
    }

    public static class ReasonFlagListenerNotifier<T, R>
    extends FlagListener.FlagListenerNotifier<T> {
        private R reason;

        public ReasonFlagListenerNotifier() {
        }

        public ReasonFlagListenerNotifier(T changedValue) {
            super(changedValue);
        }

        public ReasonFlagListenerNotifier(T changedValue, R reasonForChange) {
            super(changedValue);
            this.reason = reasonForChange;
        }

        public void setReason(R reason) {
            this.reason = reason;
        }

        @Override
        public void notify(FlagListener<T> listener) {
            if (listener instanceof ReasonFlagListener) {
                this.notify((ReasonFlagListener)listener);
            } else {
                super.notify(listener);
            }
        }

        @Override
        public void notify(ReasonFlagListener<T, R> listener) {
            if (this.reason == null) {
                listener.flagChanged(this.value);
            } else {
                listener.flagChanged(this.value, this.reason);
            }
        }
    }
}

