package cz.cuni.amis.utils.sets;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Random;

import org.junit.Assert;
import org.junit.Test;

import cz.cuni.amis.utils.StopWatch;

public class Test03_ConcurrentLinkedHashSet {
	
	@Test
	public void test() {
		ConcurrentLinkedHashSet<Integer> set = new ConcurrentLinkedHashSet<Integer>();
		for (int i = 0; i < 25; ++i) {
			set.add(i);
		}
		
		System.out.println("Inserted: ");
		Iterator<Integer> iter = set.iterator();
		boolean first = true;
		while (iter.hasNext()) {
			if (first) first = false;
			else System.out.print(", ");
			System.out.print(iter.next());
		}
		System.out.println();
		System.out.println();
		
		int i = 0;
		iter = set.iterator();
		while(iter.hasNext()) {
			int j = iter.next();
			if (i == j) {
				System.out.println("Set next is "+ j + " == " + i);
			} else {
				System.out.println("Set next is "+ j + " != " + i);
			}
			Assert.assertTrue("set should seustain the order of insertion", i == j);
			++i;
		}
		Assert.assertTrue("set should not lose items at will", i == 25);
		
		System.out.println();
		System.out.println("Removing every second item, set:");
		
		for (i = 1; i < 25; i+=2) {
			set.remove(i);
		}
		iter = set.iterator();
		first = true;
		while (iter.hasNext()) {
			if (first) first = false;
			else System.out.print(", ");
			System.out.print(iter.next());
		}
		System.out.println();
		System.out.println();
		
		i = 0;
		iter = set.iterator();
		while(iter.hasNext()) {
			int j = iter.next();
			if (i == j) {
				System.out.println("Set next is "+ j + " == " + i);
			} else {
				System.out.println("Set next is "+ j + " != " + i);
			}
			Assert.assertTrue("set should seustain the order of insertion", i == j);
			i += 2;
		}
		Assert.assertTrue("set should not lose items at will", i == 26);
		
		System.out.println();
		System.out.println("---/// TEST OK ///---");
	}

	public static void main(String[] args) {
		Test03_ConcurrentLinkedHashSet test = new Test03_ConcurrentLinkedHashSet();
		
		test.test();
	}
	
}
