/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.utils.astar;

import cz.cuni.amis.utils.StopWatch;
import cz.cuni.amis.utils.astar.AStar;
import cz.cuni.amis.utils.astar.AStarHeuristic;
import cz.cuni.amis.utils.astar.AStarMap;
import cz.cuni.amis.utils.astar.AStarResult;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Random;
import javax.imageio.ImageIO;
import org.junit.BeforeClass;
import org.junit.Test;

public class Test04_AStar {
    static Maze maze;
    Random random = new Random(System.currentTimeMillis());

    @BeforeClass
    public static void before() {
        String mazeImage = "/cz/cuni/amis/utils/astar/maze.bmp";
        System.out.println("[INFO] Loading image " + mazeImage);
        maze = new Maze(mazeImage);
        System.out.println("Maze loaded...");
    }

    private void test(int num, int startX, int startY, int endX, int endY, boolean expectedSuccess) {
        System.out.println("TEST " + num + " / 44");
        System.out.println("[INFO] " + (expectedSuccess ? "POSITIVE TEST" : "NEGATIVE TEST"));
        System.out.println("[INFO] Start: " + startX + "," + startY);
        System.out.println("[INFO] End: " + endX + ", " + endY);
        MazeNode start = Test04_AStar.maze.nodes[startX][startY];
        MazeNode end = Test04_AStar.maze.nodes[endX][endY];
        if (expectedSuccess && !start.isFree()) {
            System.out.println("[ERROR] Start[" + startX + "," + startY + "] is not a free point!");
            throw new RuntimeException("[ERROR] Start[" + startX + "," + startY + "] is not a free point!");
        }
        if (expectedSuccess && !end.isFree()) {
            System.out.println("[ERROR] Start[" + endX + ", " + endY + "] is not a free point!");
            throw new RuntimeException("[ERROR] Start[" + endX + ", " + endY + "] is not a free point!");
        }
        System.out.println("[INFO] Invoking AStar!");
        StopWatch watch = new StopWatch();
        AStarResult result = AStar.aStar((AStarMap)maze, (AStarHeuristic)new MazeHeuristic(end), (Object)start, (Object)end);
        System.out.println("[INFO] AStar time:  " + watch.stopStr() + " ms");
        if (expectedSuccess != result.success) {
            if (!result.success) {
                System.out.println("[ERROR] Path not found! Can't be! Either someone passed wrong maze.png or AStar has failed!");
                throw new RuntimeException("Path not found! Can't be! Either someone passed wrong maze.png or AStar has failed!");
            }
            System.out.println("[ERROR] Path found! Should not exist!");
            throw new RuntimeException("Path found! Should not exist!");
        }
        if (result.success) {
            System.out.println("[INFO] Path found!");
            System.out.println("[INFO] Path length: " + result.getPath().size());
            maze.output((AStarResult<MazeNode>)result, num);
        } else {
            System.out.println("[INFO] Path does not exist! (Expected == correct)");
        }
        System.out.println("---/// TEST OK ///---");
    }

    private MazeNode getRandomNode(boolean free) {
        int x = this.random.nextInt(maze.width);
        int y = this.random.nextInt(maze.height);
        while (free != Test04_AStar.maze.maze[x][y]) {
            x = this.random.nextInt(maze.width);
            y = this.random.nextInt(maze.height);
        }
        return Test04_AStar.maze.nodes[x][y];
    }

    private void testPositiveRandom(int num) {
        MazeNode start = this.getRandomNode(true);
        MazeNode goal = this.getRandomNode(true);
        this.test(num, start.x, start.y, goal.x, goal.y, true);
    }

    private void testNegativeRandom(int num) {
        MazeNode start = this.getRandomNode(true);
        MazeNode goal = this.getRandomNode(false);
        this.test(num, start.x, start.y, goal.x, goal.y, false);
    }

    @Test
    public void test1() {
        this.test(1, 1, 1, maze.width - 1, maze.height - 2, true);
    }

    @Test
    public void test2() {
        this.test(2, 1, maze.height - 2, maze.width - 1, maze.height - 2, true);
    }

    @Test
    public void test3() {
        this.test(3, 1, maze.height - 2, maze.width - 2, 1, true);
    }

    @Test
    public void test4Same() {
        this.test(4, 1, 1, 1, 1, true);
    }

    @Test
    public void test5PositiveRandom() {
        for (int i = 0; i < 20; ++i) {
            this.testPositiveRandom(5 + i);
        }
    }

    @Test
    public void test6NegativeRandom() {
        for (int i = 0; i < 20; ++i) {
            this.testNegativeRandom(25 + i);
        }
    }

    public class MazeHeuristic
    implements AStarHeuristic<MazeNode> {
        private MazeNode goal;

        public MazeHeuristic(MazeNode goal) {
            this.goal = goal;
        }

        public int getEstimatedDistanceToGoal(MazeNode node) {
            int dX = this.goal.x - node.x;
            int dY = this.goal.y - node.y;
            return (int)Math.sqrt(dX * dX + dY * dY);
        }
    }

    public static class Maze
    implements AStarMap<MazeNode> {
        public boolean[][] maze = null;
        public MazeNode[][] nodes = null;
        private int width;
        private int height;
        private BufferedImage image;
        private File imageFile;
        int black = this.getRGB(0, 0, 0);
        int red = this.getRGB(255, 0, 0);
        int green = this.getRGB(0, 255, 0);
        int blue = this.getRGB(100, 100, 255);
        int white = this.getRGB(255, 255, 255);

        public Maze(String pathToResource) {
            int j;
            int i;
            URI uri;
            Class<?> cls = this.getClass();
            URL url = this.getClass().getResource(pathToResource);
            try {
                uri = url.toURI();
            }
            catch (URISyntaxException e) {
                throw new RuntimeException("Could not obrain URI from URL: " + url.toString());
            }
            this.imageFile = new File(uri);
            if (!this.imageFile.exists()) {
                throw new RuntimeException("File as resource (" + pathToResource + ") does not exist at: " + this.imageFile.getAbsolutePath());
            }
            try {
                this.image = ImageIO.read(this.imageFile);
            }
            catch (IOException e) {
                throw new RuntimeException("Could not read image from: " + this.imageFile.getAbsolutePath());
            }
            this.width = this.image.getWidth();
            this.height = this.image.getHeight();
            this.maze = new boolean[this.width][];
            this.nodes = new MazeNode[this.width][];
            for (i = 0; i < this.width; ++i) {
                this.maze[i] = new boolean[this.image.getHeight()];
                this.nodes[i] = new MazeNode[this.image.getHeight()];
                for (j = 0; j < this.height; ++j) {
                    int pixel = this.image.getRGB(i, j);
                    int alpha = pixel >> 24 & 0xFF;
                    int red = pixel >> 16 & 0xFF;
                    int green = pixel >> 8 & 0xFF;
                    int blue = pixel & 0xFF;
                    this.maze[i][j] = red != 0;
                    this.nodes[i][j] = new MazeNode(i, j);
                }
            }
            for (i = 0; i < this.width; ++i) {
                for (j = 0; j < this.height; ++j) {
                    if (i > 0 && this.maze[i - 1][j]) {
                        this.nodes[i][j].neighs.add(this.nodes[i - 1][j]);
                    }
                    if (i < this.width - 1 && this.maze[i + 1][j]) {
                        this.nodes[i][j].neighs.add(this.nodes[i + 1][j]);
                    }
                    if (j > 0 && this.maze[i][j - 1]) {
                        this.nodes[i][j].neighs.add(this.nodes[i][j - 1]);
                    }
                    if (j >= this.height - 1 || !this.maze[i][j + 1]) continue;
                    this.nodes[i][j].neighs.add(this.nodes[i][j + 1]);
                }
            }
        }

        public int getEdgeCost(MazeNode nodeFrom, MazeNode nodeTo) {
            return Math.abs(nodeFrom.x - nodeTo.x) + Math.abs(nodeFrom.y - nodeTo.y);
        }

        public Collection<MazeNode> getNodeNeighbours(MazeNode node) {
            return node.neighs;
        }

        public int getRGB(int r, int g, int b) {
            int pixel = 0;
            pixel = 255;
            pixel = pixel << 8 | r;
            pixel = pixel << 8 | g;
            pixel = pixel << 8 | b;
            return pixel;
        }

        private void setPixel(int x, int y, int rgb) {
            if (x >= 0 && x < this.width && y >= 0 && y < this.height) {
                this.image.setRGB(x, y, rgb);
            }
        }

        private void restorePixel(int x, int y) {
            if (x >= 0 && x < this.width && y >= 0 && y < this.height) {
                if (this.maze[x][y]) {
                    this.image.setRGB(x, y, this.white);
                } else {
                    this.image.setRGB(x, y, this.black);
                }
            }
        }

        private void rectangle(int x, int y, int rgb) {
            for (int i = x - 4; i < x + 4; ++i) {
                for (int j = y - 4; j < y + 4; ++j) {
                    this.setPixel(i, j, rgb);
                }
            }
        }

        private void restoreRectangle(int x, int y) {
            for (int i = x - 4; i < x + 4; ++i) {
                for (int j = y - 4; j < y + 4; ++j) {
                    this.restorePixel(i, j);
                }
            }
        }

        public void output(AStarResult<MazeNode> result, int number) {
            MazeNode start = (MazeNode)result.getPath().get(0);
            MazeNode end = (MazeNode)result.getPath().get(result.getPath().size() - 1);
            int r = 100;
            int g = 100;
            int b = 100;
            int i = 0;
            for (MazeNode node : result.getPath()) {
                if (++i % 10 == 0) {
                    if (++r == 256) {
                        g += 10;
                        r = 100;
                    }
                    if (g >= 256) {
                        b += 10;
                        g = 100;
                    }
                    if (b >= 256) {
                        b = 100;
                    }
                }
                this.image.setRGB(node.x, node.y, this.getRGB(r, g, b));
            }
            this.rectangle(start.x, start.y, this.red);
            this.rectangle(end.x, end.y, this.green);
            String separ = System.getProperty("file.separator");
            String imagePath = this.imageFile.getAbsolutePath();
            File out = new File(imagePath.substring(0, imagePath.lastIndexOf(separ)) + separ + "maze-result-" + (number > 9 ? Integer.valueOf(number) : "0" + number) + ".bmp");
            try {
                ImageIO.write((RenderedImage)this.image, "bmp", out);
            }
            catch (IOException e) {
                throw new RuntimeException("Could not write PNG output with maze-result into " + out.getAbsolutePath(), e);
            }
            System.out.println("[INFO] result saved into " + out.getAbsolutePath());
            this.restoreRectangle(start.x, start.y);
            this.restoreRectangle(end.x, end.y);
            for (MazeNode node : result.getPath()) {
                this.image.setRGB(node.x, node.y, this.white);
            }
        }
    }

    public static class MazeNode {
        public int x;
        public int y;
        public List<MazeNode> neighs = new ArrayList<MazeNode>();

        public MazeNode(int x, int y) {
            this.x = x;
            this.y = y;
        }

        public boolean isFree() {
            return Test04_AStar.maze.maze[this.x][this.y];
        }

        public boolean isWall() {
            return !Test04_AStar.maze.maze[this.x][this.y];
        }
    }
}

