/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.concurrency;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.junit.Test;

public class TestHashMap {
    private static Map<Integer, Integer> ints = new HashMap<Integer, Integer>();
    private static final int COUNT = 10000;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static int get(int i) {
        Integer result = ints.get(i);
        if (result != null) {
            return result;
        }
        Map<Integer, Integer> map = ints;
        synchronized (map) {
            System.out.println(Thread.currentThread().getName() + ": get(" + i + ") regetting...");
            result = ints.get(i);
            if (result != null) {
                System.out.println(Thread.currentThread().getName() + ": get(" + i + ") sync get success!");
                return result;
            }
            System.out.println(Thread.currentThread().getName() + ": get(" + i + ") inserting...");
            ints.put(i, i);
            return i;
        }
    }

    @Test
    public void test() {
        int i;
        int i2;
        int i3;
        int threadCount = 30;
        System.out.println("[INFO] Creating " + threadCount + " threads...");
        Thread[] thread = new Thread[threadCount];
        for (i3 = 0; i3 < threadCount; ++i3) {
            thread[i3] = new Thread((Runnable)new InsertJob(), "T" + i3);
        }
        System.out.println("[INFO] Starting " + threadCount + " threads...");
        for (i3 = 0; i3 < threadCount; ++i3) {
            thread[i3].start();
        }
        System.out.println("[INFO] Joining " + threadCount + " threads...");
        for (i3 = 0; i3 < threadCount; ++i3) {
            try {
                thread[i3].join();
                continue;
            }
            catch (InterruptedException e) {
                // empty catch block
            }
        }
        System.out.println("[INFO] Checking results...");
        Object[] keys = ints.keySet().toArray(new Integer[10000]);
        Object[] values = ints.values().toArray(new Integer[10000]);
        if (keys.length != 10000) {
            System.out.println("[ERROR] keys.length != 10000 == number of inserted pairs");
            throw new RuntimeException("[ERROR] keys.length != 10000 == number of inserted pairs");
        }
        if (values.length != 10000) {
            System.out.println("[ERROR] values.length != 10000 == number of inserted pairs");
            throw new RuntimeException("[ERROR] values.length != 10000 == number of inserted pairs");
        }
        for (i2 = 0; i2 < keys.length; ++i2) {
            if (keys[i2] != null) continue;
            System.out.println("[ERROR] keys[" + i2 + "] == null");
            throw new RuntimeException("[ERROR] keys[" + i2 + "] == null");
        }
        for (i2 = 0; i2 < values.length; ++i2) {
            if (values[i2] != null) continue;
            System.out.println("[ERROR] values[" + i2 + "] == null");
            throw new RuntimeException("[ERROR] values[" + i2 + "] == null");
        }
        Arrays.sort(keys);
        Arrays.sort(values);
        for (i2 = 0; i2 < 10000; ++i2) {
            if ((Integer)keys[i2] != i2) {
                System.out.println("[ERROR] keys[i] == " + keys[i2] + " != " + i2 + " which is expected value");
                throw new RuntimeException("[ERROR] keys[i] == " + keys[i2] + " != " + i2 + " which is expected value");
            }
            if ((Integer)values[i2] == i2) continue;
            System.out.println("[ERROR] values[i] == " + values[i2] + " != " + i2 + " which is expected value");
            throw new RuntimeException("[ERROR] values[i] == " + values[i2] + " != " + i2 + " which is expected value");
        }
        Integer[] keyRegs = new Integer[10000];
        Integer[] valueRegs = new Integer[10000];
        for (int i4 = 0; i4 < 10000; ++i4) {
            keyRegs[i4] = i4;
            valueRegs[i4] = i4;
        }
        for (Map.Entry<Integer, Integer> entry : ints.entrySet()) {
            if (entry.getKey() == null) {
                System.out.println("[ERROR] map contains entry with key==null");
                throw new RuntimeException("[ERROR] map contains entry with key==null");
            }
            if (entry.getValue() == null) {
                System.out.println("[ERROR] map contains entry with value==null");
                throw new RuntimeException("[ERROR] map contains entry with value==null");
            }
            int key = entry.getKey();
            int value = entry.getValue();
            if (keyRegs[key] == null) {
                System.out.println("[ERROR] key " + key + " appears in the map twice");
                throw new RuntimeException("[ERROR] key " + key + " appears in the map twice");
            }
            keyRegs[key] = null;
            if (valueRegs[value] == null) {
                System.out.println("[ERROR] value " + value + " appears in the map twice");
                throw new RuntimeException("[ERROR] value " + value + " appears in the map twice");
            }
            valueRegs[value] = null;
        }
        for (i = 0; i < 10000; ++i) {
            if (keyRegs[i] != null) {
                System.out.println("[ERROR] key " + i + " is not in the map");
                throw new RuntimeException("[ERROR] key " + i + " is not in the map");
            }
            if (valueRegs[i] == null) continue;
            System.out.println("[ERROR] value " + i + " is not in the map");
            throw new RuntimeException("[ERROR] value " + i + " is not in the map");
        }
        for (i = 0; i < 10000; ++i) {
            Integer result = ints.get(i);
            if (result == null) {
                System.out.println("[ERROR] key " + i + " is not in the map");
                throw new RuntimeException("[ERROR] key " + i + " is not in the map");
            }
            if (result == i) continue;
            System.out.println("[ERROR] value under the key " + i + " is not " + i + " but " + result);
            throw new RuntimeException("[ERROR] value under the key " + i + " is not " + i + " but " + result);
        }
        System.out.println("---/// TEST OK ///---");
    }

    private static class InsertJob
    implements Runnable {
        private InsertJob() {
        }

        @Override
        public void run() {
            for (int i = 0; i < 10000; ++i) {
                TestHashMap.get(i);
            }
        }
    }
}

