/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.utils.logging;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.logging.LogRecord;

public class LogFormatter {
    private static SimpleDateFormat dateFormat = new SimpleDateFormat("HH:mm:ss.SSS");
    private static String longestUnitName = "";
    private static String longestComponentName = "";
    private StringBuffer buffer = new StringBuffer(512);
    private boolean lineEnds = false;
    private String name = null;
    public static final String[] whitespaces = new String[]{"        ", "       ", "      ", "     ", "    ", "   ", "  ", " ", ""};

    public LogFormatter(String unitName) {
        this.name = unitName;
    }

    public LogFormatter(String unitName, boolean appendLineEnd) {
        this.name = unitName;
        this.lineEnds = appendLineEnd;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized String format(LogRecord record) {
        int i;
        Object n;
        this.buffer.delete(0, this.buffer.length());
        if (this.name != null) {
            n = this.name;
            if (n == null) {
                n = "null";
            }
            if (((String)n).length() > longestUnitName.length()) {
                StringBuffer longest = new StringBuffer();
                for (i = 0; i < ((String)n).length(); ++i) {
                    longest.append(" ");
                }
                longestUnitName = longest.toString();
            }
            this.buffer.append("(");
            this.buffer.append((String)n);
            this.buffer.append(") ");
            int count = longestUnitName.length() - ((String)n).length();
            for (i = 0; i < count; ++i) {
                this.buffer.append(" ");
            }
        } else if (longestUnitName.length() > 0) {
            this.buffer.append("()");
            this.buffer.append(longestUnitName);
        } else {
            this.buffer.append("() ");
        }
        this.buffer.append("[");
        this.buffer.append(record.getLevel().toString());
        this.buffer.append("]");
        this.buffer.append(whitespaces[record.getLevel().toString().length()]);
        n = dateFormat;
        synchronized (n) {
            this.buffer.append(dateFormat.format(new Date(record.getMillis())));
        }
        this.buffer.append(" ");
        n = record.getLoggerName();
        if (n == null) {
            n = "null";
        }
        if (((String)n).length() > longestComponentName.length()) {
            StringBuffer longest = new StringBuffer();
            for (i = 0; i < ((String)n).length(); ++i) {
                longest.append(" ");
            }
            longestComponentName = longest.toString();
        }
        this.buffer.append("<");
        this.buffer.append((String)n);
        this.buffer.append("> ");
        int count = longestComponentName.length() - ((String)n).length();
        for (i = 0; i < count; ++i) {
            this.buffer.append(" ");
        }
        this.buffer.append(record.getMessage());
        if (this.lineEnds) {
            this.buffer.append("\r\n");
        }
        return this.buffer.toString();
    }
}

