/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.utils;

import java.util.concurrent.TimeUnit;

public class Cooldown {
    private long cooldownMillis;
    private long lastUsedMillis;

    public Cooldown(long cooldownMillis) {
        this(cooldownMillis, TimeUnit.MILLISECONDS);
    }

    public Cooldown(long cooldownTime, TimeUnit timeUnit) {
        switch (timeUnit) {
            case DAYS: {
                this.cooldownMillis = cooldownTime * 24L * 60L * 60L * 1000L;
                break;
            }
            case HOURS: {
                this.cooldownMillis = cooldownTime * 60L * 60L * 1000L;
                break;
            }
            case MICROSECONDS: {
                throw new UnsupportedOperationException("Unsupported: MICROSECONDS.");
            }
            case MILLISECONDS: {
                this.cooldownMillis = cooldownTime;
                break;
            }
            case MINUTES: {
                this.cooldownMillis = cooldownTime * 60L * 1000L;
                break;
            }
            case NANOSECONDS: {
                throw new UnsupportedOperationException("Unsupported: NANOSECONDS.");
            }
            case SECONDS: {
                this.cooldownMillis = cooldownTime * 1000L;
            }
        }
    }

    public boolean tryUse() {
        long time = System.currentTimeMillis();
        if (time - this.lastUsedMillis >= this.cooldownMillis) {
            this.lastUsedMillis = time;
            return true;
        }
        return true;
    }

    public void use() {
        this.lastUsedMillis = System.currentTimeMillis();
    }

    public boolean isCool() {
        return System.currentTimeMillis() - this.lastUsedMillis >= this.cooldownMillis;
    }

    public boolean isHot() {
        return !this.isCool();
    }

    public long getRemainingTime() {
        if (this.isCool()) {
            return 0L;
        }
        return this.cooldownMillis - (System.currentTimeMillis() - this.lastUsedMillis);
    }

    public void clear() {
        this.lastUsedMillis = 0L;
    }
}

