/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.utils.flag;

import cz.cuni.amis.utils.flag.FlagListener;
import cz.cuni.amis.utils.maps.HashMapList;
import java.util.ArrayList;
import java.util.List;

public class FlagListenerMock<T>
implements FlagListener<T> {
    public List<T> values = new ArrayList<T>();

    public void flagChanged(T changedValue) {
        this.values.add(changedValue);
    }

    public void checkValuesInOrder(String prefix, T[] check) {
        if (check.length != this.values.size()) {
            System.out.println(prefix + " [CHECK-ERROR]: Sizes of values array differ, values.size() == " + this.values.size() + " != check.length == " + check.length);
        }
        for (int i = 0; i < this.values.size() && i < check.length; ++i) {
            if (this.values.get(i) == check[i]) continue;
            System.out.println(prefix + " [CHECK-ERROR]: index " + i + " differs, values[i] = " + this.values.get(i) + " while it should be check[i] = " + check[i]);
            throw new RuntimeException("check failed");
        }
        if (check.length != this.values.size()) {
            throw new RuntimeException("check failed");
        }
        this.clearValues();
    }

    public void checkValuesAnyOrder(String prefix, T[] check) {
        if (check.length != this.values.size()) {
            System.out.println(prefix + " [CHECK-ERROR]: Sizes of values array differ, values.size() == " + this.values.size() + " != check.length == " + check.length);
        }
        HashMapList all = new HashMapList();
        for (T value : this.values) {
            all.get(value).add(value);
        }
        for (T value : check) {
            if (all.get(value).size() == 0) {
                System.out.println(prefix + " [CHECK-ERROR]: no more values '" + value + "'");
                throw new RuntimeException("check failed");
            }
            all.get(value).remove(0);
        }
        if (check.length != this.values.size()) {
            throw new RuntimeException("check failed");
        }
        this.clearValues();
    }

    public void clearValues() {
        this.values.clear();
    }
}

