/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.tests;

import cz.cuni.amis.tests.BaseTest;
import cz.cuni.amis.tests.ConcurrentTask;
import java.util.Collection;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

public class ConcurrencyTest
extends BaseTest {
    protected void runConcurrent(Collection<ConcurrentTask> tasks, int threads) {
        CountDownLatch latch = new CountDownLatch(tasks.size());
        for (ConcurrentTask task : tasks) {
            task.setLatch(latch);
            task.setLogger(log);
        }
        ThreadPoolExecutor executor = new ThreadPoolExecutor(threads, threads, 1000L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>());
        long time = System.currentTimeMillis();
        try {
            for (ConcurrentTask task : tasks) {
                executor.execute(task);
            }
            try {
                latch.await();
            }
            catch (InterruptedException e) {
                throw new RuntimeException("Interrupted.", e);
            }
        }
        finally {
            executor.shutdownNow();
        }
        log.info("All tasks finished, time: " + (System.currentTimeMillis() - time) + " ms");
        log.info("Checking thread exceptions...");
        for (ConcurrentTask task : tasks) {
            if (task.getException() == null) continue;
            if (task.getException() instanceof RuntimeException) {
                throw (RuntimeException)task.getException();
            }
            throw new RuntimeException("At least one task has finished with an exception.", task.getException());
        }
        log.info("All tasks executed OK");
    }
}

