/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.tests;

import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.logging.Logger;

public class ActivityLog {
    private static final String NEW_LINE = System.getProperty("line.separator");
    private List<IActivityCheck> activities = new LinkedList<IActivityCheck>();
    private Logger log;

    public ActivityLog(Logger log) {
        this.log = log;
    }

    public ActivityLog expectAnyOrder(String ... activities) {
        if (activities == null || activities.length == 0) {
            return this;
        }
        this.activities.add(new AnyOrder(activities));
        return this;
    }

    public ActivityLog expectExactOrder(String ... activities) {
        if (activities == null || activities.length == 0) {
            return this;
        }
        this.activities.add(new ExactOrder(activities));
        return this;
    }

    public synchronized void activity(String ... activity) {
        String[] stringArray = activity;
        int n = activity.length;
        int n2 = 0;
        while (n2 < n) {
            String a = stringArray[n2];
            if (!this.activityNoException(a)) {
                throw new RuntimeException("Unexpected activity: " + a + NEW_LINE + this);
            }
            ++n2;
        }
    }

    public synchronized boolean activityNoException(String ... activity) {
        String[] stringArray = activity;
        int n = activity.length;
        int n2 = 0;
        while (n2 < n) {
            String a = stringArray[n2];
            if (this.isEmpty()) {
                return false;
            }
            if (this.activities.get(0).isEmpty()) {
                this.activities.remove(0);
                if (this.isEmpty()) {
                    return false;
                }
            }
            if (!this.activities.get(0).checkNoException(a)) {
                return false;
            }
            this.log.info("Expected activity: " + a);
            while (!this.isEmpty() && this.activities.get(0).isEmpty()) {
                this.activities.remove(0);
            }
            ++n2;
        }
        return true;
    }

    public boolean isEmpty() {
        return this.activities.size() == 0;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("ActivityLog[");
        if (this.activities.size() == 0) {
            sb.append(NEW_LINE);
            sb.append("No more activities expected!");
        } else {
            for (IActivityCheck a : this.activities) {
                sb.append(NEW_LINE);
                sb.append(a);
            }
        }
        sb.append(NEW_LINE);
        sb.append("]");
        return sb.toString();
    }

    public void checkNoMoreActivityExpected() {
        if (this.isEmpty()) {
            this.log.info("No more activity expected, OK!");
            return;
        }
        throw new RuntimeException("More activity expected!" + NEW_LINE + this);
    }

    private static abstract class AbstractCheck
    implements IActivityCheck {
        private AbstractCheck() {
        }

        @Override
        public void check(String activity) {
            if (this.checkNoException(activity)) {
                return;
            }
            throw new RuntimeException("Unexpected activity: " + activity + NEW_LINE + this);
        }
    }

    private static class AnyOrder
    extends AbstractCheck {
        private Set<String> activities = new HashSet<String>();

        public AnyOrder(String ... activities) {
            this.add(activities);
        }

        @Override
        public void add(String ... activities) {
            String[] stringArray = activities;
            int n = activities.length;
            int n2 = 0;
            while (n2 < n) {
                String activity = stringArray[n2];
                this.activities.add(activity);
                ++n2;
            }
        }

        public String toString() {
            StringBuffer sb = new StringBuffer();
            sb.append("ActivityAnyOrder[");
            if (this.activities.size() == 0) {
                sb.append("NOTHING! activity.size() == 0");
            } else {
                for (String a : this.activities) {
                    sb.append(NEW_LINE);
                    sb.append(a);
                }
            }
            sb.append(NEW_LINE);
            sb.append("]");
            return sb.toString();
        }

        @Override
        public boolean checkNoException(String activity) {
            if (this.activities.contains(activity)) {
                this.activities.remove(activity);
                return true;
            }
            return false;
        }

        @Override
        public boolean isEmpty() {
            return this.activities.size() == 0;
        }
    }

    private static class ExactOrder
    extends AbstractCheck {
        private List<String> activities = new LinkedList<String>();

        public ExactOrder(String ... activities) {
            this.add(activities);
        }

        @Override
        public void add(String ... activities) {
            String[] stringArray = activities;
            int n = activities.length;
            int n2 = 0;
            while (n2 < n) {
                String activity = stringArray[n2];
                this.activities.add(activity);
                ++n2;
            }
        }

        public String toString() {
            StringBuffer sb = new StringBuffer();
            sb.append("ActivityExactOrder[");
            if (this.activities.size() == 0) {
                sb.append("    NOTHING! activity.size() == 0");
            } else {
                for (String a : this.activities) {
                    sb.append(NEW_LINE);
                    sb.append("    ");
                    sb.append(a);
                }
            }
            sb.append(NEW_LINE);
            sb.append("]");
            return sb.toString();
        }

        @Override
        public boolean checkNoException(String activity) {
            if (this.isEmpty()) {
                return false;
            }
            String checkingActivity = this.activities.get(0);
            if (checkingActivity.equals(activity)) {
                this.activities.remove(0);
                return true;
            }
            return false;
        }

        @Override
        public boolean isEmpty() {
            return this.activities.size() == 0;
        }
    }

    private static interface IActivityCheck {
        public void add(String ... var1);

        public void check(String var1);

        public boolean checkNoException(String var1);

        public boolean isEmpty();
    }
}

