/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.wss.impl.policy.mls;

import com.sun.xml.wss.XWSSecurityException;
import com.sun.xml.wss.impl.MessageConstants;
import com.sun.xml.wss.impl.PolicyTypeUtil;
import com.sun.xml.wss.impl.policy.PolicyGenerationException;
import com.sun.xml.wss.impl.policy.SecurityPolicy;
import com.sun.xml.wss.impl.policy.mls.EncryptionPolicy;
import com.sun.xml.wss.impl.policy.mls.EncryptionTarget;
import com.sun.xml.wss.impl.policy.mls.SignaturePolicy;
import com.sun.xml.wss.impl.policy.mls.SignatureTarget;
import com.sun.xml.wss.impl.policy.mls.Target;
import com.sun.xml.wss.impl.policy.mls.WSSPolicy;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.logging.Level;
import java.util.logging.Logger;

public class MessagePolicy
implements SecurityPolicy {
    protected static Logger log = Logger.getLogger("com.sun.xml.wss.logging.impl.configuration", "com.sun.xml.wss.logging.impl.configuration.LogStrings");
    private ArrayList info = new ArrayList();
    private ArrayList optionals = new ArrayList();
    private boolean dumpMessages = false;
    private boolean enableDynamicPolicyFlag = false;
    private boolean bsp = false;
    private int optimizedType = -1;

    public int getOptimizedType() {
        if (this.optimizedType != -1) {
            return this.optimizedType;
        }
        if (this.enableDynamicPolicy()) {
            this.optimizedType = MessageConstants.NOT_OPTIMIZED;
            return this.optimizedType;
        }
        StringBuffer securityOperation = new StringBuffer();
        securityOperation.append("_BODY");
        StringBuffer tmpBuffer = new StringBuffer("");
        SignatureTarget sigTarget = null;
        EncryptionTarget encTarget = null;
        WSSPolicy policy = null;
        String targetValue = null;
        int secureHeaders = -1;
        int secureAttachments = -1;
        HashMap<String, String> map = new HashMap<String, String>();
        ArrayList primaryPolicies = this.getPrimaryPolicies();
        ArrayList secondaryPolicies = this.getSecondaryPolicies();
        int size = primaryPolicies.size();
        int secondaryPoliciesSize = secondaryPolicies.size();
        if (size == 0 && secondaryPoliciesSize > 0) {
            this.optimizedType = MessageConstants.SECURITY_HEADERS;
            return this.optimizedType;
        }
        int iterator = 0;
        for (iterator = 0; iterator < secondaryPoliciesSize; ++iterator) {
            policy = (WSSPolicy)secondaryPolicies.get(iterator);
            if (policy.getType().intern() != "uri") continue;
            if (PolicyTypeUtil.usernameTokenPolicy(policy)) {
                map.put("UsernameToken", policy.getUUID());
                continue;
            }
            if (PolicyTypeUtil.timestampPolicy(policy)) {
                map.put("Timestamp", policy.getUUID());
                continue;
            }
            if (!PolicyTypeUtil.samlTokenPolicy(policy)) continue;
            map.put("Assertion", policy.getUUID());
        }
        for (iterator = 0; iterator < size; ++iterator) {
            int targetIterator;
            int targetBindingSize;
            WSSPolicy featureBinding;
            policy = (WSSPolicy)primaryPolicies.get(iterator);
            if (PolicyTypeUtil.signaturePolicy(policy)) {
                tmpBuffer.delete(0, tmpBuffer.length());
                featureBinding = (SignaturePolicy.FeatureBinding)policy.getFeatureBinding();
                targetBindingSize = ((SignaturePolicy.FeatureBinding)featureBinding).getTargetBindings().size();
                for (targetIterator = 0; targetIterator < targetBindingSize; ++targetIterator) {
                    SignatureTarget.Transform transform;
                    sigTarget = (SignatureTarget)((SignaturePolicy.FeatureBinding)featureBinding).getTargetBindings().get(targetIterator);
                    if (sigTarget != null && sigTarget.getTransforms().size() > 1) {
                        this.optimizedType = MessageConstants.NOT_OPTIMIZED;
                        return this.optimizedType;
                    }
                    if (sigTarget.getTransforms().size() == 1 && (transform = (SignatureTarget.Transform)sigTarget.getTransforms().get(0)) != null && transform.getTransform().intern() != "http://www.w3.org/2001/10/xml-exc-c14n#") {
                        this.optimizedType = MessageConstants.NOT_OPTIMIZED;
                        return this.optimizedType;
                    }
                    if (sigTarget.getType().intern() == "qname") {
                        targetValue = sigTarget.getQName().getLocalPart().intern();
                    } else if (sigTarget.getType().intern() == "uri") {
                        if (map.containsKey(sigTarget.getValue())) {
                            targetValue = map.get(sigTarget.getValue()).toString();
                        } else if (sigTarget.getValue().intern() == "attachmentRef:attachment" || sigTarget.getValue().startsWith("cid:")) {
                            targetValue = "Attachment";
                        }
                    } else if (sigTarget.getType().intern() == "xpath") {
                        this.optimizedType = MessageConstants.NOT_OPTIMIZED;
                        return this.optimizedType;
                    }
                    if (targetValue == "Body") {
                        if (tmpBuffer.indexOf("_SIGN") != -1) continue;
                        tmpBuffer.append("_SIGN");
                        if (secureHeaders == 1 || secureHeaders == -1) {
                            secureHeaders = 0;
                        }
                        if (secureAttachments != 1 && secureAttachments != -1) continue;
                        secureAttachments = 0;
                        continue;
                    }
                    if (targetValue == "Timestamp" || targetValue == "UsernameToken" || targetValue == "Assertion") {
                        if (secureHeaders != -1) continue;
                        secureHeaders = 1;
                        continue;
                    }
                    if (targetValue == "Attachment") {
                        if (secureAttachments != -1) continue;
                        secureAttachments = 1;
                        continue;
                    }
                    return MessageConstants.NOT_OPTIMIZED;
                }
                securityOperation.insert(securityOperation.indexOf("_BODY"), tmpBuffer.toString());
                continue;
            }
            if (!PolicyTypeUtil.encryptionPolicy(policy)) continue;
            tmpBuffer.delete(0, tmpBuffer.length());
            featureBinding = (EncryptionPolicy.FeatureBinding)policy.getFeatureBinding();
            targetBindingSize = ((EncryptionPolicy.FeatureBinding)featureBinding).getTargetBindings().size();
            for (targetIterator = 0; targetIterator < targetBindingSize; ++targetIterator) {
                encTarget = (EncryptionTarget)((EncryptionPolicy.FeatureBinding)featureBinding).getTargetBindings().get(targetIterator);
                if (encTarget.getType().intern() == "qname") {
                    targetValue = encTarget.getQName().getLocalPart().intern();
                } else if (encTarget.getType().intern() == "uri") {
                    if (map.containsKey(encTarget.getValue())) {
                        targetValue = map.get(encTarget.getValue()).toString();
                    } else if (encTarget.getValue().intern() == "attachmentRef:attachment" || encTarget.getValue().startsWith("cid:")) {
                        targetValue = "Attachment";
                    }
                } else if (encTarget.getType().intern() == "xpath") {
                    this.optimizedType = MessageConstants.NOT_OPTIMIZED;
                    return this.optimizedType;
                }
                if (targetValue == "Body") {
                    if (tmpBuffer.indexOf("_ENCRYPT") != -1) continue;
                    tmpBuffer.append("_ENCRYPT");
                    if (secureHeaders == 1 || secureHeaders == -1) {
                        secureHeaders = 0;
                    }
                    if (secureAttachments != 1 && secureAttachments != -1) continue;
                    secureAttachments = 0;
                    continue;
                }
                if (targetValue == "Timestamp" || targetValue == "UsernameToken" || targetValue == "Assertion") {
                    if (secureHeaders != -1) continue;
                    secureHeaders = 1;
                    continue;
                }
                if (targetValue == "Attachment") {
                    if (secureAttachments != -1) continue;
                    secureAttachments = 1;
                    continue;
                }
                return MessageConstants.NOT_OPTIMIZED;
            }
            securityOperation.insert(securityOperation.indexOf("_BODY"), tmpBuffer.toString());
        }
        if (secureHeaders == 1 && secureAttachments != 1) {
            this.optimizedType = MessageConstants.SECURITY_HEADERS;
            return this.optimizedType;
        }
        if (secureAttachments == 1 && secureAttachments != 1) {
            this.optimizedType = MessageConstants.SECURE_ATTACHMENTS;
            return this.optimizedType;
        }
        if (secureHeaders == 1 && secureAttachments == 1) {
            this.optimizedType = MessageConstants.SECURITY_HEADERS_AND_ATTACHMENTS;
            return this.optimizedType;
        }
        String type = securityOperation.toString().intern();
        if (type == "_SIGN_BODY") {
            this.optimizedType = MessageConstants.SIGN_BODY;
        } else if (type == "_SIGN_ENCRYPT_BODY") {
            this.optimizedType = MessageConstants.SIGN_ENCRYPT_BODY;
        } else if (type == "_ENCRYPT_SIGN_BODY") {
            this.optimizedType = MessageConstants.NOT_OPTIMIZED;
        } else if (type == "_ENCRYPT_BODY") {
            this.optimizedType = MessageConstants.NOT_OPTIMIZED;
        }
        return this.optimizedType;
    }

    public void append(SecurityPolicy item) throws PolicyGenerationException {
        this.info.add(item);
    }

    public void prepend(SecurityPolicy item) throws PolicyGenerationException {
        this.info.add(0, item);
    }

    public void appendAll(Collection items) throws PolicyGenerationException {
        Iterator i = items.iterator();
        while (i.hasNext()) {
            SecurityPolicy securityPolicy = (SecurityPolicy)i.next();
        }
        this.info.addAll(items);
    }

    public void removeAll() {
        this.info.clear();
    }

    public int size() {
        return this.info.size();
    }

    public SecurityPolicy get(int index) throws Exception {
        if (!this.optionals.isEmpty()) {
            this.addOptionals();
        }
        return (SecurityPolicy)this.info.get(index);
    }

    public Iterator iterator() {
        if (!this.optionals.isEmpty()) {
            this.addOptionals();
        }
        return this.info.iterator();
    }

    public boolean isEmpty() {
        return this.info.isEmpty();
    }

    public void remove(SecurityPolicy item) {
        int i = this.info.indexOf(item);
        if (i == -1) {
            return;
        }
        this.info.remove(i);
    }

    public void insertBefore(SecurityPolicy existing, SecurityPolicy additional) throws PolicyGenerationException {
        int i = this.info.indexOf(existing);
        if (i == -1) {
            return;
        }
        this.info.add(i, additional);
    }

    public void dumpMessages(boolean dump) {
        this.dumpMessages = dump;
    }

    public boolean dumpMessages() {
        return this.dumpMessages;
    }

    public void enableDynamicPolicy(boolean flag) {
        this.enableDynamicPolicyFlag = flag;
    }

    public boolean enableDynamicPolicy() {
        return this.enableDynamicPolicyFlag;
    }

    public void isBSP(boolean flag) {
        this.bsp = flag;
    }

    public boolean isBSP() {
        return this.bsp;
    }

    public void removeOptionalTargets() {
        this.optionals.clear();
    }

    public void addOptionalTargets(ArrayList optionls) throws XWSSecurityException {
        Iterator i = optionls.iterator();
        while (i.hasNext()) {
            try {
                Target target = (Target)i.next();
                target.setEnforce(false);
            }
            catch (ClassCastException cce) {
                String message = "Target should be of types: com.sun.xml.wss.impl.policy.mls.SignatureTarget OR com.sun.xml.wss.impl.policy.mls.EncryptionTarget";
                log.log(Level.SEVERE, "WSS1100.classcast.target", new Object[]{message});
                throw new XWSSecurityException(message, cce);
            }
        }
        this.optionals.addAll(optionls);
    }

    public void addOptionalTarget(Target target) {
        target.setEnforce(false);
        this.optionals.add(target);
    }

    public boolean equals(MessagePolicy policy) {
        boolean assrt;
        boolean bl = assrt = policy.dumpMessages() && policy.enableDynamicPolicy();
        if (assrt) {
            ArrayList primary0 = this.getPrimaryPolicies();
            ArrayList secdary0 = this.getSecondaryPolicies();
            ArrayList primary1 = policy.getPrimaryPolicies();
            ArrayList secdary1 = policy.getSecondaryPolicies();
            if (primary0.equals(primary1) && secdary0.equals(secdary1)) {
                assrt = true;
            }
        }
        return assrt;
    }

    public ArrayList getPrimaryPolicies() {
        ArrayList<SecurityPolicy> list = new ArrayList<SecurityPolicy>();
        Iterator i = this.iterator();
        while (i.hasNext()) {
            SecurityPolicy policy = (SecurityPolicy)i.next();
            if (!PolicyTypeUtil.encryptionPolicy(policy) && !PolicyTypeUtil.signaturePolicy(policy)) continue;
            list.add(policy);
        }
        return list;
    }

    public ArrayList getSecondaryPolicies() {
        ArrayList<SecurityPolicy> list = new ArrayList<SecurityPolicy>();
        Iterator i = this.iterator();
        while (i.hasNext()) {
            SecurityPolicy policy = (SecurityPolicy)i.next();
            if (!PolicyTypeUtil.authenticationTokenPolicy(policy) && !PolicyTypeUtil.timestampPolicy(policy)) continue;
            list.add(policy);
        }
        return list;
    }

    private void addOptionals() {
        Iterator j = this.info.iterator();
        while (j.hasNext()) {
            SecurityPolicy policy = (SecurityPolicy)j.next();
            if (!(policy instanceof WSSPolicy)) continue;
            this.processWSSPolicy((WSSPolicy)policy);
        }
        this.optionals.clear();
    }

    private void processWSSPolicy(WSSPolicy policy) {
        block3: {
            block2: {
                if (!PolicyTypeUtil.signaturePolicy(policy)) break block2;
                SignaturePolicy sPolicy = (SignaturePolicy)policy;
                SignaturePolicy.FeatureBinding fBinding = (SignaturePolicy.FeatureBinding)sPolicy.getFeatureBinding();
                Iterator it = this.optionals.iterator();
                while (it.hasNext()) {
                    fBinding.addTargetBinding((Target)it.next());
                }
                break block3;
            }
            if (!PolicyTypeUtil.encryptionPolicy(policy)) break block3;
            EncryptionPolicy ePolicy = (EncryptionPolicy)policy;
            EncryptionPolicy.FeatureBinding fBinding = (EncryptionPolicy.FeatureBinding)ePolicy.getFeatureBinding();
            Iterator it = this.optionals.iterator();
            while (it.hasNext()) {
                fBinding.addTargetBinding((Target)it.next());
            }
        }
    }

    public String getType() {
        return "MessagePolicy";
    }
}

