/*
 * Decompiled with CFR 0.152.
 */
package jason.stdlib;

import jason.JasonException;
import jason.asSemantics.DefaultInternalAction;
import jason.asSemantics.InternalAction;
import jason.asSemantics.TransitionSystem;
import jason.asSemantics.Unifier;
import jason.asSyntax.ListTerm;
import jason.asSyntax.NumberTerm;
import jason.asSyntax.Term;

public class nth
extends DefaultInternalAction {
    private static InternalAction singleton = null;

    public static InternalAction create() {
        if (singleton == null) {
            singleton = new nth();
        }
        return singleton;
    }

    public int getMinArgs() {
        return 3;
    }

    public int getMaxArgs() {
        return 3;
    }

    protected void checkArguments(Term[] args) throws JasonException {
        super.checkArguments(args);
        if (!args[0].isNumeric()) {
            throw JasonException.createWrongArgument(this, "first argument should be numeric and not '" + args[0] + "'.");
        }
        if (!args[1].isList()) {
            throw JasonException.createWrongArgument(this, "second argument should be a list and not '" + args[1] + "'.");
        }
    }

    public Object execute(TransitionSystem ts, Unifier un, Term[] args) throws Exception {
        this.checkArguments(args);
        int index = (int)((NumberTerm)args[0]).solve();
        ListTerm list2 = (ListTerm)args[1];
        if (index < 0 || index >= list2.size()) {
            throw new JasonException("nth: index " + index + " is out of bounds (" + list2.size() + ")");
        }
        Term element = (Term)list2.get(index);
        return un.unifies(args[2], element);
    }
}

