/*
 * Decompiled with CFR 0.152.
 */
package jason.stdlib;

import jason.JasonException;
import jason.asSemantics.DefaultInternalAction;
import jason.asSemantics.IntendedMeans;
import jason.asSemantics.InternalAction;
import jason.asSemantics.TransitionSystem;
import jason.asSemantics.Unifier;
import jason.asSyntax.Literal;
import jason.asSyntax.LogicalFormula;
import jason.asSyntax.PlanBody;
import jason.asSyntax.Term;
import java.util.Iterator;

public class if_then_else
extends DefaultInternalAction {
    private static InternalAction singleton = null;

    public static InternalAction create() {
        if (singleton == null) {
            singleton = new if_then_else();
        }
        return singleton;
    }

    public Term[] prepareArguments(Literal body, Unifier un) {
        return body.getTermsArray();
    }

    public int getMinArgs() {
        return 2;
    }

    public int getMaxArgs() {
        return 3;
    }

    protected void checkArguments(Term[] args) throws JasonException {
        super.checkArguments(args);
        if (!(args[0] instanceof LogicalFormula)) {
            throw JasonException.createWrongArgument(this, "first argument (test) must be a logical formula.");
        }
        if (!args[1].isPlanBody()) {
            throw JasonException.createWrongArgument(this, "second argument (then) must be a plan body term.");
        }
        if (args.length == 3 && !args[2].isPlanBody()) {
            throw JasonException.createWrongArgument(this, "third argument (else) must be a plan body term.");
        }
    }

    public Object execute(TransitionSystem ts, Unifier un, Term[] args) throws Exception {
        this.checkArguments(args);
        LogicalFormula logExpr = (LogicalFormula)args[0];
        PlanBody whattoadd = null;
        Iterator<Unifier> iu = logExpr.logicalConsequence(ts.getAg(), un);
        if (iu.hasNext()) {
            whattoadd = (PlanBody)args[1].clone();
            un.compose(iu.next());
        } else if (args.length == 3) {
            whattoadd = (PlanBody)args[2].clone();
        }
        if (whattoadd != null) {
            IntendedMeans im = ts.getC().getSelectedIntention().peek();
            whattoadd.add(im.getCurrentStep().getBodyNext());
            whattoadd.setAsBodyTerm(false);
            im.insertAsNextStep(whattoadd);
        }
        return true;
    }
}

