/*
 * Decompiled with CFR 0.152.
 */
package jason.runtime;

import jason.infra.centralised.RunCentralisedMAS;
import jason.runtime.MASConsoleLogHandler;
import jason.runtime.OutputStreamAdapter;
import java.awt.BorderLayout;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.FileWriter;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.LogManager;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;

public class MASConsoleGUI {
    private static MASConsoleGUI masConsole = null;
    public static String isTabbedPropField = MASConsoleLogHandler.class.getName() + ".tabbed";
    private boolean isTabbed = false;
    private Map<String, JTextArea> agsTextArea = new HashMap<String, JTextArea>();
    private JTabbedPane tabPane;
    private JFrame frame = null;
    private JTextArea output;
    private JPanel pBt = null;
    private OutputStreamAdapter out;
    private boolean inPause = false;

    public static MASConsoleGUI get() {
        if (masConsole == null) {
            masConsole = new MASConsoleGUI("MAS Console");
        }
        return masConsole;
    }

    public static boolean hasConsole() {
        return masConsole != null;
    }

    private MASConsoleGUI(String title) {
        String tabbed = LogManager.getLogManager().getProperty(isTabbedPropField);
        if (tabbed != null && tabbed.equals("true")) {
            this.isTabbed = true;
        }
        this.frame = new JFrame(title);
        this.frame.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e2) {
                MASConsoleGUI.this.close();
            }
        });
        this.output = new JTextArea();
        this.output.setEditable(false);
        JPanel pcenter = new JPanel(new BorderLayout());
        if (this.isTabbed) {
            this.tabPane = new JTabbedPane(2);
            this.tabPane.add("common", new JScrollPane(this.output));
            pcenter.add("Center", this.tabPane);
        } else {
            pcenter.add("Center", new JScrollPane(this.output));
        }
        this.pBt = new JPanel();
        this.pBt.setLayout(new FlowLayout(1));
        this.frame.getContentPane().setLayout(new BorderLayout());
        this.frame.getContentPane().add("Center", pcenter);
        this.frame.getContentPane().add("South", this.pBt);
        JButton btClean = new JButton("Clean", new ImageIcon(RunCentralisedMAS.class.getResource("/images/clear.gif")));
        btClean.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                MASConsoleGUI.this.output.setText("");
            }
        });
        this.addButton(btClean);
        this.frame.setBounds(200, 20, 824, 500);
    }

    public void setTitle(String s) {
        this.frame.setTitle(s);
    }

    public JFrame getFrame() {
        return this.frame;
    }

    public void addButton(JButton jb) {
        this.pBt.add(jb);
        this.pBt.revalidate();
    }

    public synchronized void setPause(boolean b) {
        this.inPause = b;
        this.notifyAll();
    }

    synchronized void waitNotPause() {
        try {
            while (this.inPause) {
                this.wait();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public boolean isPause() {
        return this.inPause;
    }

    public void append(String s) {
        this.append(null, s);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void append(String agName, String s) {
        try {
            int l;
            if (!this.frame.isVisible()) {
                this.frame.setVisible(true);
            }
            if (this.inPause) {
                this.waitNotPause();
            }
            if (this.isTabbed && agName != null) {
                JTextArea ta = this.agsTextArea.get(agName);
                if (ta == null) {
                    ta = new JTextArea();
                    ta.setEditable(false);
                    this.agsTextArea.put(agName, ta);
                    this.tabPane.add(agName, new JScrollPane(ta));
                }
                if (ta != null) {
                    int l2 = ta.getDocument().getLength();
                    if (l2 > 100000) {
                        ta.setText("");
                    }
                    ta.append(s);
                }
            }
            if ((l = this.output.getDocument().getLength()) > 60000) {
                this.output.setText("");
            }
            MASConsoleGUI mASConsoleGUI = this;
            synchronized (mASConsoleGUI) {
                this.output.append(s);
            }
        }
        catch (Exception e2) {
            this.close();
            System.out.println(e2);
        }
    }

    public void close() {
        this.setPause(false);
        if (masConsole != null && MASConsoleGUI.masConsole.frame != null) {
            MASConsoleGUI.masConsole.frame.setVisible(false);
        }
        if (this.out != null) {
            this.out.restoreOriginalOut();
        }
        try {
            if (RunCentralisedMAS.getRunner() != null) {
                FileWriter f = new FileWriter(".stop___MAS");
                f.write(32);
                f.close();
            }
        }
        catch (Exception e2) {
            e2.printStackTrace();
        }
        masConsole = null;
    }

    public void setAsDefaultOut() {
        this.out = new OutputStreamAdapter(this, null);
        this.out.setAsDefaultOut();
    }
}

