/*
 * Decompiled with CFR 0.152.
 */
package jason.jeditplugin;

import jason.jeditplugin.Config;
import jason.jeditplugin.NewAgentGUI;
import java.awt.BorderLayout;
import java.awt.Component;
import java.io.File;
import javax.swing.BorderFactory;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.gjt.sp.jedit.Buffer;
import org.gjt.sp.jedit.View;
import org.gjt.sp.jedit.jEdit;

public class NewInternalActionGUI
extends NewAgentGUI {
    private static final long serialVersionUID = 1L;
    private JTextField iaClass;
    private JTextField iaPkg;

    public NewInternalActionGUI(String title, Buffer b, View view) {
        super(title, b, view, ".");
    }

    protected void initComponents() {
        this.getContentPane().setLayout(new BorderLayout());
        this.iaPkg = new JTextField(20);
        this.createField("Java package", this.iaPkg, "Enter the name of the Java package of the new internal action here.");
        this.iaClass = new JTextField(20);
        this.createField("Internal action name", this.iaClass, "Enter the name of the new internal action class here.");
        JPanel p = new JPanel(new BorderLayout());
        p.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "New internal action parameters", 1, 2));
        p.add((Component)this.pLabels, "Center");
        p.add((Component)this.pFields, "East");
        this.getContentPane().add((Component)p, "Center");
        this.getContentPane().add((Component)this.createButtonsPanel(), "South");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean ok() {
        String iaFile;
        if (this.iaPkg.getText().trim().length() == 0) {
            JOptionPane.showMessageDialog(this, "A package name must be informed.");
            return false;
        }
        if (this.iaClass.getText().trim().length() == 0) {
            JOptionPane.showMessageDialog(this, "A name for the internal action must be informed.");
            return false;
        }
        String pck = this.iaPkg.getText().trim();
        String pckDir = pck.replace('.', '/');
        try {
            new File(this.buffer.getDirectory() + pckDir).mkdirs();
        }
        catch (Exception e2) {
            // empty catch block
        }
        String ia = this.iaClass.getText().trim();
        if (Character.isUpperCase(ia.charAt(0))) {
            ia = Character.toLowerCase(ia.charAt(0)) + ia.substring(1);
        }
        boolean newFile = !new File(iaFile = this.buffer.getDirectory() + pckDir + File.separator + ia + ".java").exists();
        Buffer nb = jEdit.openFile((View)this.view, (String)iaFile);
        if (newFile) {
            try {
                nb.writeLock();
                nb.insert(0, this.getIAText(pck, ia));
                nb.save(this.view, iaFile);
            }
            finally {
                nb.writeUnlock();
            }
        }
        return true;
    }

    String getIAText(String pck, String className) {
        String iaCode = Config.get().getTemplate("ia");
        iaCode = iaCode.replaceAll("<IA_NAME>", className);
        iaCode = iaCode.replaceAll("<PCK>", pck);
        iaCode = iaCode.replaceAll("<PROJECT_NAME>", this.buffer.getName());
        return iaCode;
    }
}

