/*
 * Decompiled with CFR 0.152.
 */
package jason.infra.saci;

import jason.JasonException;
import jason.architecture.AgArch;
import jason.architecture.AgArchInfraTier;
import jason.asSemantics.ActionExec;
import jason.asSemantics.TransitionSystem;
import jason.asSyntax.ListTermImpl;
import jason.asSyntax.Structure;
import jason.asSyntax.Term;
import jason.infra.centralised.RunCentralisedMAS;
import jason.infra.saci.SaciRuntimeServices;
import jason.mas2j.ClassParameters;
import jason.mas2j.parser.mas2j;
import jason.runtime.MASConsoleGUI;
import jason.runtime.RuntimeServicesInfraTier;
import jason.runtime.Settings;
import java.io.StringReader;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.w3c.dom.Document;
import saci.Agent;
import saci.Config;
import saci.MBoxChangedListener;
import saci.MBoxSAg;
import saci.Message;
import saci.MessageHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SaciAgArch
extends Agent
implements AgArchInfraTier {
    private static final long serialVersionUID = 1L;
    private MBoxSAg mboxPercept = null;
    protected AgArch userAgArch;
    private Map<String, ActionExec> myPA = new HashMap<String, ActionExec>();
    private Logger logger;
    private Object sleepSync = new Object();
    private Object syncMonitor = new Object();
    private boolean inWaitSyncMonitor = false;
    private static Message cycleFinished = new Message("(tell :receiver controller :ontology AS-ExecControl :content cycleFinished)");

    public void initAg(String[] args) throws JasonException {
        RunCentralisedMAS.setupLogger();
        this.logger = Logger.getLogger(SaciAgArch.class.getName() + "." + this.getAgName());
        if (MASConsoleGUI.hasConsole()) {
            MASConsoleGUI.get().setTitle("MAS Console - " + this.getSociety());
            MASConsoleGUI.get().setAsDefaultOut();
        }
        try {
            String archClassName = null;
            if (args.length < 1) {
                throw new JasonException("The Agent Architecture class name was not informed for the SaciAgArch creation!");
            }
            archClassName = args[0].trim();
            String agClassName = null;
            if (args.length < 2) {
                throw new JasonException("The Agent class name was not informed for the CentralisedAgArch creation!");
            }
            agClassName = args[1].trim();
            mas2j parser = new mas2j(new StringReader(args[2].replace('$', '\"')));
            ClassParameters bbPars = parser.classDef();
            String asSource = null;
            if (args.length < 3) {
                throw new JasonException("The AgentSpeak source file was not informed, cannot create the Agent!");
            }
            asSource = args[3].trim();
            Settings stts = new Settings();
            if (args.length > 4 && args[4].equals("options")) {
                stts.setOptions("[" + args[5] + "]");
            }
            this.userAgArch = (AgArch)Class.forName(archClassName).newInstance();
            this.userAgArch.setArchInfraTier(this);
            this.userAgArch.initAg(agClassName, bbPars, asSource, stts);
            if (this.userAgArch.getTS().getSettings().verbose() >= 0) {
                this.logger.setLevel(this.userAgArch.getTS().getSettings().logLevel());
            }
        }
        catch (Exception e2) {
            this.running = false;
            throw new JasonException("as2j: error creating the agent class! - " + e2.getMessage());
        }
        try {
            Config c = new Config();
            c.set("society.name", (Object)(this.getMBox().getSociety() + "-env"));
            this.mboxPercept = new MBoxSAg(this.getMBox().getName(), c);
            this.mboxPercept.init();
            this.mboxPercept.setMboxChangedListener(new MBoxChangedListener(){

                public void mboxChanged() {
                    SaciAgArch.this.wake();
                }
            });
            this.mboxPercept.addMessageHandler("performCycle", "tell", null, "AS-ExecControl", new MessageHandler(){

                public boolean processMessage(Message m) {
                    int cycle = Integer.parseInt(m.get((Object)"cycle").toString());
                    SaciAgArch.this.userAgArch.setCycleNumber(cycle);
                    SaciAgArch.this.receiveSyncSignal();
                    return true;
                }
            });
            this.mboxPercept.addMessageHandler("agState", "ask", null, "AS-ExecControl", new MessageHandler(){

                public boolean processMessage(Message m) {
                    Message r = new Message("(tell)");
                    r.put((Object)"receiver", m.get((Object)"sender"));
                    r.put((Object)"in-reply-to", m.get((Object)"reply-with"));
                    r.put((Object)"ontology", m.get((Object)"ontology"));
                    try {
                        Document agStateDoc = SaciAgArch.this.userAgArch.getTS().getAg().getAgState();
                        r.putWithoutSerialization((Object)"content", (Object)agStateDoc);
                        SaciAgArch.this.mboxPercept.sendMsg(r);
                    }
                    catch (Exception e2) {
                        SaciAgArch.this.logger.log(Level.SEVERE, "Error sending message " + r, e2);
                    }
                    return true;
                }
            });
            this.getMBox().setMboxChangedListener(new MBoxChangedListener(){

                public void mboxChanged() {
                    SaciAgArch.this.wake();
                }
            });
        }
        catch (Exception e3) {
            this.logger.log(Level.SEVERE, "Error entering the environment's society.", e3);
        }
    }

    @Override
    public String getAgName() {
        return super.getName();
    }

    @Override
    public void stopAg() {
        this.running = false;
        new Thread(){

            public void run() {
                SaciAgArch.this.userAgArch.stopAg();
            }
        }.start();
        this.receiveSyncSignal();
        this.wake();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void sleep() {
        block6: {
            try {
                if (this.userAgArch.getTS().getSettings().isSync()) break block6;
                this.logger.fine("Entering in sleep mode....");
                Object object = this.sleepSync;
                synchronized (object) {
                    this.sleepSync.wait(1000L);
                }
            }
            catch (InterruptedException e2) {
            }
            catch (Exception e3) {
                this.logger.log(Level.WARNING, "Error waiting mgs", e3);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void wake() {
        Object object = this.sleepSync;
        synchronized (object) {
            this.sleepSync.notifyAll();
        }
    }

    public void run() {
        while (this.running) {
            TransitionSystem ts = this.userAgArch.getTS();
            while (this.running) {
                if (ts.getSettings().isSync()) {
                    this.waitSyncSignal();
                    ts.reasoningCycle();
                    boolean isBreakPoint = false;
                    try {
                        isBreakPoint = ts.getC().getSelectedOption().getPlan().hasBreakpoint();
                        if (this.logger.isLoggable(Level.FINE)) {
                            this.logger.fine("Informing controller that I finished a reasoning cycle " + this.userAgArch.getCycleNumber() + ". Breakpoint is " + isBreakPoint);
                        }
                    }
                    catch (NullPointerException nullPointerException) {
                        // empty catch block
                    }
                    this.informCycleFinished(isBreakPoint, this.userAgArch.getCycleNumber());
                    continue;
                }
                ts.reasoningCycle();
            }
        }
        super.stopAg();
        this.mboxPercept.disconnect();
        this.logger.fine("finished running.\n");
    }

    public List perceive() {
        if (!this.running) {
            return null;
        }
        List<Term> percepts = null;
        Message askMsg = new Message("(ask-all :receiver environment :ontology AS-Perception :content getPercepts)");
        Message m = null;
        try {
            m = this.mboxPercept.ask(askMsg);
        }
        catch (Exception e2) {
            this.logger.log(Level.SEVERE, "Error receiving percepts.", e2);
        }
        if (m != null) {
            Object content = m.get((Object)"content");
            if (content != null && content.toString().startsWith("[")) {
                percepts = ListTermImpl.parseList(content.toString()).getAsList();
                if (this.logger.isLoggable(Level.FINE)) {
                    this.logger.fine("received percepts: " + percepts);
                }
            } else {
                percepts = null;
            }
        }
        try {
            do {
                if ((m = this.mboxPercept.receive()) == null || m.get((Object)"ontology") == null || !((String)m.get((Object)"ontology")).equals("AS-Action")) continue;
                String irt = (String)m.get((Object)"in-reply-to");
                if (irt != null) {
                    ActionExec a = this.myPA.remove(irt);
                    if (a != null) {
                        if (((String)m.get((Object)"content")).equals("ok")) {
                            a.setResult(true);
                        } else {
                            a.setResult(false);
                        }
                        this.userAgArch.getTS().getC().addFeedbackAction(a);
                        continue;
                    }
                    this.logger.log(Level.SEVERE, "Error: received feedback for an Action that is not pending.");
                    continue;
                }
                throw new JasonException("Cannot identify executed action.");
            } while (m != null);
        }
        catch (Exception e3) {
            this.logger.log(Level.SEVERE, "Error receiving message.", e3);
        }
        return percepts;
    }

    @Override
    public void sendMsg(jason.asSemantics.Message m) throws Exception {
        Message msaci = this.jasonToKQML(m);
        msaci.put((Object)"receiver", (Object)m.getReceiver());
        if (m.getInReplyTo() != null) {
            msaci.put((Object)"in-reply-to", (Object)m.getInReplyTo());
        }
        this.getMBox().sendMsg(msaci);
    }

    @Override
    public void broadcast(jason.asSemantics.Message m) throws Exception {
        Message msaci = this.jasonToKQML(m);
        this.getMBox().broadcast(msaci);
    }

    private Message jasonToKQML(jason.asSemantics.Message m) {
        Message msaci = new Message("(" + m.getIlForce() + ")");
        if (m.getPropCont() instanceof Term) {
            msaci.put((Object)"content", (Object)m.getPropCont().toString());
        } else {
            msaci.put((Object)"content", m.getPropCont());
        }
        msaci.put((Object)"reply-with", (Object)m.getMsgId());
        msaci.put((Object)"language", (Object)"AgentSpeak");
        return msaci;
    }

    @Override
    public void checkMail() {
        if (!this.running) {
            return;
        }
        if (this.getMBox() == null) {
            this.logger.warning("I have no mail box!");
            return;
        }
        Message m = null;
        do {
            try {
                m = this.getMBox().receive();
            }
            catch (Exception e2) {
                this.logger.log(Level.SEVERE, "Error receiving message.", e2);
            }
            if (m == null) continue;
            if (this.logger.isLoggable(Level.FINE)) {
                this.logger.fine("Received message: " + m + ". Content class is " + m.get((Object)"content").getClass().getName());
            }
            String ilForce = (String)m.get((Object)"performative");
            String sender = (String)m.get((Object)"sender");
            String receiver = (String)m.get((Object)"receiver");
            String replyWith = (String)m.get((Object)"reply-with");
            String irt = (String)m.get((Object)"in-reply-to");
            Object propCont = m.get((Object)"content");
            if (propCont == null) continue;
            jason.asSemantics.Message im = new jason.asSemantics.Message(ilForce, sender, receiver, propCont, replyWith);
            if (irt != null) {
                im.setInReplyTo(irt);
            }
            this.userAgArch.getTS().getC().getMailBox().add(im);
        } while (m != null);
    }

    @Override
    public void act(ActionExec action, List<ActionExec> feedback) {
        if (!this.running) {
            return;
        }
        TransitionSystem ts = this.userAgArch.getTS();
        try {
            Structure acTerm = action.getActionTerm();
            this.logger.fine("doing: " + acTerm);
            String rw = this.mboxPercept.getRW();
            Message m = new Message("(ask :receiver environment :ontology AS-Action :content execute)");
            m.put((Object)"action", (Object)((Object)acTerm).toString());
            m.put((Object)"reply-with", (Object)rw);
            m.put((Object)"verbose", (Object)new Integer(ts.getSettings().verbose()).toString());
            this.mboxPercept.sendMsg(m);
            this.myPA.put(rw, action);
        }
        catch (Exception e2) {
            this.logger.log(Level.SEVERE, "Error sending action " + ts.getC().getAction(), e2);
        }
    }

    @Override
    public boolean canSleep() {
        try {
            return this.getMBox().getMessages(null, 1, 0L, false).size() == 0 && this.isRunning();
        }
        catch (Exception e2) {
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void waitSyncSignal() {
        try {
            Object object = this.syncMonitor;
            synchronized (object) {
                this.inWaitSyncMonitor = true;
                this.syncMonitor.wait();
                this.inWaitSyncMonitor = false;
            }
        }
        catch (InterruptedException e2) {
        }
        catch (Exception e3) {
            this.logger.log(Level.WARNING, "Error waiting sync (1)", e3);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void receiveSyncSignal() {
        if (this.userAgArch.getTS().getSettings().isSync()) {
            try {
                Object object = this.syncMonitor;
                synchronized (object) {
                    while (!this.inWaitSyncMonitor && this.isRunning()) {
                        this.syncMonitor.wait(50L);
                    }
                    this.syncMonitor.notifyAll();
                }
            }
            catch (InterruptedException e2) {
            }
            catch (Exception e3) {
                this.logger.log(Level.WARNING, "Error waiting sync (2)", e3);
            }
        }
    }

    public void informCycleFinished(boolean breakpoint, int cycle) {
        Message m = (Message)cycleFinished.clone();
        if (breakpoint) {
            m.put((Object)"breakpoint", (Object)"true");
        }
        m.put((Object)"cycle", (Object)String.valueOf(cycle));
        this.mboxPercept.sendMsg(m);
    }

    @Override
    public RuntimeServicesInfraTier getRuntimeServices() {
        return new SaciRuntimeServices(this.getSociety());
    }
}

