/*
 * Decompiled with CFR 0.152.
 */
package jason.infra.jade;

import jade.core.AID;
import jade.core.behaviours.Behaviour;
import jade.core.behaviours.CyclicBehaviour;
import jade.core.behaviours.OneShotBehaviour;
import jade.lang.acl.ACLMessage;
import jade.wrapper.ContainerController;
import jason.control.ExecutionControl;
import jason.control.ExecutionControlInfraTier;
import jason.infra.jade.JadeAg;
import jason.infra.jade.JadeRuntimeServices;
import jason.mas2j.ClassParameters;
import jason.runtime.RuntimeServicesInfraTier;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.w3c.dom.Document;

public class JadeExecutionControl
extends JadeAg
implements ExecutionControlInfraTier {
    public static String controllerOntology = "AS-ExecControl";
    private ExecutionControl userControl;
    private ExecutorService executor;
    private Document state = null;
    private Object syncWaitState = new Object();

    public void setup() {
        this.logger = Logger.getLogger(JadeExecutionControl.class.getName());
        try {
            Object[] args = this.getArguments();
            if (args != null && args.length > 0) {
                if (args[0] instanceof ClassParameters) {
                    ClassParameters ecp = (ClassParameters)args[0];
                    this.userControl = (ExecutionControl)Class.forName(ecp.getClassName()).newInstance();
                    this.userControl.setExecutionControlInfraTier(this);
                    this.userControl.init(ecp.getParametersArray());
                } else {
                    this.userControl = (ExecutionControl)Class.forName(args[0].toString()).newInstance();
                    this.userControl.setExecutionControlInfraTier(this);
                    if (args.length > 1) {
                        this.logger.warning("Execution control arguments is not implemented yet (ask it to us if you need)!");
                    }
                }
            } else {
                this.logger.warning("Using default execution control.");
                this.userControl = new ExecutionControl();
                this.userControl.setExecutionControlInfraTier(this);
            }
        }
        catch (Exception e2) {
            this.logger.log(Level.SEVERE, "Error in setup Jade Environment", e2);
        }
        this.executor = Executors.newFixedThreadPool(5);
        try {
            this.addBehaviour((Behaviour)new OneShotBehaviour(){

                public void action() {
                    JadeExecutionControl.this.userControl.updateNumberOfAgents();
                    JadeExecutionControl.this.informAllAgsToPerformCycle(0);
                }
            });
            this.addBehaviour((Behaviour)new CyclicBehaviour(){
                ACLMessage m;

                public void action() {
                    this.m = JadeExecutionControl.this.receive();
                    if (this.m == null) {
                        this.block(1000L);
                    } else {
                        try {
                            Document o = (Document)((Object)this.m.getContentObject());
                            JadeExecutionControl.this.logger.warning("Received agState too late! in-reply-to:" + this.m.getInReplyTo());
                        }
                        catch (Exception _) {
                            try {
                                String content = this.m.getContent();
                                int p = content.indexOf(",");
                                if (p > 0) {
                                    final String sender = this.m.getSender().getLocalName();
                                    final boolean breakpoint = Boolean.parseBoolean(content.substring(0, p));
                                    final int cycle = Integer.parseInt(content.substring(p + 1));
                                    JadeExecutionControl.this.executor.execute(new Runnable(){

                                        public void run() {
                                            try {
                                                JadeExecutionControl.this.userControl.receiveFinishedCycle(sender, breakpoint, cycle);
                                            }
                                            catch (Exception e2) {
                                                JadeExecutionControl.this.logger.log(Level.SEVERE, "Error processing end of cycle.", e2);
                                            }
                                        }
                                    });
                                }
                            }
                            catch (Exception e2) {
                                JadeExecutionControl.this.logger.log(Level.SEVERE, "Error in processing " + this.m, e2);
                            }
                        }
                    }
                }
            });
        }
        catch (Exception e3) {
            this.logger.log(Level.SEVERE, "Error starting agent", e3);
        }
    }

    protected void takeDown() {
        if (this.userControl != null) {
            this.userControl.stop();
        }
    }

    public ExecutionControl getUserControl() {
        return this.userControl;
    }

    public void informAgToPerformCycle(final String agName, final int cycle) {
        this.addBehaviour((Behaviour)new OneShotBehaviour(){

            public void action() {
                ACLMessage m = new ACLMessage(7);
                m.setOntology(controllerOntology);
                m.addReceiver(new AID(agName, false));
                m.setContent("performCycle");
                m.addUserDefinedParameter("cycle", String.valueOf(cycle));
                JadeExecutionControl.this.send(m);
            }
        });
    }

    public void informAllAgsToPerformCycle(final int cycle) {
        this.addBehaviour((Behaviour)new OneShotBehaviour(){

            public void action() {
                try {
                    JadeExecutionControl.this.logger.fine("Sending performCycle " + cycle + " to all agents.");
                    ACLMessage m = new ACLMessage(7);
                    m.setOntology(controllerOntology);
                    JadeExecutionControl.this.addAllAgsAsReceivers(m);
                    m.setContent("performCycle");
                    m.addUserDefinedParameter("cycle", String.valueOf(cycle));
                    JadeExecutionControl.this.send(m);
                }
                catch (Exception e2) {
                    JadeExecutionControl.this.logger.log(Level.SEVERE, "Error in informAllAgsToPerformCycle", e2);
                }
            }
        });
    }

    public Document getAgState(final String agName) {
        if (agName == null) {
            return null;
        }
        this.state = null;
        this.addBehaviour((Behaviour)new OneShotBehaviour(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void action() {
                try {
                    Object m = new ACLMessage(13);
                    m.setOntology(controllerOntology);
                    m.addReceiver(new AID(agName, false));
                    m.setContent("agState");
                    ACLMessage r = JadeExecutionControl.this.ask((ACLMessage)m);
                    if (r == null) {
                        System.err.println("No agent state received! (possibly timeout in ask)");
                    } else {
                        JadeExecutionControl.this.state = (Document)((Object)r.getContentObject());
                    }
                }
                catch (Exception e2) {
                    JadeExecutionControl.this.logger.log(Level.SEVERE, "Error in getAgState", e2);
                }
                finally {
                    Object object = JadeExecutionControl.this.syncWaitState;
                    synchronized (object) {
                        JadeExecutionControl.this.syncWaitState.notifyAll();
                    }
                }
            }
        });
        return this.waitState();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Document waitState() {
        if (this.state == null) {
            Object object = this.syncWaitState;
            synchronized (object) {
                try {
                    this.syncWaitState.wait();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
        return this.state;
    }

    public RuntimeServicesInfraTier getRuntimeServices() {
        return new JadeRuntimeServices((ContainerController)this.getContainerController(), this);
    }
}

