/*
 * Decompiled with CFR 0.152.
 */
package jason.infra.centralised;

import jason.JasonException;
import jason.asSemantics.Agent;
import jason.asSyntax.directives.DirectiveProcessor;
import jason.asSyntax.directives.Include;
import jason.control.ExecutionControlGUI;
import jason.infra.centralised.CentralisedAgArch;
import jason.infra.centralised.CentralisedEnvironment;
import jason.infra.centralised.CentralisedExecutionControl;
import jason.infra.centralised.KillAgentGUI;
import jason.infra.centralised.StartNewAgentGUI;
import jason.jeditplugin.Config;
import jason.mas2j.AgentParameters;
import jason.mas2j.ClassParameters;
import jason.mas2j.MAS2JProject;
import jason.mas2j.parser.ParseException;
import jason.mas2j.parser.mas2j;
import jason.runtime.MASConsoleGUI;
import jason.runtime.MASConsoleLogFormatter;
import jason.runtime.MASConsoleLogHandler;
import jason.runtime.Settings;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Map;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.logging.ConsoleHandler;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogManager;
import java.util.logging.Logger;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RunCentralisedMAS {
    public static final String logPropFile = "logging.properties";
    public static final String stopMASFileName = ".stop___MAS";
    public static final String defaultProjectFileName = "default.mas2j";
    private static Logger logger = Logger.getLogger(RunCentralisedMAS.class.getName());
    protected static RunCentralisedMAS runner = null;
    private static String urlPrefix = "";
    private static boolean readFromJAR = false;
    private static MAS2JProject project;
    private CentralisedEnvironment env = null;
    private CentralisedExecutionControl control = null;
    private boolean debug = false;
    private Map<String, CentralisedAgArch> ags = new ConcurrentHashMap<String, CentralisedAgArch>();
    public JButton btDebug;
    private BlockingQueue<Runnable> myAgTasks;
    private BlockingQueue<Runnable> mySleepAgs;

    public RunCentralisedMAS() {
        runner = this;
    }

    public static void main(String[] args) {
        runner = new RunCentralisedMAS();
        runner.init(args);
    }

    public void init(String[] args) {
        String projectFileName = null;
        if (args.length < 1) {
            if (RunCentralisedMAS.class.getResource("/default.mas2j") != null) {
                projectFileName = defaultProjectFileName;
                readFromJAR = true;
                Config.get(false);
            } else {
                System.out.println("Jason " + Config.get().getJasonRunningVersion());
                System.err.println("You should inform the MAS project file.");
                JOptionPane.showMessageDialog(null, "Jason version " + Config.get().getJasonRunningVersion() + " library built on " + Config.get().getJasonBuiltDate(), "Jason", 1);
                System.exit(0);
            }
        } else {
            projectFileName = args[0];
        }
        RunCentralisedMAS.setupLogger();
        if (args.length >= 2 && args[1].equals("-debug")) {
            this.debug = true;
            Logger.getLogger("").setLevel(Level.FINE);
        }
        for (Handler h : Logger.getLogger("").getHandlers()) {
            if (!h.getClass().toString().equals(MASConsoleLogHandler.class.toString())) continue;
            MASConsoleGUI.get().getFrame().setVisible(true);
            MASConsoleGUI.get().setAsDefaultOut();
        }
        int errorCode = 0;
        try {
            InputStream inProject;
            if (readFromJAR) {
                inProject = RunCentralisedMAS.class.getResource("/default.mas2j").openStream();
                urlPrefix = "ClassResource:/";
            } else {
                URL file;
                try {
                    file = new URL(projectFileName);
                    if (projectFileName.startsWith("jar")) {
                        urlPrefix = projectFileName.substring(0, projectFileName.indexOf("!") + 1) + "/";
                    }
                }
                catch (Exception e2) {
                    file = new URL("file:" + projectFileName);
                }
                inProject = file.openStream();
            }
            mas2j parser = new mas2j(inProject);
            project = parser.mas();
            project.setupDefault();
            project.registerDirectives();
            ((Include)DirectiveProcessor.getDirective("include")).setSourcePath(project.getSourcePaths());
            runner.createAgs(project, this.debug);
            runner.startAgs();
            runner.startSyncMode();
            if (MASConsoleGUI.hasConsole()) {
                MASConsoleGUI.get().setTitle("MAS Console - " + project.getSocName());
                this.createButtons();
            }
            runner.waitEnd();
            errorCode = 0;
        }
        catch (FileNotFoundException e1) {
            logger.log(Level.SEVERE, "File " + projectFileName + " not found!");
            errorCode = 2;
        }
        catch (ParseException e3) {
            logger.log(Level.SEVERE, "Error parsing file " + projectFileName + "!", e3);
            errorCode = 3;
        }
        catch (Exception e4) {
            logger.log(Level.SEVERE, "Error!?: ", e4);
            errorCode = 4;
        }
        System.out.flush();
        System.err.flush();
        if (!MASConsoleGUI.hasConsole() && errorCode != 0) {
            System.exit(errorCode);
        }
    }

    public static boolean isDebug() {
        return RunCentralisedMAS.runner.debug;
    }

    public static synchronized void setupLogger() {
        if (readFromJAR) {
            Handler[] hs = Logger.getLogger("").getHandlers();
            for (int i = 0; i < hs.length; ++i) {
                Logger.getLogger("").removeHandler(hs[i]);
            }
            MASConsoleLogHandler h = new MASConsoleLogHandler();
            h.setFormatter(new MASConsoleLogFormatter());
            Logger.getLogger("").addHandler(h);
            Logger.getLogger("").setLevel(Level.INFO);
        } else if (new File(logPropFile).exists()) {
            try {
                LogManager.getLogManager().readConfiguration(new FileInputStream(logPropFile));
            }
            catch (Exception e2) {
                System.err.println("Error setting up logger:" + e2);
            }
        } else {
            try {
                LogManager.getLogManager().readConfiguration(RunCentralisedMAS.class.getResource("/templates/logging.properties").openStream());
            }
            catch (Exception e3) {
                System.err.println("Error setting up logger:" + e3);
                e3.printStackTrace();
            }
        }
    }

    public static void setupDefaultConsoleLogger() {
        Handler[] hs = Logger.getLogger("").getHandlers();
        for (int i = 0; i < hs.length; ++i) {
            Logger.getLogger("").removeHandler(hs[i]);
        }
        ConsoleHandler h = new ConsoleHandler();
        h.setFormatter(new MASConsoleLogFormatter());
        Logger.getLogger("").addHandler(h);
        Logger.getLogger("").setLevel(Level.INFO);
    }

    protected void createButtons() {
        this.createStopButton();
        this.createPauseButton();
        RunCentralisedMAS.runner.btDebug = new JButton("Debug", new ImageIcon(RunCentralisedMAS.class.getResource("/images/debug.gif")));
        RunCentralisedMAS.runner.btDebug.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                runner.changeToDebugMode();
                RunCentralisedMAS.runner.btDebug.setEnabled(false);
                if (runner.control != null) {
                    try {
                        runner.control.getUserControl().setRunningCycle(false);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
        });
        if (this.debug) {
            RunCentralisedMAS.runner.btDebug.setEnabled(false);
        }
        MASConsoleGUI.get().addButton(RunCentralisedMAS.runner.btDebug);
        JButton btShowSrc = new JButton("Sources", new ImageIcon(RunCentralisedMAS.class.getResource("/images/list.gif")));
        btShowSrc.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                RunCentralisedMAS.showProjectSources(project);
            }
        });
        MASConsoleGUI.get().addButton(btShowSrc);
        JButton btStartAg = new JButton("New agent", new ImageIcon(RunCentralisedMAS.class.getResource("/images/newAgent.gif")));
        btStartAg.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                new StartNewAgentGUI((Frame)MASConsoleGUI.get().getFrame(), "Start a new agent to run in current MAS", System.getProperty("user.dir"));
            }
        });
        MASConsoleGUI.get().addButton(btStartAg);
        JButton btKillAg = new JButton("Kill agent", new ImageIcon(RunCentralisedMAS.class.getResource("/images/killAgent.gif")));
        btKillAg.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                new KillAgentGUI((Frame)MASConsoleGUI.get().getFrame(), "Kill an agent of the current MAS");
            }
        });
        MASConsoleGUI.get().addButton(btKillAg);
    }

    protected void createPauseButton() {
        final JButton btPause = new JButton("Pause", new ImageIcon(RunCentralisedMAS.class.getResource("/images/resume_co.gif")));
        btPause.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                if (MASConsoleGUI.get().isPause()) {
                    btPause.setText("Pause");
                    MASConsoleGUI.get().setPause(false);
                } else {
                    btPause.setText("Continue");
                    MASConsoleGUI.get().setPause(true);
                }
            }
        });
        MASConsoleGUI.get().addButton(btPause);
    }

    protected void createStopButton() {
        JButton btStop = new JButton("Stop", new ImageIcon(RunCentralisedMAS.class.getResource("/images/suspend.gif")));
        btStop.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                MASConsoleGUI.get().setPause(false);
                runner.finish();
            }
        });
        MASConsoleGUI.get().addButton(btStop);
    }

    public static RunCentralisedMAS getRunner() {
        return runner;
    }

    public CentralisedExecutionControl getControllerInfraTier() {
        return this.control;
    }

    public CentralisedEnvironment getEnvironmentInfraTier() {
        return this.env;
    }

    public MAS2JProject getProject() {
        return project;
    }

    protected void createAgs(MAS2JProject project, boolean debug) throws JasonException {
        logger.fine("Creating environment " + project.getEnvClass());
        this.env = new CentralisedEnvironment(project.getEnvClass(), this);
        boolean isPool = project.getInfrastructure().hasParameter("pool");
        if (isPool) {
            logger.info("Creating agents....");
        }
        int nbAg = 0;
        Agent pag = null;
        project.fixAgentsSrc(urlPrefix);
        for (AgentParameters ap : project.getAgents()) {
            try {
                String agName = ap.name;
                for (int cAg = 0; cAg < ap.qty; ++cAg) {
                    ++nbAg;
                    String numberedAg = agName;
                    if (ap.qty > 1) {
                        numberedAg = numberedAg + (cAg + 1);
                    }
                    logger.fine("Creating agent " + numberedAg + " (" + (cAg + 1) + "/" + ap.qty + ")");
                    CentralisedAgArch agArch = isPool ? new CentralisedAgArchForPool() : new CentralisedAgArch();
                    agArch.setAgName(numberedAg);
                    agArch.setEnvInfraTier(this.env);
                    if (isPool && cAg > 0) {
                        agArch.initAg(ap.archClass.getClassName(), pag, this);
                    } else {
                        agArch.initAg(ap.archClass.getClassName(), ap.agClass.getClassName(), ap.getBBClass(), ap.asSource.toString(), ap.getAsSetts(debug, project.getControlClass() != null), this);
                    }
                    this.addAg(agArch);
                    pag = agArch.getUserAgArch().getTS().getAg();
                }
            }
            catch (Exception e2) {
                logger.log(Level.SEVERE, "Error creating agent " + ap.name, e2);
            }
        }
        if (isPool) {
            logger.info("Created " + nbAg + " agents.");
        }
        ClassParameters controlClass = project.getControlClass();
        if (debug && controlClass == null) {
            controlClass = new ClassParameters(ExecutionControlGUI.class.getName());
        }
        if (controlClass != null) {
            logger.fine("Creating controller " + controlClass);
            this.control = new CentralisedExecutionControl(controlClass, this);
        }
    }

    public void addAg(CentralisedAgArch ag) {
        this.ags.put(ag.getAgName(), ag);
    }

    public CentralisedAgArch delAg(String agName) {
        return this.ags.remove(agName);
    }

    public CentralisedAgArch getAg(String agName) {
        return this.ags.get(agName);
    }

    protected Map<String, CentralisedAgArch> getAgs() {
        return this.ags;
    }

    protected void startAgs() {
        if (project.getInfrastructure().hasParameter("pool")) {
            this.createThreadPool();
        } else {
            this.createAgsThreads();
        }
    }

    private void createAgsThreads() {
        for (CentralisedAgArch ag : this.ags.values()) {
            ag.setControlInfraTier(this.control);
            Thread agThread = new Thread(ag);
            ag.setThread(agThread);
            agThread.start();
        }
    }

    private void createThreadPool() {
        this.myAgTasks = new LinkedBlockingQueue<Runnable>();
        this.mySleepAgs = new LinkedBlockingQueue<Runnable>();
        new Thread("feed-pool"){

            public void run() {
                for (CentralisedAgArch ag : RunCentralisedMAS.this.ags.values()) {
                    RunCentralisedMAS.this.myAgTasks.offer(ag);
                }
                int maxthreads = 10;
                try {
                    if (project.getInfrastructure().hasParameters()) {
                        maxthreads = Integer.parseInt(project.getInfrastructure().getParameter(1));
                        logger.info("Creating a thread pool with " + maxthreads + " thread(s).");
                    }
                }
                catch (Exception e2) {
                    logger.warning("Error getting the number of thread for the pool.");
                }
                int poolSize = RunCentralisedMAS.this.ags.size();
                if (poolSize > maxthreads) {
                    poolSize = maxthreads;
                }
                ExecutorService executor = Executors.newFixedThreadPool(poolSize);
                while (runner != null) {
                    try {
                        executor.execute((Runnable)RunCentralisedMAS.this.myAgTasks.take());
                    }
                    catch (InterruptedException e3) {}
                }
                executor.shutdownNow();
            }
        }.start();
        new Thread("wake-sleep-ag"){

            public void run() {
                while (runner != null) {
                    try {
                        Runnable ag = (Runnable)RunCentralisedMAS.this.mySleepAgs.poll();
                        while (ag != null) {
                            RunCentralisedMAS.this.myAgTasks.offer(ag);
                            ag = (Runnable)RunCentralisedMAS.this.mySleepAgs.poll();
                        }
                        8.sleep(2000L);
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
        }.start();
    }

    protected void stopAgs() {
        for (CentralisedAgArch ag : this.ags.values()) {
            ag.stopAg();
        }
    }

    void changeToDebugMode() {
        try {
            if (this.control == null) {
                this.control = new CentralisedExecutionControl(new ClassParameters(ExecutionControlGUI.class.getName()), this);
                for (CentralisedAgArch ag : this.ags.values()) {
                    ag.setControlInfraTier(this.control);
                    Settings stts = ag.getUserAgArch().getTS().getSettings();
                    stts.setVerbose(2);
                    stts.setSync(true);
                    ag.getLogger().setLevel(Level.FINE);
                    ag.getUserAgArch().getTS().getLogger().setLevel(Level.FINE);
                    ag.getUserAgArch().getTS().getAg().getLogger().setLevel(Level.FINE);
                }
            }
        }
        catch (Exception e2) {
            logger.log(Level.SEVERE, "Error entering in debug mode", e2);
        }
    }

    protected void startSyncMode() {
        if (this.control != null) {
            try {
                Thread.sleep(500L);
                this.control.informAllAgsToPerformCycle(0);
            }
            catch (Exception e2) {
                e2.printStackTrace();
            }
        }
    }

    protected void waitEnd() {
        try {
            File stop = new File(stopMASFileName);
            if (stop.exists()) {
                stop.delete();
            }
            while (!stop.exists()) {
                Thread.sleep(1500L);
            }
            if (stop.exists()) {
                stop.delete();
            }
            this.finish();
        }
        catch (Exception e2) {
            e2.printStackTrace();
        }
    }

    public void finish() {
        try {
            new Thread(){

                public void run() {
                    try {
                        9.sleep(5000L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    System.exit(0);
                }
            }.start();
            if (MASConsoleGUI.hasConsole()) {
                MASConsoleGUI.get().close();
            }
            if (this.control != null) {
                this.control.stop();
                this.control = null;
            }
            if (this.env != null) {
                this.env.stop();
                this.env = null;
            }
            this.stopAgs();
            runner = null;
        }
        catch (Exception e2) {
            e2.printStackTrace();
        }
        System.exit(0);
    }

    private static void showProjectSources(MAS2JProject project) {
        JFrame frame = new JFrame("Project " + project.getSocName() + " sources");
        JTabbedPane pane = new JTabbedPane();
        frame.getContentPane().add(pane);
        project.fixAgentsSrc(urlPrefix);
        for (AgentParameters ap : project.getAgents()) {
            try {
                String tmpAsSrc = ap.asSource.toString();
                InputStream in = null;
                if (tmpAsSrc.startsWith("ClassResource:")) {
                    in = RunCentralisedMAS.class.getResource(tmpAsSrc.substring("ClassResource:".length())).openStream();
                } else {
                    try {
                        in = new URL(tmpAsSrc).openStream();
                    }
                    catch (MalformedURLException e2) {
                        in = new FileInputStream(tmpAsSrc);
                    }
                }
                StringBuilder s = new StringBuilder();
                int c = in.read();
                while (c > 0) {
                    s.append((char)c);
                    c = in.read();
                }
                JTextArea ta = new JTextArea(40, 50);
                ta.setEditable(false);
                ta.setText(s.toString());
                ta.setCaretPosition(0);
                JScrollPane sp = new JScrollPane(ta);
                pane.add(ap.name, sp);
            }
            catch (Exception e3) {
                logger.info("Error:" + e3);
            }
        }
        frame.pack();
        frame.setVisible(true);
    }

    private final class CentralisedAgArchForPool
    extends CentralisedAgArch {
        boolean inSleep;

        private CentralisedAgArchForPool() {
        }

        public void sleep() {
            RunCentralisedMAS.this.mySleepAgs.offer(this);
            this.inSleep = true;
        }

        public void wake() {
            if (RunCentralisedMAS.this.mySleepAgs.remove(this)) {
                RunCentralisedMAS.this.myAgTasks.offer(this);
            }
        }

        public void run() {
            if (this.isRunning()) {
                this.inSleep = false;
                this.userAgArch.getTS().reasoningCycle();
                if (!this.inSleep) {
                    RunCentralisedMAS.this.myAgTasks.offer(this);
                }
            }
        }
    }
}

