/*
 * Decompiled with CFR 0.152.
 */
package jason.infra.centralised;

import jason.JasonException;
import jason.asSemantics.ActionExec;
import jason.asSyntax.Structure;
import jason.environment.Environment;
import jason.environment.EnvironmentInfraTier;
import jason.infra.centralised.CentralisedAgArch;
import jason.infra.centralised.CentralisedRuntimeServices;
import jason.infra.centralised.RunCentralisedMAS;
import jason.mas2j.ClassParameters;
import jason.runtime.RuntimeServicesInfraTier;
import java.util.Collection;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CentralisedEnvironment
implements EnvironmentInfraTier {
    private Environment userEnv;
    private RunCentralisedMAS masRunner = RunCentralisedMAS.getRunner();
    private boolean running = true;
    private static Logger logger = Logger.getLogger(CentralisedEnvironment.class.getName());

    public CentralisedEnvironment(ClassParameters userEnvArgs, RunCentralisedMAS masRunner) throws JasonException {
        this.masRunner = masRunner;
        if (userEnvArgs != null) {
            try {
                this.userEnv = (Environment)this.getClass().getClassLoader().loadClass(userEnvArgs.getClassName()).newInstance();
                this.userEnv.setEnvironmentInfraTier(this);
                this.userEnv.init(userEnvArgs.getParametersArray());
            }
            catch (Exception e2) {
                logger.log(Level.SEVERE, "Error in Centralised MAS environment creation", e2);
                throw new JasonException("The user environment class instantiation '" + userEnvArgs + "' has failed!" + e2.getMessage());
            }
        }
    }

    @Override
    public boolean isRunning() {
        return this.running;
    }

    public void stop() {
        this.running = false;
        this.userEnv.stop();
    }

    public void setUserEnvironment(Environment env) {
        this.userEnv = env;
    }

    public Environment getUserEnvironment() {
        return this.userEnv;
    }

    public void act(String agName, ActionExec action) {
        if (this.running) {
            this.userEnv.scheduleAction(agName, action.getActionTerm(), action);
        }
    }

    @Override
    public void actionExecuted(String agName, Structure actTerm, boolean success, Object infraData) {
        ActionExec action = (ActionExec)infraData;
        action.setResult(success);
        CentralisedAgArch ag = this.masRunner.getAg(agName);
        if (ag != null) {
            ag.actionExecuted(action);
        }
    }

    @Override
    public void informAgsEnvironmentChanged(String ... agents) {
        if (agents.length == 0) {
            for (CentralisedAgArch ag : this.masRunner.getAgs().values()) {
                ag.wake();
            }
        } else {
            for (String agName : agents) {
                CentralisedAgArch ag = this.masRunner.getAg(agName);
                if (ag != null) {
                    ag.wake();
                    continue;
                }
                logger.log(Level.SEVERE, "Error sending message notification: agent " + agName + " does not exist!");
            }
        }
    }

    @Override
    public void informAgsEnvironmentChanged(Collection<String> agentsToNotify) {
        if (agentsToNotify == null) {
            this.informAgsEnvironmentChanged(new String[0]);
        } else {
            for (String agName : agentsToNotify) {
                CentralisedAgArch ag = this.masRunner.getAg(agName);
                if (ag != null) {
                    ag.wake();
                    continue;
                }
                logger.log(Level.SEVERE, "Error sending message notification: agent " + agName + " does not exist!");
            }
        }
    }

    @Override
    public RuntimeServicesInfraTier getRuntimeServices() {
        return new CentralisedRuntimeServices(this.masRunner);
    }
}

