/*
 * Decompiled with CFR 0.152.
 */
package jason.environment.grid;

import jason.environment.grid.Location;
import java.io.Serializable;

public final class Area
implements Serializable {
    public final Location tl;
    public final Location br;

    public Area(int topLeftX, int topLeftY, int bottonRightX, int bottonRightY) {
        this.tl = new Location(topLeftX, topLeftY);
        this.br = new Location(bottonRightX, bottonRightY);
    }

    public Area(Location topLeft, Location bottonRight) {
        this.tl = topLeft;
        this.br = bottonRight;
    }

    public boolean contains(Location l) {
        return l.x >= this.tl.x && l.x <= this.br.x && l.y >= this.tl.y && l.y <= this.br.y;
    }

    public Location center() {
        return new Location((this.tl.x + this.br.x) / 2, (this.tl.y + this.br.y) / 2);
    }

    public int distanceMaxBorder(Location l) {
        return this.chebyshevDistanceToBorder(l);
    }

    public int chebyshevDistanceToBorder(Location l) {
        if (this.contains(l)) {
            return 0;
        }
        int x = Math.min(Math.abs(this.tl.x - l.x), Math.abs(this.br.x - l.x));
        int y = Math.min(Math.abs(this.tl.y - l.y), Math.abs(this.br.y - l.y));
        return Math.max(x, y);
    }

    public int hashCode() {
        int PRIME = 31;
        int result = 1;
        result = 31 * result + this.tl.x + this.tl.y;
        result = 31 * result + this.br.x + this.br.y;
        return result;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Area other = (Area)obj;
        if (!this.tl.equals(other.tl)) {
            return false;
        }
        return this.br.equals(other.br);
    }

    public Object clone() {
        return new Area(this.tl, this.br);
    }

    public String toString() {
        return this.tl + ":" + this.br;
    }
}

