/*
 * Decompiled with CFR 0.152.
 */
package jason.environment;

import jason.asSyntax.Literal;
import jason.asSyntax.Structure;
import jason.environment.Environment;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TimeSteppedEnvironment
extends Environment {
    private Logger logger = Logger.getLogger(TimeSteppedEnvironment.class.getName());
    private int step = 0;
    private int nbAgs = -1;
    private Map<String, ActRequest> requests;
    private Queue<ActRequest> overRequests;
    private TimeOutThread timeoutThread = null;
    private long stepTimeout = 0L;
    private int sleep = 0;
    private OverActionsPolicy overActPol = OverActionsPolicy.ignoreSecond;

    public TimeSteppedEnvironment() {
        super(2);
    }

    @Override
    public void init(String[] args) {
        super.init(args);
        if (args.length > 0) {
            try {
                this.stepTimeout = Integer.parseInt(args[0]);
            }
            catch (Exception e2) {
                this.logger.warning("The argument " + args[0] + " is not a valid number for step timeout");
            }
        }
        this.requests = new HashMap<String, ActRequest>();
        this.overRequests = new LinkedList<ActRequest>();
        this.step = 0;
        if (this.timeoutThread == null) {
            if (this.stepTimeout > 0L) {
                this.timeoutThread = new TimeOutThread(this.stepTimeout);
                this.timeoutThread.start();
            }
        } else {
            this.timeoutThread.allAgFinished();
        }
        this.stepStarted(this.step);
    }

    public void setSleep(int s) {
        this.sleep = s;
    }

    @Override
    public void stop() {
        super.stop();
        if (this.timeoutThread != null) {
            this.timeoutThread.interrupt();
        }
    }

    protected void updateNumberOfAgents() {
        this.setNbAgs(this.getEnvironmentInfraTier().getRuntimeServices().getAgentsNames().size());
    }

    public int getNbAgs() {
        return this.nbAgs;
    }

    public void setNbAgs(int n) {
        this.nbAgs = n;
    }

    public int getStep() {
        return this.step;
    }

    public void setOverActionsPolicy(OverActionsPolicy p) {
        this.overActPol = p;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void scheduleAction(String agName, Structure action, Object infraData) {
        if (!this.isRunning()) {
            return;
        }
        ActRequest newRequest = new ActRequest(agName, action, this.requiredStepsForAction(agName, action), infraData);
        boolean startNew = false;
        Map<String, ActRequest> map = this.requests;
        synchronized (map) {
            ActRequest inSchedule;
            if (this.nbAgs < 0) {
                this.updateNumberOfAgents();
            }
            if ((inSchedule = this.requests.get(agName)) != null) {
                if (this.overActPol == OverActionsPolicy.queue) {
                    this.overRequests.offer(newRequest);
                } else if (this.overActPol == OverActionsPolicy.failSecond) {
                    this.getEnvironmentInfraTier().actionExecuted(agName, action, false, infraData);
                } else if (this.overActPol == OverActionsPolicy.ignoreSecond) {
                    this.getEnvironmentInfraTier().actionExecuted(agName, action, true, infraData);
                }
            } else {
                this.requests.put(agName, newRequest);
                if (this.testEndCycle(this.requests.keySet())) {
                    startNew = true;
                }
            }
            if (startNew && this.sleep > 0) {
                try {
                    Thread.sleep(this.sleep);
                }
                catch (InterruptedException e2) {
                    // empty catch block
                }
            }
        }
        if (startNew) {
            if (this.timeoutThread != null) {
                this.timeoutThread.allAgFinished();
            } else {
                this.startNewStep();
            }
        }
    }

    public Structure getActionInSchedule(String agName) {
        ActRequest inSchedule = this.requests.get(agName);
        if (inSchedule != null) {
            return inSchedule.action;
        }
        return null;
    }

    protected boolean testEndCycle(Set<String> finishedAgs) {
        return finishedAgs.size() >= this.getNbAgs();
    }

    protected void updateAgsPercept() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void startNewStep() {
        if (!this.isRunning()) {
            return;
        }
        Map<String, ActRequest> map = this.requests;
        synchronized (map) {
            block10: {
                ++this.step;
                try {
                    for (ActRequest a : this.requests.values()) {
                        --a.remainSteps;
                        if (a.remainSteps != 0) continue;
                        a.success = this.executeAction(a.agName, a.action);
                    }
                    this.updateAgsPercept();
                    Iterator<ActRequest> i = this.requests.values().iterator();
                    while (i.hasNext()) {
                        ActRequest a;
                        a = i.next();
                        if (a.remainSteps != 0) continue;
                        this.getEnvironmentInfraTier().actionExecuted(a.agName, a.action, a.success, a.infraData);
                        i.remove();
                    }
                    Iterator io = this.overRequests.iterator();
                    while (io.hasNext()) {
                        ActRequest a = (ActRequest)io.next();
                        if (this.requests.get(a.agName) != null) continue;
                        this.requests.put(a.agName, a);
                        io.remove();
                    }
                    if (this.nbAgs > 0 && this.testEndCycle(this.requests.keySet())) {
                        this.startNewStep();
                    }
                    this.stepStarted(this.step);
                }
                catch (Exception ie) {
                    if (!this.isRunning() || ie instanceof InterruptedException) break block10;
                    this.logger.log(Level.WARNING, "act error!", ie);
                }
            }
        }
    }

    protected void stepStarted(int step) {
    }

    protected void stepFinished(int step, long elapsedTime, boolean byTimeout) {
    }

    protected int requiredStepsForAction(String agName, Structure action) {
        return 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Literal> getPercepts(String agName) {
        Map<String, ActRequest> map = this.requests;
        synchronized (map) {
            return super.getPercepts(agName);
        }
    }

    class TimeOutThread
    extends Thread {
        Lock lock;
        Condition agActCond;
        long timeout;
        boolean allFinished;

        public TimeOutThread(long to) {
            super("EnvironmentTimeOutThread");
            this.lock = new ReentrantLock();
            this.agActCond = this.lock.newCondition();
            this.timeout = 0L;
            this.allFinished = false;
            this.timeout = to;
        }

        public void allAgFinished() {
            this.lock.lock();
            this.allFinished = true;
            this.agActCond.signal();
            this.lock.unlock();
        }

        public void run() {
            try {
                while (true) {
                    this.lock.lock();
                    long lastStepStart = System.currentTimeMillis();
                    boolean byTimeOut = false;
                    if (!this.allFinished) {
                        byTimeOut = !this.agActCond.await(this.timeout, TimeUnit.MILLISECONDS);
                    }
                    this.allFinished = false;
                    long now = System.currentTimeMillis();
                    long time2 = now - lastStepStart;
                    TimeSteppedEnvironment.this.stepFinished(TimeSteppedEnvironment.this.step, time2, byTimeOut);
                    this.lock.unlock();
                    TimeSteppedEnvironment.this.startNewStep();
                }
            }
            catch (InterruptedException e2) {
            }
            catch (Exception e3) {
                TimeSteppedEnvironment.this.logger.log(Level.SEVERE, "Error in timeout thread!", e3);
            }
        }
    }

    class ActRequest {
        String agName;
        Structure action;
        Object infraData;
        boolean success;
        int remainSteps;

        public ActRequest(String ag, Structure act, int rs, Object data) {
            this.agName = ag;
            this.action = act;
            this.infraData = data;
            this.remainSteps = rs;
        }

        public boolean equals(Object obj) {
            return this.agName.equals(obj);
        }

        public int hashCode() {
            return this.agName.hashCode();
        }

        public String toString() {
            return "[" + this.agName + "," + this.action + "]";
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum OverActionsPolicy {
        queue,
        failSecond,
        ignoreSecond;

    }
}

