/*
 * Decompiled with CFR 0.152.
 */
package jason.bb;

import jason.asSemantics.Agent;
import jason.asSemantics.Unifier;
import jason.asSyntax.ASSyntax;
import jason.asSyntax.ListTerm;
import jason.asSyntax.ListTermImpl;
import jason.asSyntax.Literal;
import jason.asSyntax.LiteralImpl;
import jason.asSyntax.NumberTerm;
import jason.asSyntax.NumberTermImpl;
import jason.asSyntax.PredicateIndicator;
import jason.asSyntax.StringTerm;
import jason.asSyntax.StringTermImpl;
import jason.asSyntax.Structure;
import jason.asSyntax.Term;
import jason.asSyntax.parser.ParseException;
import jason.asSyntax.parser.TokenMgrError;
import jason.bb.BeliefBase;
import jason.bb.ChainBBAdapter;
import jason.bb.DefaultBeliefBase;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JDBCPersistentBB
extends ChainBBAdapter {
    private static Logger logger = Logger.getLogger(JDBCPersistentBB.class.getName());
    static final String COL_PREFIX = "term";
    static final String COL_NEG = "j_negated";
    static final String COL_ANNOT = "j_annots";
    protected int extraCols = 2;
    protected Connection conn;
    protected String url;
    protected String agentName;
    protected Map<PredicateIndicator, ResultSetMetaData> belsDB = new HashMap<PredicateIndicator, ResultSetMetaData>();
    public static final String timestampFunctor = "timestamp";

    public JDBCPersistentBB() {
    }

    public JDBCPersistentBB(BeliefBase next) {
        super(next);
    }

    @Override
    public void init(Agent ag, String[] args) {
        try {
            this.agentName = ag.getTS().getUserAgArch().getAgName();
        }
        catch (Exception _) {
            logger.warning("Can not get the agent name!");
            this.agentName = "none";
        }
        try {
            logger.fine("Loading driver " + args[0]);
            Class.forName(args[0]);
            this.url = String.format(args[1], this.agentName);
            logger.fine("Connecting: url= " + this.url + ", user=" + args[2] + ", password=" + args[3]);
            this.conn = DriverManager.getConnection(this.url, args[2], args[3]);
            ListTerm lt = ListTermImpl.parseList(args[4]);
            for (Term t : lt) {
                ResultSet rs;
                Structure ts = (Structure)t;
                int arity = Integer.parseInt(ts.getTerm(0).toString());
                String table = ts.getFunctor();
                if (ts.getArity() >= 2) {
                    table = ts.getTerm(1).toString();
                }
                Structure columns = new Structure("columns");
                if (ts.getArity() >= 3) {
                    columns = (Structure)ts.getTerm(2);
                }
                Statement stmt = this.conn.createStatement();
                try {
                    rs = stmt.executeQuery("select * from " + table);
                }
                catch (SQLException e2) {
                    stmt.executeUpdate(this.getCreateTable(table, arity, columns));
                    rs = stmt.executeQuery("select * from " + table);
                }
                this.belsDB.put(new PredicateIndicator(ts.getFunctor(), arity), rs.getMetaData());
                this.belsDB.put(new PredicateIndicator("~" + ts.getFunctor(), arity), rs.getMetaData());
                stmt.close();
            }
        }
        catch (ArrayIndexOutOfBoundsException e3) {
            logger.log(Level.SEVERE, "Wrong parameters for JDBCPersistentBB initialisation.", e3);
        }
        catch (ClassNotFoundException e4) {
            logger.log(Level.SEVERE, "Error loading jdbc driver " + args[0], e4);
        }
        catch (SQLException e5) {
            logger.log(Level.SEVERE, "DB connection failure. url= " + this.url + ", user=" + args[2] + ", password=" + args[3], e5);
        }
        this.nextBB.init(ag, args);
    }

    @Override
    public void stop() {
        if (this.conn == null) {
            return;
        }
        try {
            if (this.url.startsWith("jdbc:hsqldb")) {
                this.conn.createStatement().execute("SHUTDOWN");
            }
            this.conn.close();
        }
        catch (Exception e2) {
            logger.log(Level.SEVERE, "Error in shutdown SGBD ", e2);
        }
        this.nextBB.stop();
    }

    protected boolean isDB(Literal l) {
        return this.belsDB.get(l.getPredicateIndicator()) != null;
    }

    protected boolean isCreatedByJason(PredicateIndicator pi2) throws SQLException {
        ResultSetMetaData meta = this.belsDB.get(pi2);
        if (meta != null) {
            int cols = meta.getColumnCount();
            return cols >= this.extraCols && meta.getColumnName(cols - this.extraCols + 1).equalsIgnoreCase(COL_NEG) && meta.getColumnName(cols - this.extraCols + 2).equalsIgnoreCase(COL_ANNOT);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Literal contains(Literal l) {
        if (!this.isDB(l)) {
            return this.nextBB.contains(l);
        }
        Statement stmt = null;
        try {
            ResultSet rs;
            stmt = this.conn.createStatement();
            String q = this.getSelect(l);
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("query for contains " + l + ":" + q);
            }
            if ((rs = stmt.executeQuery(q)).next()) {
                Literal literal2 = this.resultSetToLiteral(rs, l.getPredicateIndicator());
                return literal2;
            }
        }
        catch (SQLException e2) {
            logger.log(Level.SEVERE, "SQL Error", e2);
        }
        finally {
            try {
                stmt.close();
            }
            catch (Exception e3) {
                logger.log(Level.WARNING, "SQL Error closing connection", e3);
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean add(Literal l) {
        block26: {
            if (!this.isDB(l)) {
                return this.nextBB.add(l);
            }
            Literal bl = this.contains(l);
            Statement stmt = null;
            try {
                if (bl != null) {
                    if (this.isCreatedByJason(l.getPredicateIndicator())) {
                        if (l.hasSubsetAnnot(bl)) {
                            boolean bl2 = false;
                            return bl2;
                        }
                        bl.importAnnots(l);
                        if (l.hasAnnot(TPercept)) {
                            this.getDBBPercepts().add(bl);
                        }
                        stmt = this.conn.createStatement();
                        stmt.executeUpdate("update " + this.getTableName(bl) + " set " + COL_ANNOT + " = '" + bl.getAnnots() + "' " + this.getWhere(l));
                        boolean bl3 = true;
                        return bl3;
                    }
                    break block26;
                }
                stmt = this.conn.createStatement();
                stmt.executeUpdate(this.getInsert(l));
                if (l.hasAnnot(TPercept)) {
                    this.getDBBPercepts().add(l);
                }
                boolean bl4 = true;
                return bl4;
            }
            catch (SQLException e2) {
                logger.log(Level.SEVERE, "SQL Error", e2);
            }
            finally {
                try {
                    if (stmt != null) {
                        stmt.close();
                    }
                }
                catch (Exception e3) {
                    logger.log(Level.WARNING, "SQL Error closing connection", e3);
                }
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean remove(Literal l) {
        if (!this.isDB(l)) {
            return this.nextBB.remove(l);
        }
        Literal bl = this.contains(l);
        if (bl != null) {
            Statement stmt = null;
            try {
                if (l.hasSubsetAnnot(bl)) {
                    if (l.hasAnnot(TPercept)) {
                        this.getDBBPercepts().remove(bl);
                    }
                    boolean result = bl.delAnnots(l.getAnnots()) || !bl.hasAnnot();
                    stmt = this.conn.createStatement();
                    if (bl.hasAnnot() && this.isCreatedByJason(l.getPredicateIndicator())) {
                        stmt.executeUpdate("update " + this.getTableName(bl) + " set " + COL_ANNOT + " = '" + bl.getAnnots() + "' " + this.getWhere(l));
                    } else {
                        stmt.executeUpdate("delete from " + this.getTableName(bl) + this.getWhere(bl));
                    }
                    boolean bl2 = result;
                    return bl2;
                }
            }
            catch (SQLException e2) {
                logger.log(Level.SEVERE, "SQL Error", e2);
            }
            finally {
                try {
                    stmt.close();
                }
                catch (Exception e3) {
                    logger.log(Level.WARNING, "SQL Error closing connection", e3);
                }
            }
        }
        return false;
    }

    private Set<Literal> getDBBPercepts() {
        BeliefBase last = this.getLastBB();
        if (last instanceof DefaultBeliefBase) {
            return ((DefaultBeliefBase)last).getPerceptsSet();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean abolish(PredicateIndicator pi2) {
        if (this.belsDB.get(pi2) == null) {
            return this.nextBB.abolish(pi2);
        }
        Statement stmt = null;
        try {
            stmt = this.conn.createStatement();
            stmt.executeUpdate(this.getDeleteAll(pi2));
        }
        catch (SQLException e2) {
            logger.log(Level.SEVERE, "SQL Error", e2);
        }
        finally {
            try {
                stmt.close();
            }
            catch (Exception e3) {
                logger.log(Level.WARNING, "SQL Error closing connection", e3);
            }
        }
        return false;
    }

    @Override
    public Iterator<Literal> getCandidateBeliefs(Literal l, Unifier u) {
        final PredicateIndicator pi2 = l.getPredicateIndicator();
        if (this.belsDB.get(pi2) == null) {
            return this.nextBB.getCandidateBeliefs(l, u);
        }
        if (l.isVar()) {
            return this.iterator();
        }
        try {
            String q = this.getSelect(l);
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("getRelevant query for " + l + ": " + q);
            }
            final ResultSet rs = this.conn.createStatement().executeQuery(q);
            return new Iterator<Literal>(){
                boolean hasNext = true;
                boolean firstcall = true;

                @Override
                public boolean hasNext() {
                    if (this.firstcall) {
                        try {
                            this.hasNext = rs.next();
                        }
                        catch (SQLException e2) {
                            logger.log(Level.SEVERE, "SQL Error", e2);
                        }
                        this.firstcall = false;
                    }
                    return this.hasNext;
                }

                @Override
                public Literal next() {
                    try {
                        if (this.firstcall) {
                            this.hasNext = rs.next();
                            this.firstcall = false;
                        }
                        Literal l = JDBCPersistentBB.this.resultSetToLiteral(rs, pi2);
                        this.hasNext = rs.next();
                        if (!this.hasNext) {
                            rs.close();
                        }
                        return l;
                    }
                    catch (Exception e2) {
                        logger.log(Level.SEVERE, "Error", e2);
                        return null;
                    }
                }

                @Override
                public void remove() {
                    logger.warning("remove in jdbc get relevant is not implemented!");
                }
            };
        }
        catch (SQLException e2) {
            logger.log(Level.SEVERE, "SQL Error in getRelevant for " + l, e2);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int size() {
        int count2 = 0;
        Statement stmt = null;
        try {
            stmt = this.conn.createStatement();
            for (PredicateIndicator pi2 : this.belsDB.keySet()) {
                ResultSet rs;
                if (pi2.getFunctor().startsWith("~") || !(rs = stmt.executeQuery(this.getCountQuery(pi2))).next()) continue;
                count2 += rs.getInt(1);
            }
        }
        catch (SQLException e2) {
            logger.log(Level.SEVERE, "SQL Error", e2);
        }
        finally {
            try {
                stmt.close();
            }
            catch (Exception e3) {
                logger.log(Level.WARNING, "SQL Error closing connection", e3);
            }
        }
        return count2 + this.nextBB.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Iterator<Literal> iterator() {
        ArrayList<Literal> all = new ArrayList<Literal>(this.size());
        Iterator<Literal> is = this.nextBB.iterator();
        while (is.hasNext()) {
            all.add(is.next());
        }
        Statement stmt = null;
        try {
            stmt = this.conn.createStatement();
            for (PredicateIndicator pi2 : this.belsDB.keySet()) {
                if (pi2.getFunctor().startsWith("~")) continue;
                ResultSet rs = stmt.executeQuery(this.getSelectAll(pi2));
                while (rs.next()) {
                    all.add(this.resultSetToLiteral(rs, pi2));
                }
            }
        }
        catch (Exception e2) {
            logger.log(Level.SEVERE, "Error", e2);
        }
        finally {
            try {
                stmt.close();
            }
            catch (Exception e3) {
                logger.log(Level.WARNING, "SQL Error closing connection", e3);
            }
        }
        return all.iterator();
    }

    protected Literal resultSetToLiteral(ResultSet rs, PredicateIndicator pi2) throws SQLException {
        ResultSetMetaData meta = this.belsDB.get(pi2);
        boolean isJasonTable = this.isCreatedByJason(pi2);
        LiteralImpl ldb = new LiteralImpl(pi2.getFunctor());
        int end = meta.getColumnCount();
        if (isJasonTable) {
            end -= this.extraCols;
        }
        for (int c = 1; c <= end; ++c) {
            Term parsed = null;
            switch (meta.getColumnType(c)) {
                case 2: 
                case 3: 
                case 4: 
                case 6: 
                case 7: 
                case 8: {
                    parsed = new NumberTermImpl(rs.getDouble(c));
                    break;
                }
                case 93: {
                    parsed = JDBCPersistentBB.timestamp2structure(rs.getTimestamp(c));
                    break;
                }
                default: {
                    String sc = rs.getString(c);
                    if (sc == null || sc.trim().length() == 0) {
                        parsed = new StringTermImpl("");
                        break;
                    }
                    if (Character.isUpperCase(sc.charAt(0))) {
                        parsed = new StringTermImpl(sc);
                        break;
                    }
                    try {
                        parsed = ASSyntax.parseTerm(sc);
                        if (parsed.toString().equals(sc)) break;
                        sc = "\"" + sc + "\"";
                        parsed = ASSyntax.parseTerm(sc);
                        break;
                    }
                    catch (ParseException e2) {
                        parsed = new StringTermImpl(sc);
                        break;
                    }
                    catch (TokenMgrError e3) {
                        parsed = new StringTermImpl(sc);
                    }
                }
            }
            ((Literal)ldb).addTerm(parsed);
        }
        if (isJasonTable) {
            ((Literal)ldb).setNegated(!rs.getBoolean(end + 1));
            ((Literal)ldb).setAnnots(ListTermImpl.parseList(rs.getString(end + 2)));
        }
        return ldb;
    }

    protected String getTableName(Literal l) throws SQLException {
        return this.getTableName(l.getPredicateIndicator());
    }

    protected String getTableName(PredicateIndicator pi2) throws SQLException {
        ResultSetMetaData meta = this.belsDB.get(pi2);
        return meta.getTableName(1);
    }

    protected String getCreateTable(String table, int arity, Structure columns) throws SQLException {
        StringBuilder ct = new StringBuilder("create table " + table + " (");
        for (int c = 0; c < arity; ++c) {
            String colName = COL_PREFIX + c;
            String colType = "varchar(256)";
            if (columns.getArity() > c) {
                Structure scol = (Structure)columns.getTerm(c);
                colName = scol.getFunctor();
                colType = scol.getTerm(0).toString();
            }
            ct.append(colName + " " + colType + ", ");
        }
        ct.append("j_negated boolean, j_annots varchar(256))");
        logger.fine("Creating table: " + ct);
        return ct.toString();
    }

    protected String getSelect(Literal l) throws SQLException {
        return "select * from " + this.getTableName(l) + this.getWhere(l);
    }

    protected String getSelectAll(PredicateIndicator pi2) throws SQLException {
        return "select * from " + this.getTableName(pi2);
    }

    protected String getWhere(Literal l) throws SQLException {
        ResultSetMetaData meta = this.belsDB.get(l.getPredicateIndicator());
        StringBuilder q = new StringBuilder(" where ");
        String and = "";
        for (int i = 0; i < l.getArity(); ++i) {
            Term t = l.getTerm(i);
            if (!t.isGround()) continue;
            q.append(and);
            String ts = t.isString() ? "'" + ((StringTerm)t).getString() + "'" : (t.isNumeric() ? t.toString() : "'" + t.toString() + "'");
            q.append(meta.getColumnName(i + 1) + " = " + ts);
            and = " and ";
        }
        if (this.isCreatedByJason(l.getPredicateIndicator())) {
            q.append(and + COL_NEG + " = " + l.negated());
        }
        if (and.length() > 0) {
            return q.toString();
        }
        return "";
    }

    protected String getInsert(Literal l) throws SQLException {
        StringBuilder q = new StringBuilder("insert into ");
        ResultSetMetaData meta = this.belsDB.get(l.getPredicateIndicator());
        q.append(meta.getTableName(1));
        q.append(" values(");
        for (int i = 0; i < l.getArity(); ++i) {
            Term t = l.getTerm(i);
            if (t.isString()) {
                q.append("'" + ((StringTerm)t).getString() + "'");
            } else {
                Timestamp timestamp = JDBCPersistentBB.structure2timestamp(t);
                if (timestamp != null) {
                    q.append("TIMESTAMP '" + JDBCPersistentBB.structure2timestamp(t) + "'");
                } else {
                    q.append("'" + t.toString() + "'");
                }
            }
            if (i >= meta.getColumnCount() - 1) continue;
            q.append(",");
        }
        if (this.isCreatedByJason(l.getPredicateIndicator())) {
            q.append(l.negated() + ",");
            if (l.hasAnnot()) {
                q.append("'" + l.getAnnots() + "'");
            } else {
                q.append("'[]'");
            }
        }
        q.append(")");
        return q.toString();
    }

    protected String getDeleteAll(PredicateIndicator pi2) throws SQLException {
        return "delete from " + this.getTableName(pi2);
    }

    protected String getCountQuery(PredicateIndicator pi2) throws SQLException {
        return "select count(*) from " + this.getTableName(pi2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void test() {
        Statement stmt = null;
        try {
            stmt = this.conn.createStatement();
            try {
                stmt.executeUpdate("drop table publisher");
            }
            catch (Exception e2) {
                // empty catch block
            }
            stmt.executeUpdate("create table publisher (id integer, name varchar)");
            stmt.executeUpdate("insert into publisher values(1, 'Springer')");
            stmt.executeUpdate("insert into publisher values(2, 'MIT Press')");
            ResultSetMetaData meta = stmt.executeQuery("select * from publisher").getMetaData();
            this.belsDB.put(new PredicateIndicator("publisher", 2), meta);
        }
        catch (SQLException e3) {
            logger.log(Level.SEVERE, "SQL Error", e3);
        }
        finally {
            try {
                stmt.close();
            }
            catch (Exception e4) {
                logger.log(Level.WARNING, "SQL Error closing connection", e4);
            }
        }
    }

    public static Structure timestamp2structure(Timestamp timestamp) throws SQLException {
        Calendar time2 = Calendar.getInstance();
        time2.setTime(timestamp);
        return ASSyntax.createStructure(timestampFunctor, ASSyntax.createNumber(time2.get(1)), ASSyntax.createNumber(time2.get(2)), ASSyntax.createNumber(time2.get(5)), ASSyntax.createNumber(time2.get(11)), ASSyntax.createNumber(time2.get(12)), ASSyntax.createNumber(time2.get(13)));
    }

    public static Timestamp structure2timestamp(Term timestamp) throws SQLException {
        Structure s;
        if (timestamp.isStructure() && (s = (Structure)timestamp).getFunctor().equals(timestampFunctor) && s.getArity() == 6) {
            return new Timestamp((int)((NumberTerm)s.getTerm(0)).solve() - 1900, (int)((NumberTerm)s.getTerm(1)).solve(), (int)((NumberTerm)s.getTerm(2)).solve(), (int)((NumberTerm)s.getTerm(3)).solve(), (int)((NumberTerm)s.getTerm(4)).solve(), (int)((NumberTerm)s.getTerm(5)).solve(), 0);
        }
        return null;
    }
}

