/*
 * Decompiled with CFR 0.152.
 */
package jason.asSyntax;

import jason.asSemantics.Unifier;
import jason.asSyntax.Atom;
import jason.asSyntax.Literal;
import jason.asSyntax.Term;
import jason.asSyntax.UnnamedVar;
import jason.asSyntax.VarTerm;
import jason.asSyntax.parser.as2j;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Structure
extends Atom {
    private static final long serialVersionUID = 1L;
    private static Logger logger = Logger.getLogger(Structure.class.getName());
    protected static final List<Term> emptyTermList = new ArrayList<Term>(0);
    protected static final Term[] emptyTermArray = new Term[0];
    private List<Term> terms;

    public Structure(String functor) {
        super(functor);
        this.terms = new ArrayList<Term>(5);
    }

    public Structure(Literal l) {
        super(l);
        int tss = l.getArity();
        this.terms = new ArrayList<Term>(tss);
        for (int i = 0; i < tss; ++i) {
            this.terms.add(l.getTerm(i).clone());
        }
    }

    public Structure(String functor, int termsSize) {
        super(functor);
        if (termsSize > 0) {
            this.terms = new ArrayList<Term>(termsSize);
        }
    }

    public static Structure parse(String sTerm) {
        as2j parser = new as2j(new StringReader(sTerm));
        try {
            Term t = parser.term();
            if (t instanceof Structure) {
                return (Structure)t;
            }
            return new Structure((Atom)t);
        }
        catch (Exception e2) {
            logger.log(Level.SEVERE, "Error parsing structure " + sTerm, e2);
            return null;
        }
    }

    @Override
    protected int calcHashCode() {
        int result = super.calcHashCode();
        int ts = this.getArity();
        for (int i = 0; i < ts; ++i) {
            result = 7 * result + this.getTerm(i).hashCode();
        }
        return result;
    }

    @Override
    public boolean equals(Object t) {
        if (t == null) {
            return false;
        }
        if (t == this) {
            return true;
        }
        if (t instanceof Structure) {
            Structure tAsStruct = (Structure)t;
            if (tAsStruct.isVar()) {
                return ((VarTerm)t).equals(this);
            }
            int ts = this.getArity();
            if (ts != tAsStruct.getArity()) {
                return false;
            }
            if (!this.getFunctor().equals(tAsStruct.getFunctor())) {
                return false;
            }
            for (int i = 0; i < ts; ++i) {
                if (((Object)this.getTerm(i)).equals(tAsStruct.getTerm(i))) continue;
                return false;
            }
            return true;
        }
        if (t instanceof Atom && this.isAtom()) {
            return super.equals(t);
        }
        return false;
    }

    @Override
    public int compareTo(Term t) {
        int c = super.compareTo(t);
        if (c != 0) {
            return c;
        }
        if (t.isStructure()) {
            Structure tAsStruct = (Structure)t;
            int ma = this.getArity();
            int oa = tAsStruct.getArity();
            for (int i = 0; i < ma && i < oa; ++i) {
                c = this.getTerm(i).compareTo(tAsStruct.getTerm(i));
                if (c == 0) continue;
                return c;
            }
        }
        return 0;
    }

    @Override
    public boolean apply(Unifier u) {
        boolean r = false;
        int tss = this.getArity();
        for (int i = 0; i < tss; ++i) {
            boolean tr = this.getTerm(i).apply(u);
            r = r || tr;
        }
        if (r) {
            this.resetHashCodeCache();
        }
        return r;
    }

    @Override
    public Term clone() {
        return new Structure(this);
    }

    @Override
    public void addTerm(Term t) {
        if (t == null) {
            return;
        }
        this.terms.add(t);
        this.predicateIndicatorCache = null;
        this.resetHashCodeCache();
    }

    @Override
    public void delTerm(int index) {
        this.terms.remove(index);
        this.predicateIndicatorCache = null;
        this.resetHashCodeCache();
    }

    @Override
    public Literal addTerms(Term ... ts) {
        for (Term t : ts) {
            this.terms.add(t);
        }
        this.predicateIndicatorCache = null;
        this.resetHashCodeCache();
        return this;
    }

    @Override
    public Literal addTerms(List<Term> l) {
        for (Term t : l) {
            this.terms.add(t);
        }
        this.predicateIndicatorCache = null;
        this.resetHashCodeCache();
        return this;
    }

    @Override
    public Literal setTerms(List<Term> l) {
        this.terms = l;
        this.predicateIndicatorCache = null;
        this.resetHashCodeCache();
        return this;
    }

    @Override
    public void setTerm(int i, Term t) {
        this.terms.set(i, t);
        this.resetHashCodeCache();
    }

    @Override
    public Term getTerm(int i) {
        return this.terms.get(i);
    }

    @Override
    public int getArity() {
        if (this.terms == null) {
            return 0;
        }
        return this.terms.size();
    }

    public int getTermsSize() {
        return this.getArity();
    }

    @Override
    public List<Term> getTerms() {
        return this.terms;
    }

    @Override
    public boolean hasTerm() {
        return this.getArity() > 0;
    }

    @Override
    public boolean isStructure() {
        return true;
    }

    @Override
    public boolean isAtom() {
        return !this.hasTerm();
    }

    @Override
    public boolean isGround() {
        int size = this.getArity();
        for (int i = 0; i < size; ++i) {
            if (this.getTerm(i).isGround()) continue;
            return false;
        }
        return true;
    }

    @Override
    public Literal makeVarsAnnon() {
        return this.makeVarsAnnon(new Unifier());
    }

    @Override
    public Literal makeVarsAnnon(Unifier un) {
        int size = this.getArity();
        for (int i = 0; i < size; ++i) {
            Term ti = this.getTerm(i);
            if (ti.isVar()) {
                this.setTerm(i, this.varToReplace(ti, un));
                continue;
            }
            if (!(ti instanceof Structure)) continue;
            ((Structure)ti).makeVarsAnnon(un);
        }
        this.resetHashCodeCache();
        return this;
    }

    protected VarTerm varToReplace(Term t, Unifier un) {
        VarTerm vt = (VarTerm)t;
        VarTerm deref = un.deref(vt);
        if (deref.equals(vt)) {
            UnnamedVar var = new UnnamedVar("_" + UnnamedVar.getUniqueId() + t);
            if (deref.hasAnnot()) {
                var.setAnnots(deref.getAnnots().cloneLT());
                var.makeVarsAnnon(un);
            }
            un.bind(deref, var);
            return var;
        }
        deref = (VarTerm)deref.clone();
        if (vt.hasAnnot() && !deref.hasAnnot()) {
            deref.setAnnots(vt.getAnnots().cloneLT());
            deref.makeVarsAnnon(un);
        }
        return deref;
    }

    @Override
    public void makeTermsAnnon() {
        int size = this.getArity();
        for (int i = 0; i < size; ++i) {
            this.setTerm(i, new UnnamedVar());
        }
        this.resetHashCodeCache();
    }

    @Override
    public boolean hasVar(VarTerm t) {
        int size = this.getArity();
        for (int i = 0; i < size; ++i) {
            if (!this.getTerm(i).hasVar(t)) continue;
            return true;
        }
        return false;
    }

    @Override
    public List<VarTerm> getSingletonVars() {
        HashMap<VarTerm, Integer> all = new HashMap<VarTerm, Integer>();
        this.countVars(all);
        ArrayList<VarTerm> r = new ArrayList<VarTerm>();
        for (VarTerm k : all.keySet()) {
            if ((Integer)all.get(k) != 1 || k.isUnnamedVar()) continue;
            r.add(k);
        }
        return r;
    }

    @Override
    public void countVars(Map<VarTerm, Integer> c) {
        int tss = this.getArity();
        for (int i = 0; i < tss; ++i) {
            this.getTerm(i).countVars(c);
        }
    }

    @Override
    public String toString() {
        StringBuilder s = new StringBuilder();
        if (this.getFunctor() != null) {
            s.append(this.getFunctor());
        }
        if (this.getArity() > 0) {
            s.append('(');
            Iterator<Term> i = this.terms.iterator();
            while (i.hasNext()) {
                s.append(i.next());
                if (!i.hasNext()) continue;
                s.append(',');
            }
            s.append(')');
        }
        return s.toString();
    }

    @Override
    public Element getAsDOM(Document document) {
        Element u = document.createElement("structure");
        u.setAttribute("functor", this.getFunctor());
        if (this.hasTerm()) {
            Element ea = document.createElement("arguments");
            for (Term t : this.getTerms()) {
                ea.appendChild(t.getAsDOM(document));
            }
            u.appendChild(ea);
        }
        return u;
    }
}

