/*
 * Decompiled with CFR 0.152.
 */
package jason.asSyntax;

import jason.asSemantics.Agent;
import jason.asSemantics.Unifier;
import jason.asSyntax.LogExpr;
import jason.asSyntax.PlanBody;
import jason.asSyntax.Structure;
import jason.asSyntax.Term;
import java.util.Iterator;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PlanBodyImpl
extends Structure
implements PlanBody,
Iterable<PlanBody> {
    private static final long serialVersionUID = 1L;
    private static final Logger logger = Logger.getLogger(PlanBodyImpl.class.getName());
    public static final String BODY_PLAN_FUNCTOR = ";";
    private Term term = null;
    private PlanBody next = null;
    private PlanBody.BodyType formType = PlanBody.BodyType.none;
    private boolean isTerm = false;

    public PlanBodyImpl() {
        super(BODY_PLAN_FUNCTOR, 0);
    }

    public PlanBodyImpl(PlanBody.BodyType t, Term b) {
        super(BODY_PLAN_FUNCTOR, 0);
        this.formType = t;
        if (b != null) {
            this.srcInfo = b.getSrcInfo();
        }
        this.term = b;
    }

    @Override
    public void setBodyNext(PlanBody next) {
        this.next = next;
    }

    @Override
    public PlanBody getBodyNext() {
        return this.next;
    }

    @Override
    public boolean isEmptyBody() {
        return this.term == null;
    }

    @Override
    public PlanBody.BodyType getBodyType() {
        return this.formType;
    }

    @Override
    public void setBodyType(PlanBody.BodyType bt) {
        this.formType = bt;
    }

    @Override
    public Term getBodyTerm() {
        return this.term;
    }

    @Override
    public void setBodyTerm(Term t) {
        this.term = t;
    }

    @Override
    public boolean isBodyTerm() {
        return this.isTerm;
    }

    @Override
    public boolean isAtom() {
        return false;
    }

    @Override
    public void setAsBodyTerm(boolean b) {
        if (b != this.isTerm) {
            this.isTerm = b;
            if (this.getBodyNext() != null) {
                this.getBodyNext().setAsBodyTerm(b);
            }
        }
    }

    @Override
    public boolean isPlanBody() {
        return true;
    }

    @Override
    public Iterator<PlanBody> iterator() {
        return new Iterator<PlanBody>(){
            PlanBody current;
            {
                this.current = PlanBodyImpl.this;
            }

            @Override
            public boolean hasNext() {
                return this.current != null && this.current.getBodyTerm() != null;
            }

            @Override
            public PlanBody next() {
                PlanBody r = this.current;
                if (this.current != null) {
                    this.current = this.current.getBodyNext();
                }
                return r;
            }

            @Override
            public void remove() {
            }
        };
    }

    @Override
    public int getArity() {
        if (this.term == null) {
            return 0;
        }
        if (this.next == null) {
            return 1;
        }
        return 2;
    }

    @Override
    public Term getTerm(int i) {
        if (i == 0) {
            return this.term;
        }
        if (i == 1) {
            if (this.next != null && this.next.getBodyTerm().isVar() && this.next.getBodyNext() == null) {
                return this.next.getBodyTerm();
            }
            return this.next;
        }
        return null;
    }

    @Override
    public void setTerm(int i, Term t) {
        if (i == 0) {
            this.term = t;
        }
        if (i == 1) {
            System.out.println("Should not setTerm(1) of body literal!");
        }
    }

    private boolean applyHead(Unifier u) {
        if (this.term != null && this.term.apply(u)) {
            if (this.term.isPlanBody()) {
                PlanBody baknext = this.next;
                this.formType = ((PlanBody)this.term).getBodyType();
                this.next = ((PlanBody)this.term).getBodyNext();
                this.term = ((PlanBody)this.term).getBodyTerm();
                if (baknext != null) {
                    baknext.apply(u);
                    this.getLastBody().add(baknext);
                }
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean apply(Unifier u) {
        boolean ok;
        boolean bl = ok = this.next != null && this.next.apply(u);
        if (this.applyHead(u)) {
            ok = true;
        }
        if (ok) {
            this.resetHashCodeCache();
        }
        return ok;
    }

    @Override
    public Iterator<Unifier> logicalConsequence(Agent ag, Unifier un) {
        logger.log(Level.WARNING, "PlanBodyImpl cannot be used for logical consequence!", new Exception());
        return LogExpr.EMPTY_UNIF_LIST.iterator();
    }

    @Override
    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (o == this) {
            return true;
        }
        if (o instanceof PlanBody) {
            PlanBody b = (PlanBody)o;
            return this.formType == b.getBodyType() && super.equals(o);
        }
        return false;
    }

    @Override
    public int calcHashCode() {
        return this.formType.hashCode() + super.calcHashCode();
    }

    @Override
    public boolean add(PlanBody bl) {
        if (this.term == null) {
            bl = bl.clonePB();
            this.swap(bl);
            this.next = bl.getBodyNext();
        } else if (this.next == null) {
            this.next = bl;
        } else {
            this.next.add(bl);
        }
        return true;
    }

    @Override
    public PlanBody getLastBody() {
        if (this.next == null) {
            return this;
        }
        return this.next.getLastBody();
    }

    @Override
    public boolean add(int index, PlanBody bl) {
        if (index == 0) {
            PlanBodyImpl newpb = new PlanBodyImpl(this.formType, this.term);
            newpb.setBodyNext(this.next);
            this.swap(bl);
            this.next = bl.getBodyNext();
            this.getLastBody().setBodyNext(newpb);
        } else if (this.next != null) {
            this.next.add(index - 1, bl);
        } else {
            this.next = bl;
        }
        return true;
    }

    @Override
    public Term removeBody(int index) {
        if (index == 0) {
            Term oldvalue = this.term;
            if (this.next == null) {
                this.term = null;
            } else {
                this.swap(this.next);
                this.next = this.next.getBodyNext();
            }
            return oldvalue;
        }
        return this.next.removeBody(index - 1);
    }

    @Override
    public int getPlanSize() {
        if (this.term == null) {
            return 0;
        }
        if (this.next == null) {
            return 1;
        }
        return this.next.getPlanSize() + 1;
    }

    private void swap(PlanBody bl) {
        PlanBody.BodyType bt = this.formType;
        this.formType = bl.getBodyType();
        bl.setBodyType(bt);
        Term l = this.term;
        this.term = bl.getBodyTerm();
        bl.setBodyTerm(l);
    }

    @Override
    public PlanBody clone() {
        if (this.term == null) {
            return new PlanBodyImpl();
        }
        PlanBodyImpl c = new PlanBodyImpl(this.formType, this.term.clone());
        c.isTerm = this.isTerm;
        if (this.next != null) {
            c.setBodyNext(this.getBodyNext().clonePB());
        }
        return c;
    }

    @Override
    public PlanBody clonePB() {
        return this.clone();
    }

    @Override
    public String toString() {
        if (this.term == null) {
            return "";
        }
        StringBuilder out = new StringBuilder();
        if (this.isTerm) {
            out.append("{ ");
        }
        PlanBody pb = this;
        while (pb != null) {
            if (pb.getBodyTerm() != null) {
                out.append((Object)pb.getBodyType());
                out.append(pb.getBodyTerm());
            }
            if ((pb = pb.getBodyNext()) == null) continue;
            out.append("; ");
        }
        if (this.isTerm) {
            out.append(" }");
        }
        return out.toString();
    }

    @Override
    public Element getAsDOM(Document document) {
        Element eb = document.createElement("body");
        for (PlanBody bl = this; bl != null && !bl.isEmptyBody(); bl = bl.getBodyNext()) {
            Element u = document.createElement("body-literal");
            if (bl.getBodyType().toString().length() > 0) {
                u.setAttribute("type", bl.getBodyType().toString());
            }
            u.appendChild(((Structure)bl.getBodyTerm()).getAsDOM(document));
            eb.appendChild(u);
        }
        return eb;
    }
}

