/*
 * Decompiled with CFR 0.152.
 */
package jason.asSyntax;

import jason.JasonException;
import jason.architecture.AgArch;
import jason.asSemantics.Agent;
import jason.asSemantics.Unifier;
import jason.asSyntax.Atom;
import jason.asSyntax.DefaultTerm;
import jason.asSyntax.ListTerm;
import jason.asSyntax.ListTermImpl;
import jason.asSyntax.LiteralImpl;
import jason.asSyntax.LogExpr;
import jason.asSyntax.LogicalFormula;
import jason.asSyntax.PredicateIndicator;
import jason.asSyntax.Rule;
import jason.asSyntax.Structure;
import jason.asSyntax.Term;
import jason.asSyntax.VarTerm;
import jason.asSyntax.parser.as2j;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Literal
extends DefaultTerm
implements LogicalFormula {
    private static final long serialVersionUID = 1L;
    private static Logger logger = Logger.getLogger(Literal.class.getName());
    public static final boolean LPos = true;
    public static final boolean LNeg = false;
    public static final Literal LTrue = new TrueLiteral();
    public static final Literal LFalse = new FalseLiteral();
    protected PredicateIndicator predicateIndicatorCache = null;
    private static final List<VarTerm> emptyListVar = new ArrayList<VarTerm>();

    public static Literal parseLiteral(String sLiteral) {
        try {
            as2j parser = new as2j(new StringReader(sLiteral));
            return parser.literal();
        }
        catch (Exception e2) {
            logger.log(Level.SEVERE, "Error parsing literal " + sLiteral, e2);
            return null;
        }
    }

    public Literal copy() {
        return (Literal)this.clone();
    }

    public abstract String getFunctor();

    @Override
    public boolean isLiteral() {
        return true;
    }

    public PredicateIndicator getPredicateIndicator() {
        if (this.predicateIndicatorCache == null) {
            this.predicateIndicatorCache = new PredicateIndicator(this.getFunctor(), this.getArity());
        }
        return this.predicateIndicatorCache;
    }

    public int getArity() {
        return 0;
    }

    public boolean hasTerm() {
        return false;
    }

    public List<Term> getTerms() {
        return Structure.emptyTermList;
    }

    public Term[] getTermsArray() {
        return this.getTerms().toArray(Structure.emptyTermArray);
    }

    public List<VarTerm> getSingletonVars() {
        return emptyListVar;
    }

    public void makeTermsAnnon() {
    }

    public Literal makeVarsAnnon() {
        return this;
    }

    public Literal makeVarsAnnon(Unifier un) {
        return this;
    }

    public ListTerm getAnnots() {
        return null;
    }

    public boolean hasAnnot(Term t) {
        return false;
    }

    public boolean hasAnnot() {
        return false;
    }

    public boolean hasSubsetAnnot(Literal p) {
        return true;
    }

    public boolean hasSubsetAnnot(Literal p, Unifier u) {
        return true;
    }

    public void clearAnnots() {
    }

    public ListTerm getAnnots(String functor) {
        return new ListTermImpl();
    }

    public ListTerm getSources() {
        return new ListTermImpl();
    }

    public boolean hasSource() {
        return false;
    }

    public boolean hasSource(Term agName) {
        return false;
    }

    public boolean canBeAddedInBB() {
        return false;
    }

    public boolean negated() {
        return false;
    }

    public boolean equalsAsStructure(Object p) {
        return false;
    }

    public void addTerm(Term t) {
        logger.log(Level.SEVERE, "addTerm is not implemented in the class " + this.getClass().getSimpleName(), new Exception());
    }

    public void delTerm(int index) {
        logger.log(Level.SEVERE, "delTerm is not implemented in the class " + this.getClass().getSimpleName(), new Exception());
    }

    public Literal addTerms(Term ... ts) {
        logger.log(Level.SEVERE, "addTerms is not implemented in the class " + this.getClass().getSimpleName(), new Exception());
        return null;
    }

    public Literal addTerms(List<Term> l) {
        logger.log(Level.SEVERE, "addTerms is not implemented in the class " + this.getClass().getSimpleName(), new Exception());
        return null;
    }

    public Term getTerm(int i) {
        logger.log(Level.SEVERE, "getTerm(i) is not implemented in the class " + this.getClass().getSimpleName(), new Exception());
        return null;
    }

    public Literal setTerms(List<Term> l) {
        logger.log(Level.SEVERE, "setTerms is not implemented in the class " + this.getClass().getSimpleName(), new Exception());
        return null;
    }

    public void setTerm(int i, Term t) {
        logger.log(Level.SEVERE, "setTerm is not implemented in the class " + this.getClass().getSimpleName(), new Exception());
    }

    public Literal setAnnots(ListTerm l) {
        logger.log(Level.SEVERE, "setAnnots is not implemented in the class " + this.getClass().getSimpleName(), new Exception());
        return null;
    }

    public boolean addAnnot(Term t) {
        logger.log(Level.SEVERE, "addAnnot(" + t + ") is not implemented in the class " + this.getClass().getSimpleName() + " of object " + this, new Exception());
        return false;
    }

    public Literal addAnnots(Term ... terms) {
        logger.log(Level.SEVERE, "addAnnots is not implemented in the class " + this.getClass().getSimpleName(), new Exception());
        return null;
    }

    public Literal addAnnots(List<Term> l) {
        logger.log(Level.SEVERE, "addAnnots is not implemented in the class " + this.getClass().getSimpleName(), new Exception());
        return null;
    }

    public boolean delAnnot(Term t) {
        logger.log(Level.SEVERE, "delAnnot is not implemented in the class " + this.getClass().getSimpleName(), new Exception());
        return false;
    }

    public boolean delAnnots(List<Term> l) {
        logger.log(Level.SEVERE, "delAnnots is not implemented in the class " + this.getClass().getSimpleName(), new Exception());
        return false;
    }

    public boolean importAnnots(Literal p) {
        logger.log(Level.SEVERE, "importAnnots is not implemented in the class " + this.getClass().getSimpleName(), new Exception());
        return false;
    }

    public void addSource(Term agName) {
        logger.log(Level.SEVERE, "addSource is not implemented in the class " + this.getClass().getSimpleName(), new Exception());
    }

    public boolean delSource(Term agName) {
        logger.log(Level.SEVERE, "delSource is not implemented in the class " + this.getClass().getSimpleName(), new Exception());
        return false;
    }

    public void delSources() {
        logger.log(Level.SEVERE, "delSources is not implemented in the class " + this.getClass().getSimpleName(), new Exception());
    }

    public Literal setNegated(boolean b) {
        logger.log(Level.SEVERE, "setNegated is not implemented in the class " + this.getClass().getSimpleName(), new Exception());
        return null;
    }

    @Override
    public Iterator<Unifier> logicalConsequence(final Agent ag, final Unifier un) {
        final Iterator<Literal> il = ag.getBB().getCandidateBeliefs(this, un);
        if (il == null) {
            return LogExpr.EMPTY_UNIF_LIST.iterator();
        }
        final AgArch arch = ag == null ? null : ag.getTS().getUserAgArch();
        final int nbAnnots = this.hasAnnot() && this.getAnnots().getTail() == null ? this.getAnnots().size() : 0;
        return new Iterator<Unifier>(){
            Unifier current = null;
            Iterator<Unifier> ruleIt = null;
            Literal cloneAnnon = null;
            Rule rule;
            boolean needsUpdate = true;
            Iterator<List<Term>> annotsOptions = null;
            Literal belInBB = null;

            @Override
            public boolean hasNext() {
                if (this.needsUpdate) {
                    this.get();
                }
                return this.current != null;
            }

            @Override
            public Unifier next() {
                if (this.needsUpdate) {
                    this.get();
                }
                Unifier a = this.current;
                if (this.current != null) {
                    this.needsUpdate = true;
                }
                return a;
            }

            private void get() {
                this.needsUpdate = false;
                this.current = null;
                if (arch != null && !arch.isRunning()) {
                    return;
                }
                while (this.annotsOptions != null && this.annotsOptions.hasNext()) {
                    Literal belToTry = this.belInBB.copy().setAnnots(null).addAnnots(this.annotsOptions.next());
                    Unifier u = un.clone();
                    if (!u.unifiesNoUndo(Literal.this, belToTry)) continue;
                    this.current = u;
                    return;
                }
                while (this.ruleIt != null && this.ruleIt.hasNext()) {
                    Unifier ruleUn = this.ruleIt.next();
                    Literal rhead = this.rule.headClone();
                    rhead.apply(ruleUn);
                    Literal.this.useDerefVars(rhead, ruleUn);
                    rhead.makeVarsAnnon();
                    Unifier unC = un.clone();
                    if (!unC.unifiesNoUndo(Literal.this, rhead)) continue;
                    this.current = unC;
                    return;
                }
                while (il.hasNext()) {
                    this.belInBB = (Literal)il.next();
                    if (this.belInBB.isRule()) {
                        Unifier ruleUn;
                        this.rule = (Rule)this.belInBB;
                        if (this.cloneAnnon == null) {
                            this.cloneAnnon = Literal.this.copy();
                            this.cloneAnnon.apply(un);
                            this.cloneAnnon.makeVarsAnnon();
                        }
                        if (!(ruleUn = new Unifier()).unifiesNoUndo(this.cloneAnnon, this.rule)) continue;
                        this.ruleIt = this.rule.getBody().logicalConsequence(ag, ruleUn);
                        this.get();
                        if (this.current == null) continue;
                        return;
                    }
                    if (nbAnnots > 0) {
                        int nbAnnotsB;
                        if (!this.belInBB.hasAnnot() || (nbAnnotsB = this.belInBB.getAnnots().size()) < nbAnnots) continue;
                        this.annotsOptions = this.belInBB.getAnnots().subSets(nbAnnots);
                        this.get();
                        if (this.current == null) continue;
                        return;
                    }
                    Unifier u = un.clone();
                    if (!u.unifiesNoUndo(Literal.this, this.belInBB)) continue;
                    this.current = u;
                    return;
                }
            }

            @Override
            public void remove() {
            }
        };
    }

    private void useDerefVars(Term p, Unifier un) {
        if (p instanceof Literal) {
            Literal l = (Literal)p;
            for (int i = 0; i < l.getArity(); ++i) {
                Term t = l.getTerm(i);
                if (t.isVar()) {
                    l.setTerm(i, un.deref((VarTerm)t));
                    continue;
                }
                this.useDerefVars(t, un);
            }
        }
    }

    public ListTerm getAsListOfTerms() {
        ListTermImpl l = new ListTermImpl();
        l.add(new LiteralImpl(!this.negated(), this.getFunctor()));
        ListTermImpl lt = new ListTermImpl();
        lt.addAll(this.getTerms());
        l.add(lt);
        if (this.hasAnnot()) {
            l.add(this.getAnnots().cloneLT());
        } else {
            l.add(new ListTermImpl());
        }
        return l;
    }

    public static Literal newFromListOfTerms(ListTerm lt) throws JasonException {
        try {
            Iterator i = lt.iterator();
            Term tfunctor = (Term)i.next();
            boolean pos = true;
            if (tfunctor.isLiteral() && ((Literal)tfunctor).negated()) {
                pos = false;
            }
            LiteralImpl l = new LiteralImpl(pos, ((Atom)tfunctor).getFunctor());
            if (i.hasNext()) {
                ((Literal)l).setTerms(((ListTerm)i.next()).cloneLT());
            }
            if (i.hasNext()) {
                ((Literal)l).setAnnots(((ListTerm)i.next()).cloneLT());
            }
            return l;
        }
        catch (Exception e2) {
            throw new JasonException("Error creating literal from " + lt);
        }
    }

    public Literal forceFullLiteralImpl() {
        if (this.isAtom() && !(this instanceof LiteralImpl)) {
            return new LiteralImpl(this);
        }
        return this;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static final class FalseLiteral
    extends Atom {
        public FalseLiteral() {
            super("false");
        }

        @Override
        public Iterator<Unifier> logicalConsequence(Agent ag, Unifier un) {
            return LogExpr.EMPTY_UNIF_LIST.iterator();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static final class TrueLiteral
    extends Atom {
        public TrueLiteral() {
            super("true");
        }

        @Override
        public Iterator<Unifier> logicalConsequence(Agent ag, Unifier un) {
            return LogExpr.createUnifIterator(un);
        }
    }
}

