/*
 * Decompiled with CFR 0.152.
 */
package jason.asSyntax;

import jason.asSemantics.Agent;
import jason.asSemantics.InternalAction;
import jason.asSemantics.Unifier;
import jason.asSyntax.LogExpr;
import jason.asSyntax.Structure;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InternalActionLiteral
extends Structure {
    private static final long serialVersionUID = 1L;
    private static Logger logger = Logger.getLogger(InternalActionLiteral.class.getName());
    private InternalAction ia = null;

    public InternalActionLiteral(String functor) {
        super(functor);
    }

    public InternalActionLiteral(InternalActionLiteral l) {
        super(l);
        this.ia = l.ia;
    }

    public InternalActionLiteral(Structure p, Agent ag) throws Exception {
        super(p);
        if (ag != null) {
            this.ia = ag.getIA(this.getFunctor());
        }
    }

    @Override
    public boolean isInternalAction() {
        return true;
    }

    @Override
    public boolean isAtom() {
        return false;
    }

    @Override
    public Iterator<Unifier> logicalConsequence(Agent ag, Unifier un) {
        if (ag == null || ag.getTS().getUserAgArch().isRunning()) {
            try {
                InternalAction ia = this.getIA(ag);
                Object oresult = ia.execute(ag.getTS(), un, ia.prepareArguments(this, un));
                if (oresult instanceof Boolean && ((Boolean)oresult).booleanValue()) {
                    return LogExpr.createUnifIterator(un);
                }
                if (oresult instanceof Iterator) {
                    return (Iterator)oresult;
                }
            }
            catch (ConcurrentModificationException e2) {
                System.out.println("*-*-* .count concurrent exception - try later");
                try {
                    Thread.sleep(200L);
                }
                catch (InterruptedException e1) {
                    // empty catch block
                }
                return this.logicalConsequence(ag, un);
            }
            catch (Exception e3) {
                logger.log(Level.SEVERE, this.getErrorMsg() + ": " + e3.getMessage(), e3);
            }
        }
        return LogExpr.EMPTY_UNIF_LIST.iterator();
    }

    public void setIA(InternalAction ia) {
        this.ia = ia;
    }

    public InternalAction getIA(Agent ag) throws Exception {
        if (this.ia == null && ag != null) {
            this.ia = ag.getIA(this.getFunctor());
        }
        return this.ia;
    }

    @Override
    public String getErrorMsg() {
        String src = this.getSrcInfo() == null ? "" : " (" + this.getSrcInfo() + ")";
        return "Error in internal action '" + this + "'" + src;
    }

    @Override
    public InternalActionLiteral clone() {
        return new InternalActionLiteral(this);
    }

    @Override
    public Element getAsDOM(Document document) {
        Element u = super.getAsDOM(document);
        u.setAttribute("ia", this.isInternalAction() + "");
        return u;
    }
}

