/*
 * Decompiled with CFR 0.152.
 */
package jason.asSyntax;

import jason.asSyntax.Atom;
import jason.asSyntax.ListTerm;
import jason.asSyntax.ListTermImpl;
import jason.asSyntax.Literal;
import jason.asSyntax.LiteralImpl;
import jason.asSyntax.LogicalFormula;
import jason.asSyntax.NumberTerm;
import jason.asSyntax.NumberTermImpl;
import jason.asSyntax.Plan;
import jason.asSyntax.PlanBody;
import jason.asSyntax.Rule;
import jason.asSyntax.StringTerm;
import jason.asSyntax.StringTermImpl;
import jason.asSyntax.Structure;
import jason.asSyntax.Term;
import jason.asSyntax.Trigger;
import jason.asSyntax.UnnamedVar;
import jason.asSyntax.VarTerm;
import jason.asSyntax.parser.ParseException;
import jason.asSyntax.parser.as2j;
import java.io.StringReader;
import java.util.Collection;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ASSyntax {
    public static Literal createLiteral(String functor, Term ... terms) {
        return new LiteralImpl(functor).addTerms(terms);
    }

    public static Literal createLiteral(boolean positive, String functor, Term ... terms) {
        return new LiteralImpl(positive, functor).addTerms(terms);
    }

    public static Structure createStructure(String functor, Term ... terms) {
        int size = terms == null || terms.length == 0 ? 3 : terms.length;
        return (Structure)new Structure(functor, size).addTerms(terms);
    }

    public static Atom createAtom(String functor) {
        return new Atom(functor);
    }

    public static NumberTerm createNumber(double vl) {
        return new NumberTermImpl(vl);
    }

    public static StringTerm createString(String s) {
        return new StringTermImpl(s);
    }

    public static StringTerm createString(Object o) {
        return new StringTermImpl(o.toString());
    }

    public static VarTerm createVar(String functor) {
        return new VarTerm(functor);
    }

    public static VarTerm createVar() {
        return new UnnamedVar();
    }

    public static ListTerm createList(Term ... terms) {
        ListTermImpl l;
        ListTerm tail = l = new ListTermImpl();
        for (Term t : terms) {
            tail = tail.append(t);
        }
        return l;
    }

    public static ListTerm createList(Collection<Term> terms) {
        ListTermImpl l;
        ListTerm tail = l = new ListTermImpl();
        for (Term t : terms) {
            tail = tail.append(t.clone());
        }
        return l;
    }

    public static Rule createRule(Literal head, LogicalFormula body) {
        return new Rule(head, body);
    }

    public static Literal parseLiteral(String sLiteral) throws ParseException {
        as2j parser = new as2j(new StringReader(sLiteral));
        Literal l = parser.literal();
        if (parser.getNextToken().kind != 0) {
            throw new ParseException("Expected <EOF> after " + l + " for parameter '" + sLiteral + "'");
        }
        return l;
    }

    public static NumberTerm parseNumber(String sNumber) throws NumberFormatException {
        return new NumberTermImpl(Double.parseDouble(sNumber));
    }

    public static Structure parseStructure(String sStructure) throws ParseException {
        as2j parser = new as2j(new StringReader(sStructure));
        Term t = parser.term();
        if (parser.getNextToken().kind != 0) {
            throw new ParseException("Expected <EOF> after " + t + " for parameter '" + sStructure + "'");
        }
        if (t instanceof Structure) {
            return (Structure)t;
        }
        return new Structure((Literal)t);
    }

    public static VarTerm parseVar(String sVar) throws ParseException {
        as2j parser = new as2j(new StringReader(sVar));
        VarTerm v = parser.var();
        if (parser.getNextToken().kind != 0) {
            throw new ParseException("Expected <EOF> after " + v + " for parameter '" + sVar + "'");
        }
        return v;
    }

    public static Term parseTerm(String sTerm) throws ParseException {
        as2j parser = new as2j(new StringReader(sTerm));
        Term t = parser.term();
        if (parser.getNextToken().kind != 0) {
            throw new ParseException("Expected <EOF> after " + t + " for parameter '" + sTerm + "'");
        }
        return t;
    }

    public static Plan parsePlan(String sPlan) throws ParseException {
        as2j parser = new as2j(new StringReader(sPlan));
        Plan p = parser.plan();
        if (parser.getNextToken().kind != 0) {
            throw new ParseException("Expected <EOF> after " + p + " for parameter '" + sPlan + "'");
        }
        return p;
    }

    public static PlanBody parsePlanBody(String sPlanBody) throws ParseException {
        as2j parser = new as2j(new StringReader(sPlanBody));
        PlanBody p = parser.plan_body();
        if (parser.getNextToken().kind != 0) {
            throw new ParseException("Expected <EOF> after " + p + " for parameter '" + sPlanBody + "'");
        }
        return p;
    }

    public static Trigger parseTrigger(String sTe) throws ParseException {
        as2j parser = new as2j(new StringReader(sTe));
        Trigger te = parser.trigger();
        if (parser.getNextToken().kind != 0) {
            throw new ParseException("Expected <EOF> after " + te + " for parameter '" + sTe + "'");
        }
        return te;
    }

    public static ListTerm parseList(String sList) throws ParseException {
        as2j parser = new as2j(new StringReader(sList));
        ListTermImpl l = parser.list();
        if (parser.getNextToken().kind != 0) {
            throw new ParseException("Expected <EOF> after " + l + " for parameter '" + sList + "'");
        }
        return l;
    }

    public static LogicalFormula parseFormula(String sExpr) throws ParseException {
        as2j parser = new as2j(new StringReader(sExpr));
        LogicalFormula l = (LogicalFormula)parser.log_expr();
        if (parser.getNextToken().kind != 0) {
            throw new ParseException("Expected <EOF> after " + l + " for parameter '" + sExpr + "'");
        }
        return l;
    }

    public static Rule parseRule(String sRule) throws ParseException {
        as2j parser = new as2j(new StringReader(sRule));
        Rule r = (Rule)parser.belief();
        if (parser.getNextToken().kind != 0) {
            throw new ParseException("Expected <EOF> after " + r + " for parameter '" + sRule + "'");
        }
        return r;
    }
}

