/*
 * Decompiled with CFR 0.152.
 */
package jason.asSemantics;

import jason.asSemantics.IntendedMeans;
import jason.asSemantics.Unifier;
import jason.asSyntax.ListTermImpl;
import jason.asSyntax.NumberTermImpl;
import jason.asSyntax.Structure;
import jason.asSyntax.Term;
import jason.asSyntax.Trigger;
import java.io.Serializable;
import java.util.ListIterator;
import java.util.Stack;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Intention
implements Serializable,
Comparable<Intention> {
    private static final long serialVersionUID = 1L;
    public static final Intention EmptyInt = null;
    private static int idCount = 0;
    private int id;
    private int atomicCount = 0;
    private boolean isSuspended = false;
    private Stack<IntendedMeans> intendedMeans = new Stack();

    public Intention() {
        this.id = ++idCount;
    }

    public int getId() {
        return this.id;
    }

    public void push(IntendedMeans im) {
        this.intendedMeans.push(im);
        if (im.isAtomic()) {
            ++this.atomicCount;
        }
    }

    public IntendedMeans peek() {
        return this.intendedMeans.peek();
    }

    public IntendedMeans get(int index) {
        return (IntendedMeans)this.intendedMeans.get(index);
    }

    public IntendedMeans pop() {
        IntendedMeans top = this.intendedMeans.pop();
        if (this.isAtomic() && top.isAtomic()) {
            --this.atomicCount;
        }
        return top;
    }

    public boolean isAtomic() {
        return this.atomicCount > 0;
    }

    public void setAtomic(int a) {
        this.atomicCount = a;
    }

    public ListIterator<IntendedMeans> iterator() {
        return this.intendedMeans.listIterator(this.intendedMeans.size());
    }

    public boolean isFinished() {
        return this.intendedMeans.isEmpty();
    }

    public int size() {
        return this.intendedMeans.size();
    }

    public void setSuspended(boolean b) {
        this.isSuspended = b;
    }

    public boolean isSuspended() {
        return this.isSuspended;
    }

    public Stack<IntendedMeans> getIMs() {
        return this.intendedMeans;
    }

    public IntendedMeans getIM(Trigger g, Unifier u) {
        for (IntendedMeans im : this.intendedMeans) {
            if (!u.unifies(g, im.getTrigger())) continue;
            return im;
        }
        return null;
    }

    public boolean hasTrigger(Trigger g, Unifier u) {
        for (IntendedMeans im : this.intendedMeans) {
            if (!u.unifies(g, im.getTrigger())) continue;
            return true;
        }
        return false;
    }

    public boolean dropGoal(Trigger te, Unifier un) {
        IntendedMeans im = this.getIM(te, un);
        if (im != null) {
            while (this.peek() != im) {
                this.pop();
            }
            this.pop();
            return true;
        }
        return false;
    }

    @Override
    public int compareTo(Intention o) {
        if (o.atomicCount > this.atomicCount) {
            return 1;
        }
        if (this.atomicCount > o.atomicCount) {
            return -1;
        }
        return 0;
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (o == this) {
            return true;
        }
        if (o instanceof Intention) {
            return ((Intention)o).id == this.id;
        }
        return false;
    }

    public int hashCode() {
        return String.valueOf(this.id).hashCode();
    }

    public Intention clone() {
        Intention i = new Intention();
        i.id = this.id;
        i.atomicCount = this.atomicCount;
        i.intendedMeans = new Stack();
        for (IntendedMeans im : this.intendedMeans) {
            i.intendedMeans.add((IntendedMeans)im.clone());
        }
        return i;
    }

    public String toString() {
        StringBuilder s = new StringBuilder();
        ListIterator i = this.intendedMeans.listIterator(this.intendedMeans.size());
        while (i.hasPrevious()) {
            s.append("    " + i.previous() + "\n");
        }
        return s.toString();
    }

    public Term getAsTerm() {
        Structure intention = new Structure("intention");
        intention.addTerm(new NumberTermImpl(this.getId()));
        ListTermImpl lt = new ListTermImpl();
        ListIterator i = this.intendedMeans.listIterator(this.intendedMeans.size());
        while (i.hasPrevious()) {
            lt.add(((IntendedMeans)i.previous()).getAsTerm());
        }
        intention.addTerm(lt);
        return intention;
    }

    public Element getAsDOM(Document document) {
        Element eint = document.createElement("intention");
        eint.setAttribute("id", this.id + "");
        for (int i = this.intendedMeans.size() - 1; i >= 0; --i) {
            IntendedMeans im = (IntendedMeans)this.intendedMeans.get(i);
            eint.appendChild(im.getAsDOM(document));
        }
        return eint;
    }
}

