/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.surefire.junit;

import java.util.Iterator;
import java.util.ResourceBundle;
import org.apache.maven.surefire.junit.JUnit3TestChecker;
import org.apache.maven.surefire.junit.JUnitTestSet;
import org.apache.maven.surefire.junit.PojoTestSet;
import org.apache.maven.surefire.junit.SurefireTestSet;
import org.apache.maven.surefire.providerapi.ProviderParameters;
import org.apache.maven.surefire.providerapi.SurefireProvider;
import org.apache.maven.surefire.report.DefaultReportEntry;
import org.apache.maven.surefire.report.ReportEntry;
import org.apache.maven.surefire.report.ReporterException;
import org.apache.maven.surefire.report.ReporterFactory;
import org.apache.maven.surefire.report.ReporterManager;
import org.apache.maven.surefire.suite.RunResult;
import org.apache.maven.surefire.testset.TestSetFailedException;
import org.apache.maven.surefire.util.DirectoryScanner;
import org.apache.maven.surefire.util.ScannerFilter;
import org.apache.maven.surefire.util.TestsToRun;

public class JUnit3Provider
implements SurefireProvider {
    private final ReporterFactory reporterFactory;
    private final ClassLoader testClassLoader;
    private final DirectoryScanner directoryScanner;
    private final JUnit3TestChecker jUnit3TestChecker;
    private TestsToRun testsToRun;
    private static ResourceBundle bundle = ResourceBundle.getBundle("org.apache.maven.surefire.surefire");

    public JUnit3Provider(ProviderParameters booterParameters) {
        this.reporterFactory = booterParameters.getReporterFactory();
        this.testClassLoader = booterParameters.getTestClassLoader();
        this.directoryScanner = booterParameters.getDirectoryScanner();
        this.jUnit3TestChecker = new JUnit3TestChecker(this.testClassLoader);
    }

    public RunResult invoke(Object forkTestSet) throws TestSetFailedException, ReporterException {
        if (this.testsToRun == null) {
            this.testsToRun = forkTestSet == null ? this.scanClassPath() : TestsToRun.fromClass((Class)((Class)forkTestSet));
        }
        Iterator iter = this.testsToRun.iterator();
        while (iter.hasNext()) {
            Class clazz = (Class)iter.next();
            ReporterManager reporter = (ReporterManager)this.reporterFactory.createReporter();
            SurefireTestSet surefireTestSet = this.createTestSet(clazz);
            this.executeTestSet(surefireTestSet, this.reporterFactory, this.testClassLoader);
        }
        return this.reporterFactory.close();
    }

    private SurefireTestSet createTestSet(Class clazz) throws TestSetFailedException {
        return this.jUnit3TestChecker.isJunit3Test(clazz) ? new JUnitTestSet(clazz) : new PojoTestSet(clazz);
    }

    private void executeTestSet(SurefireTestSet testSet, ReporterFactory reporterManagerFactory, ClassLoader classLoader) throws ReporterException, TestSetFailedException {
        ReporterManager reporterManager = (ReporterManager)reporterManagerFactory.createReporter();
        String rawString = bundle.getString("testSetStarting");
        DefaultReportEntry report = new DefaultReportEntry(this.getClass().getName(), testSet.getName(), rawString);
        reporterManager.testSetStarting((ReportEntry)report);
        testSet.execute(reporterManager, classLoader);
        rawString = bundle.getString("testSetCompletedNormally");
        report = new DefaultReportEntry(this.getClass().getName(), testSet.getName(), rawString);
        reporterManager.testSetCompleted((ReportEntry)report);
        reporterManager.reset();
    }

    private TestsToRun scanClassPath() {
        return this.directoryScanner.locateTestClasses(this.testClassLoader, (ScannerFilter)this.jUnit3TestChecker);
    }

    public Iterator getSuites() {
        this.testsToRun = this.scanClassPath();
        return this.testsToRun.iterator();
    }

    public Boolean isRunnable() {
        return Boolean.TRUE;
    }
}

