/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.shared.repository;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.security.NoSuchAlgorithmException;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TimeZone;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.ArtifactUtils;
import org.apache.maven.artifact.factory.ArtifactFactory;
import org.apache.maven.artifact.metadata.ArtifactMetadata;
import org.apache.maven.artifact.metadata.ArtifactMetadataSource;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.repository.ArtifactRepositoryFactory;
import org.apache.maven.artifact.repository.DefaultArtifactRepository;
import org.apache.maven.artifact.repository.layout.ArtifactRepositoryLayout;
import org.apache.maven.artifact.repository.metadata.ArtifactRepositoryMetadata;
import org.apache.maven.artifact.repository.metadata.Versioning;
import org.apache.maven.artifact.repository.metadata.io.xpp3.MetadataXpp3Writer;
import org.apache.maven.artifact.resolver.ArtifactNotFoundException;
import org.apache.maven.artifact.resolver.ArtifactResolutionException;
import org.apache.maven.artifact.resolver.ArtifactResolutionResult;
import org.apache.maven.artifact.resolver.ArtifactResolver;
import org.apache.maven.artifact.resolver.filter.AndArtifactFilter;
import org.apache.maven.artifact.resolver.filter.ArtifactFilter;
import org.apache.maven.artifact.resolver.filter.ExcludesArtifactFilter;
import org.apache.maven.artifact.versioning.InvalidVersionSpecificationException;
import org.apache.maven.artifact.versioning.VersionRange;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.DependencyManagement;
import org.apache.maven.model.Exclusion;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.MavenProjectBuilder;
import org.apache.maven.project.ProjectBuildingException;
import org.apache.maven.shared.artifact.filter.PatternExcludesArtifactFilter;
import org.apache.maven.shared.artifact.filter.PatternIncludesArtifactFilter;
import org.apache.maven.shared.artifact.filter.ScopeArtifactFilter;
import org.apache.maven.shared.repository.RepositoryAssembler;
import org.apache.maven.shared.repository.RepositoryAssemblyException;
import org.apache.maven.shared.repository.RepositoryBuilderConfigSource;
import org.apache.maven.shared.repository.model.GroupVersionAlignment;
import org.apache.maven.shared.repository.model.RepositoryInfo;
import org.apache.maven.shared.repository.utils.DigestUtils;
import org.codehaus.plexus.PlexusContainer;
import org.codehaus.plexus.component.repository.exception.ComponentLookupException;
import org.codehaus.plexus.context.Context;
import org.codehaus.plexus.context.ContextException;
import org.codehaus.plexus.logging.AbstractLogEnabled;
import org.codehaus.plexus.logging.Logger;
import org.codehaus.plexus.logging.console.ConsoleLogger;
import org.codehaus.plexus.personality.plexus.lifecycle.phase.Contextualizable;
import org.codehaus.plexus.util.FileUtils;
import org.codehaus.plexus.util.IOUtil;

public class DefaultRepositoryAssembler
extends AbstractLogEnabled
implements RepositoryAssembler,
Contextualizable {
    private static final String[] PREFERRED_RESOLVER_HINTS = new String[]{"project-cache-aware", "default"};
    protected static final TimeZone UTC_TIME_ZONE = TimeZone.getTimeZone("UTC");
    protected static final String UTC_TIMESTAMP_PATTERN = "yyyyMMddHHmmss";
    protected ArtifactFactory artifactFactory;
    protected ArtifactResolver artifactResolver;
    protected ArtifactRepositoryLayout repositoryLayout;
    protected ArtifactRepositoryFactory artifactRepositoryFactory;
    protected ArtifactMetadataSource metadataSource;
    protected MavenProjectBuilder projectBuilder;
    static /* synthetic */ Class class$org$apache$maven$project$DefaultMavenProjectBuilder;

    public DefaultRepositoryAssembler() {
    }

    public DefaultRepositoryAssembler(ArtifactFactory artifactFactory, ArtifactResolver artifactResolver, ArtifactRepositoryLayout repositoryLayout, ArtifactRepositoryFactory artifactRepositoryFactory, ArtifactMetadataSource metadataSource, MavenProjectBuilder projectBuilder) {
        this.artifactFactory = artifactFactory;
        this.artifactResolver = artifactResolver;
        this.repositoryLayout = repositoryLayout;
        this.artifactRepositoryFactory = artifactRepositoryFactory;
        this.metadataSource = metadataSource;
        this.projectBuilder = projectBuilder;
        this.enableLogging((Logger)new ConsoleLogger(0, this.getClass().getName() + "::Internal"));
    }

    public void buildRemoteRepository(File repositoryDirectory, RepositoryInfo repository, RepositoryBuilderConfigSource configSource) throws RepositoryAssemblyException {
        MavenProject project = configSource.getProject();
        ArtifactRepository localRepository = configSource.getLocalRepository();
        Map groupVersionAlignments = this.createGroupVersionAlignments(repository.getGroupVersionAlignments());
        ArtifactRepository targetRepository = this.createLocalRepository(repositoryDirectory);
        ArtifactResolutionResult result = null;
        Set dependencyArtifacts = project.getDependencyArtifacts();
        if (dependencyArtifacts == null) {
            Logger logger = this.getLogger();
            if (logger.isDebugEnabled()) {
                logger.debug("dependency-artifact set for project: " + project.getId() + " is null. Skipping repository processing.");
            }
            return;
        }
        try {
            result = this.artifactResolver.resolveTransitively(dependencyArtifacts, project.getArtifact(), this.getManagedVersionMap(project), localRepository, project.getRemoteArtifactRepositories(), this.metadataSource);
        }
        catch (ArtifactResolutionException e) {
            throw new RepositoryAssemblyException("Error resolving artifacts: " + e.getMessage(), e);
        }
        catch (ArtifactNotFoundException e) {
            throw new RepositoryAssemblyException("Error resolving artifacts: " + e.getMessage(), e);
        }
        catch (InvalidVersionSpecificationException e) {
            throw new RepositoryAssemblyException("Error resolving artifacts: " + e.getMessage(), e);
        }
        try {
            this.invalidateProccessedProjectCache();
        }
        catch (Exception e) {
            throw new RepositoryAssemblyException("Error invalidating the processed project cache.", e);
        }
        ArtifactFilter filter = this.buildRepositoryFilter(repository, project);
        this.assembleRepositoryArtifacts(result, filter, project, localRepository, targetRepository, repositoryDirectory, groupVersionAlignments);
        ArtifactRepository centralRepository = this.findCentralRepository(project);
        if (repository.isIncludeMetadata()) {
            this.assembleRepositoryMetadata(result, filter, centralRepository, targetRepository);
        }
        this.addPomWithAncestry(project.getArtifact(), project.getRemoteArtifactRepositories(), localRepository, targetRepository, groupVersionAlignments, project);
    }

    private ArtifactFilter buildRepositoryFilter(RepositoryInfo repository, MavenProject project) {
        AndArtifactFilter filter = new AndArtifactFilter();
        ScopeArtifactFilter scopeFilter = new ScopeArtifactFilter(repository.getScope());
        filter.add((ArtifactFilter)scopeFilter);
        List includes = repository.getIncludes();
        if (includes == null || includes.isEmpty()) {
            ArrayList<String> patterns = new ArrayList<String>();
            Set projectArtifacts = project.getDependencyArtifacts();
            if (projectArtifacts != null) {
                Iterator it = projectArtifacts.iterator();
                while (it.hasNext()) {
                    Artifact artifact = (Artifact)it.next();
                    patterns.add(artifact.getDependencyConflictId());
                }
            }
            PatternIncludesArtifactFilter includeFilter = new PatternIncludesArtifactFilter(patterns, true);
            filter.add((ArtifactFilter)includeFilter);
        } else {
            filter.add((ArtifactFilter)new PatternIncludesArtifactFilter(repository.getIncludes(), true));
        }
        List excludes = repository.getExcludes();
        if (excludes != null && !excludes.isEmpty()) {
            filter.add((ArtifactFilter)new PatternExcludesArtifactFilter(repository.getExcludes(), true));
        }
        return filter;
    }

    private void assembleRepositoryArtifacts(ArtifactResolutionResult result, ArtifactFilter filter, MavenProject project, ArtifactRepository localRepository, ArtifactRepository targetRepository, File repositoryDirectory, Map groupVersionAlignments) throws RepositoryAssemblyException {
        try {
            FileUtils.deleteDirectory((File)repositoryDirectory);
            FileUtils.mkdir((String)repositoryDirectory.getAbsolutePath());
            Iterator i = result.getArtifacts().iterator();
            while (i.hasNext()) {
                Artifact a = (Artifact)i.next();
                if (!filter.include(a)) continue;
                this.getLogger().debug("Re-resolving: " + a + " for repository assembly.");
                this.setAlignment(a, groupVersionAlignments);
                a.setResolved(false);
                this.artifactResolver.resolve(a, project.getRemoteArtifactRepositories(), localRepository);
                a.setVersion(a.getBaseVersion());
                File targetFile = new File(targetRepository.getBasedir(), targetRepository.pathOf(a));
                FileUtils.copyFile((File)a.getFile(), (File)targetFile);
                this.writeChecksums(targetFile);
                this.addPomWithAncestry(a, project.getRemoteArtifactRepositories(), localRepository, targetRepository, groupVersionAlignments, project);
            }
        }
        catch (ArtifactResolutionException e) {
            throw new RepositoryAssemblyException("Error resolving artifacts: " + e.getMessage(), e);
        }
        catch (ArtifactNotFoundException e) {
            throw new RepositoryAssemblyException("Error resolving artifacts: " + e.getMessage(), e);
        }
        catch (IOException e) {
            throw new RepositoryAssemblyException("Error writing artifact metdata.", e);
        }
    }

    private void addPomWithAncestry(Artifact artifact, List remoteArtifactRepositories, ArtifactRepository localRepository, ArtifactRepository targetRepository, Map groupVersionAlignments, MavenProject masterProject) throws RepositoryAssemblyException {
        MavenProject p;
        String type = artifact.getType();
        Map refs = masterProject.getProjectReferences();
        String projectKey = ArtifactUtils.versionlessKey((Artifact)artifact);
        if (artifact == masterProject.getArtifact()) {
            p = masterProject;
        } else if (refs.containsKey(projectKey)) {
            p = (MavenProject)refs.get(projectKey);
        } else {
            try {
                artifact.isSnapshot();
                Artifact pomArtifact = this.artifactFactory.createProjectArtifact(artifact.getGroupId(), artifact.getArtifactId(), artifact.getBaseVersion());
                this.getLogger().debug("Building MavenProject instance for: " + pomArtifact + ". NOTE: This SHOULD BE available in the Artifact API! ...but it's not.");
                p = this.projectBuilder.buildFromRepository(pomArtifact, remoteArtifactRepositories, localRepository);
            }
            catch (ProjectBuildingException e) {
                throw new RepositoryAssemblyException("Error reading POM for: " + artifact.getId(), e);
            }
        }
        if ("pom".equals(type)) {
            p = p.getParent();
        }
        while (p != null) {
            Artifact destArtifact = this.artifactFactory.createProjectArtifact(p.getGroupId(), p.getArtifactId(), p.getVersion());
            this.setAlignment(destArtifact, groupVersionAlignments);
            File sourceFile = p.getFile();
            if (sourceFile == null || !sourceFile.exists()) {
                Artifact srcArtifact = this.artifactFactory.createProjectArtifact(p.getGroupId(), p.getArtifactId(), p.getVersion());
                sourceFile = new File(localRepository.getBasedir(), localRepository.pathOf(srcArtifact));
            }
            if (!sourceFile.exists()) break;
            File targetFile = new File(targetRepository.getBasedir(), targetRepository.pathOf(destArtifact));
            try {
                FileUtils.copyFile((File)sourceFile, (File)targetFile);
            }
            catch (IOException e) {
                throw new RepositoryAssemblyException("Error writing POM metdata: " + destArtifact.getId(), e);
            }
            try {
                this.writeChecksums(targetFile);
            }
            catch (IOException e) {
                throw new RepositoryAssemblyException("Error writing checksums for POM: " + destArtifact.getId(), e);
            }
            p = p.getParent();
        }
    }

    private ArtifactRepository findCentralRepository(MavenProject project) {
        ArtifactRepository centralRepository = null;
        Iterator i = project.getRemoteArtifactRepositories().iterator();
        while (i.hasNext()) {
            ArtifactRepository r = (ArtifactRepository)i.next();
            if (!"central".equals(r.getId())) continue;
            centralRepository = r;
        }
        return centralRepository;
    }

    private void assembleRepositoryMetadata(ArtifactResolutionResult result, ArtifactFilter filter, ArtifactRepository centralRepository, ArtifactRepository targetRepository) throws RepositoryAssemblyException {
        Iterator i = result.getArtifacts().iterator();
        while (i.hasNext()) {
            Artifact a = (Artifact)i.next();
            if (!filter.include(a)) continue;
            Versioning v = new Versioning();
            v.setRelease(a.getVersion());
            v.setLatest(a.getVersion());
            v.addVersion(a.getVersion());
            v.setLastUpdated(DefaultRepositoryAssembler.getUtcDateFormatter().format(new Date()));
            ArtifactRepositoryMetadata metadata = new ArtifactRepositoryMetadata(a, v);
            String path = targetRepository.pathOfLocalRepositoryMetadata((ArtifactMetadata)metadata, centralRepository);
            File metadataFile = new File(targetRepository.getBasedir(), path);
            MetadataXpp3Writer metadataWriter = new MetadataXpp3Writer();
            FileWriter writer = null;
            try {
                writer = new FileWriter(metadataFile);
                metadataWriter.write((Writer)writer, metadata.getMetadata());
            }
            catch (IOException e) {
                try {
                    throw new RepositoryAssemblyException("Error writing artifact metdata.", e);
                }
                catch (Throwable throwable) {
                    IOUtil.close(writer);
                    throw throwable;
                }
            }
            IOUtil.close((Writer)writer);
            try {
                this.writeChecksums(metadataFile);
                File metadataFileRemote = new File(targetRepository.getBasedir(), targetRepository.pathOfRemoteRepositoryMetadata((ArtifactMetadata)metadata));
                FileUtils.copyFile((File)metadataFile, (File)metadataFileRemote);
                FileUtils.copyFile((File)new File(metadataFile.getParentFile(), metadataFile.getName() + ".sha1"), (File)new File(metadataFileRemote.getParentFile(), metadataFileRemote.getName() + ".sha1"));
                FileUtils.copyFile((File)new File(metadataFile.getParentFile(), metadataFile.getName() + ".md5"), (File)new File(metadataFileRemote.getParentFile(), metadataFileRemote.getName() + ".md5"));
            }
            catch (IOException e) {
                throw new RepositoryAssemblyException("Error writing artifact metdata.", e);
            }
        }
    }

    private void writeChecksums(File file) throws IOException, RepositoryAssemblyException {
        try {
            String md5 = DigestUtils.createChecksum(file, "MD5");
            String sha1 = DigestUtils.createChecksum(file, "SHA-1");
            FileUtils.fileWrite((String)new File(file.getParentFile(), file.getName() + ".md5").getAbsolutePath(), (String)md5.toLowerCase());
            FileUtils.fileWrite((String)new File(file.getParentFile(), file.getName() + ".sha1").getAbsolutePath(), (String)sha1.toLowerCase());
        }
        catch (NoSuchAlgorithmException e) {
            throw new RepositoryAssemblyException("Unable to get write checksums: " + e.getMessage(), e);
        }
    }

    protected Map createGroupVersionAlignments(List versionAlignments) {
        HashMap<String, GroupVersionAlignment> groupVersionAlignments = new HashMap<String, GroupVersionAlignment>();
        if (versionAlignments != null) {
            Iterator i = versionAlignments.iterator();
            while (i.hasNext()) {
                GroupVersionAlignment alignment = (GroupVersionAlignment)i.next();
                groupVersionAlignments.put(alignment.getId(), alignment);
            }
        }
        return groupVersionAlignments;
    }

    protected static DateFormat getUtcDateFormatter() {
        SimpleDateFormat utcDateFormatter = new SimpleDateFormat(UTC_TIMESTAMP_PATTERN);
        utcDateFormatter.setTimeZone(UTC_TIME_ZONE);
        return utcDateFormatter;
    }

    protected ArtifactRepository createLocalRepository(File directory) {
        String localRepositoryUrl = directory.getAbsolutePath();
        if (!localRepositoryUrl.startsWith("file:")) {
            localRepositoryUrl = "file://" + localRepositoryUrl;
        }
        return this.createRepository("local", localRepositoryUrl, false, true, "warn");
    }

    public ArtifactRepository createRepository(String repositoryId, String repositoryUrl, boolean offline, boolean updateSnapshots, String globalChecksumPolicy) {
        DefaultArtifactRepository localRepository = new DefaultArtifactRepository(repositoryId, repositoryUrl, this.repositoryLayout);
        boolean snapshotPolicySet = false;
        if (offline) {
            snapshotPolicySet = true;
        }
        if (!snapshotPolicySet && updateSnapshots) {
            this.artifactRepositoryFactory.setGlobalUpdatePolicy("always");
        }
        this.artifactRepositoryFactory.setGlobalChecksumPolicy(globalChecksumPolicy);
        return localRepository;
    }

    private void invalidateProccessedProjectCache() throws Exception {
        Class klass = class$org$apache$maven$project$DefaultMavenProjectBuilder == null ? (class$org$apache$maven$project$DefaultMavenProjectBuilder = DefaultRepositoryAssembler.class$("org.apache.maven.project.DefaultMavenProjectBuilder")) : class$org$apache$maven$project$DefaultMavenProjectBuilder;
        try {
            Field field = klass.getDeclaredField("processedProjectCache");
            ((AccessibleObject)field).setAccessible(true);
            Object cache = field.get(this.projectBuilder);
            cache.getClass().getDeclaredMethod("clear", null).invoke(cache, null);
            ((AccessibleObject)field).setAccessible(false);
        }
        catch (NoSuchFieldException noSuchFieldException) {
            // empty catch block
        }
    }

    private void setAlignment(Artifact artifact, Map groupVersionAlignments) {
        GroupVersionAlignment alignment = (GroupVersionAlignment)groupVersionAlignments.get(artifact.getGroupId());
        if (alignment != null && !alignment.getExcludes().contains(artifact.getArtifactId())) {
            artifact.setVersion(alignment.getVersion());
        }
    }

    private Map getManagedVersionMap(MavenProject project) throws InvalidVersionSpecificationException {
        List deps;
        DependencyManagement dependencyManagement = project.getModel().getDependencyManagement();
        HashMap<String, Artifact> map = null;
        if (dependencyManagement != null && (deps = dependencyManagement.getDependencies()) != null && deps.size() > 0) {
            map = new HashMap<String, Artifact>();
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug("Adding managed dependencies for " + project.getId());
            }
            Iterator i = dependencyManagement.getDependencies().iterator();
            while (i.hasNext()) {
                Dependency d = (Dependency)i.next();
                VersionRange versionRange = VersionRange.createFromVersionSpec((String)d.getVersion());
                Artifact artifact = this.artifactFactory.createDependencyArtifact(d.getGroupId(), d.getArtifactId(), versionRange, d.getType(), d.getClassifier(), d.getScope(), d.isOptional());
                if (this.getLogger().isDebugEnabled()) {
                    this.getLogger().debug("  " + artifact);
                }
                if (null != d.getExclusions() && !d.getExclusions().isEmpty()) {
                    ArrayList<String> exclusions = new ArrayList<String>();
                    Iterator exclItr = d.getExclusions().iterator();
                    while (exclItr.hasNext()) {
                        Exclusion e = (Exclusion)exclItr.next();
                        exclusions.add(e.getGroupId() + ":" + e.getArtifactId());
                    }
                    ExcludesArtifactFilter eaf = new ExcludesArtifactFilter(exclusions);
                    artifact.setDependencyFilter((ArtifactFilter)eaf);
                } else {
                    artifact.setDependencyFilter(null);
                }
                map.put(d.getManagementKey(), artifact);
            }
        } else if (map == null) {
            map = Collections.EMPTY_MAP;
        }
        return map;
    }

    public void contextualize(Context context) throws ContextException {
        PlexusContainer container = (PlexusContainer)context.get((Object)"plexus");
        for (int i = 0; i < PREFERRED_RESOLVER_HINTS.length; ++i) {
            String hint = PREFERRED_RESOLVER_HINTS[i];
            try {
                this.artifactResolver = (ArtifactResolver)container.lookup(ArtifactResolver.ROLE, hint);
                break;
            }
            catch (ComponentLookupException e) {
                this.getLogger().debug("Cannot find ArtifactResolver with hint: " + hint, (Throwable)e);
                continue;
            }
        }
        if (this.artifactResolver == null) {
            try {
                this.artifactResolver = (ArtifactResolver)container.lookup(ArtifactResolver.ROLE);
            }
            catch (ComponentLookupException e) {
                this.getLogger().debug("Cannot find ArtifactResolver with no hint.", (Throwable)e);
            }
        }
        if (this.artifactResolver == null) {
            throw new ContextException("Failed to lookup a valid ArtifactResolver implementation. Tried hints:\n" + Arrays.asList(PREFERRED_RESOLVER_HINTS));
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

