/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.jxr;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import org.apache.maven.plugin.jxr.AbstractJxrReport;
import org.apache.maven.project.MavenProject;

public class JxrTestReport
extends AbstractJxrReport {
    private List sourceDirs;
    private String destDir;
    private File testJavadocDir;

    protected List getSourceRoots() {
        ArrayList l = new ArrayList();
        if (!"pom".equals(this.getProject().getPackaging().toLowerCase())) {
            l.addAll(this.sourceDirs);
        }
        if (this.getProject().getExecutionProject() != null && !"pom".equals(this.getProject().getExecutionProject().getPackaging().toLowerCase())) {
            l.addAll(this.getProject().getExecutionProject().getTestCompileSourceRoots());
        }
        return l;
    }

    protected List getSourceRoots(MavenProject project) {
        ArrayList l = new ArrayList();
        if (!"pom".equals(project.getPackaging().toLowerCase())) {
            l.addAll(project.getExecutionProject().getTestCompileSourceRoots());
        }
        if (project.getExecutionProject() != null && !"pom".equals(project.getExecutionProject().getPackaging().toLowerCase())) {
            l.addAll(project.getExecutionProject().getTestCompileSourceRoots());
        }
        return l;
    }

    protected String getDestinationDirectory() {
        return this.destDir;
    }

    public String getDescription(Locale locale) {
        return this.getBundle(locale).getString("report.xref.test.description");
    }

    public String getName(Locale locale) {
        return this.getBundle(locale).getString("report.xref.test.name");
    }

    public String getOutputName() {
        return "xref-test/index";
    }

    protected File getJavadocDir() {
        return this.testJavadocDir;
    }

    public void setReportOutputDirectory(File reportOutputDirectory) {
        this.destDir = reportOutputDirectory != null && !reportOutputDirectory.getAbsolutePath().endsWith("xref-test") ? new File(reportOutputDirectory, "xref-test").getAbsolutePath() : reportOutputDirectory.getAbsolutePath();
    }
}

