/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.dependency;

import java.io.File;
import java.net.MalformedURLException;
import java.util.Iterator;
import java.util.Set;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.installer.ArtifactInstallationException;
import org.apache.maven.artifact.installer.ArtifactInstaller;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.repository.ArtifactRepositoryFactory;
import org.apache.maven.artifact.repository.layout.ArtifactRepositoryLayout;
import org.apache.maven.artifact.repository.layout.DefaultRepositoryLayout;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.dependency.AbstractFromDependenciesMojo;
import org.apache.maven.plugin.dependency.utils.DependencyStatusSets;
import org.apache.maven.plugin.dependency.utils.DependencyUtil;
import org.apache.maven.plugin.dependency.utils.filters.DestFileFilter;
import org.apache.maven.shared.artifact.filter.collection.ArtifactsFilter;

public class CopyDependenciesMojo
extends AbstractFromDependenciesMojo {
    protected ArtifactInstaller installer;
    protected ArtifactRepositoryFactory repositoryFactory;

    public void execute() throws MojoExecutionException {
        Iterator i;
        DependencyStatusSets dss = this.getDependencySets(this.failOnMissingClassifierArtifact);
        Set artifacts = dss.getResolvedDependencies();
        if (!this.useRepositoryLayout) {
            i = artifacts.iterator();
            while (i.hasNext()) {
                this.copyArtifact((Artifact)i.next(), this.stripVersion);
            }
        } else {
            try {
                ArtifactRepository targetRepository = this.repositoryFactory.createDeploymentArtifactRepository("local", this.outputDirectory.toURL().toExternalForm(), (ArtifactRepositoryLayout)new DefaultRepositoryLayout(), false);
                Iterator i2 = artifacts.iterator();
                while (i2.hasNext()) {
                    this.installArtifact((Artifact)i2.next(), targetRepository);
                }
            }
            catch (MalformedURLException e) {
                throw new MojoExecutionException("Could not create outputDirectory repository", (Exception)e);
            }
        }
        artifacts = dss.getSkippedDependencies();
        i = artifacts.iterator();
        while (i.hasNext()) {
            Artifact artifact = (Artifact)i.next();
            this.getLog().info((CharSequence)(artifact.getFile().getName() + " already exists in destination."));
        }
    }

    private void installArtifact(Artifact artifact, ArtifactRepository targetRepository) {
        try {
            if ("pom".equals(artifact.getType())) {
                this.installer.install(artifact.getFile(), artifact, targetRepository);
                this.installBaseSnapshot(artifact, targetRepository);
            } else {
                Artifact pomArtifact;
                this.installer.install(artifact.getFile(), artifact, targetRepository);
                this.installBaseSnapshot(artifact, targetRepository);
                if (this.isCopyPom() && (pomArtifact = this.getResolvedPomArtifact(artifact)).getFile() != null && pomArtifact.getFile().exists()) {
                    this.installer.install(pomArtifact.getFile(), pomArtifact, targetRepository);
                    this.installBaseSnapshot(pomArtifact, targetRepository);
                }
            }
        }
        catch (ArtifactInstallationException e) {
            this.getLog().info((CharSequence)e.getMessage());
        }
    }

    private void installBaseSnapshot(Artifact artifact, ArtifactRepository targetRepository) throws ArtifactInstallationException {
        if (artifact.isSnapshot() && !artifact.getBaseVersion().equals(artifact.getVersion())) {
            Artifact baseArtifact = this.factory.createArtifact(artifact.getGroupId(), artifact.getArtifactId(), artifact.getBaseVersion(), artifact.getScope(), artifact.getType());
            this.installer.install(artifact.getFile(), baseArtifact, targetRepository);
        }
    }

    protected void copyArtifact(Artifact artifact, boolean removeVersion) throws MojoExecutionException {
        Artifact pomArtifact;
        String destFileName = DependencyUtil.getFormattedFileName(artifact, removeVersion);
        File destDir = DependencyUtil.getFormattedOutputDirectory(this.useSubDirectoryPerType, this.useSubDirectoryPerArtifact, this.useRepositoryLayout, this.stripVersion, this.outputDirectory, artifact);
        File destFile = new File(destDir, destFileName);
        this.copyFile(artifact.getFile(), destFile);
        if (this.isCopyPom() && (pomArtifact = this.getResolvedPomArtifact(artifact)).getFile() != null && pomArtifact.getFile().exists()) {
            File pomDestFile = new File(destDir, DependencyUtil.getFormattedFileName(pomArtifact, removeVersion));
            this.copyFile(pomArtifact.getFile(), pomDestFile);
        }
    }

    protected Artifact getResolvedPomArtifact(Artifact artifact) {
        Artifact pomArtifact = this.factory.createArtifact(artifact.getGroupId(), artifact.getArtifactId(), artifact.getVersion(), "", "pom");
        try {
            this.resolver.resolve(pomArtifact, this.remoteRepos, this.local);
        }
        catch (Exception e) {
            this.getLog().info((CharSequence)e.getMessage());
        }
        return pomArtifact;
    }

    protected ArtifactsFilter getMarkedArtifactFilter() {
        return new DestFileFilter(this.overWriteReleases, this.overWriteSnapshots, this.overWriteIfNewer, this.useSubDirectoryPerArtifact, this.useSubDirectoryPerType, this.useRepositoryLayout, this.stripVersion, this.outputDirectory);
    }
}

