/*
 * Decompiled with CFR 0.152.
 */
package ckjm.plugin;

import ckjm.plugin.FileFinder;
import ckjm.plugin.Filter;
import gr.spinellis.ckjm.CkjmOutputHandler;
import gr.spinellis.ckjm.MetricsFilter;
import gr.spinellis.ckjm.PrintPlainResults;
import gr.spinellis.ckjm.ant.PrintXmlResults;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.project.MavenProject;
import org.apache.maven.reporting.AbstractMavenReport;
import org.apache.maven.reporting.MavenReportException;
import org.codehaus.doxia.sink.Sink;
import org.codehaus.doxia.site.renderer.SiteRenderer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CkjmMojo
extends AbstractMavenReport {
    private MavenProject project;
    private String projectDirectory;
    private List classpathElements;
    private File classDirectory;
    private String reportFile;
    private String outputDirectory;
    private SiteRenderer siteRenderer;
    private String format = "xml";

    protected SiteRenderer getSiteRenderer() {
        return this.siteRenderer;
    }

    public String getDescription(Locale locale) {
        return this.getBundle(locale).getString("report.ckjm.description");
    }

    public String getName(Locale locale) {
        return this.getBundle(locale).getString("report.ckjm.name");
    }

    public String getOutputName() {
        return "ckjm-report";
    }

    public boolean isExternalReport() {
        return false;
    }

    private ResourceBundle getBundle(Locale locale) {
        return ResourceBundle.getBundle("ckjm-report", locale, ((Object)((Object)this)).getClass().getClassLoader());
    }

    public void setFormat(String format) {
        this.format = format;
    }

    protected void executeReport(Locale locale) throws MavenReportException {
        try {
            this.checkOutputdir();
        }
        catch (MojoExecutionException e) {
            throw new MavenReportException("Unable to find output directory", (Exception)((Object)e));
        }
        List<File> filesFound = new FileFinder().findFilesFrom(this.classDirectory.toString(), new Filter(), true);
        String[] files = this.getFilesAsArray(filesFound);
        try {
            FileOutputStream outputStream = new FileOutputStream(this.reportFile);
            if ("xml".equals(this.format)) {
                PrintXmlResults outputXml = new PrintXmlResults(new PrintStream(outputStream));
                outputXml.printHeader();
                MetricsFilter.runMetrics((String[])files, (CkjmOutputHandler)outputXml);
                outputXml.printFooter();
                Sink sink = this.getSink();
                sink.head();
                sink.title();
                sink.text("Ckjm report");
                sink.title_();
                sink.head_();
                sink.body();
                sink.section1();
                sink.sectionTitle1();
                sink.text("Ckjm report");
                sink.sectionTitle1_();
                sink.lineBreak();
                sink.lineBreak();
                sink.text("put something...");
                sink.lineBreak();
                sink.section1_();
                sink.body_();
                sink.flush();
                sink.close();
            } else {
                PrintPlainResults outputPlain = new PrintPlainResults(new PrintStream(outputStream));
                MetricsFilter.runMetrics((String[])files, (CkjmOutputHandler)outputPlain);
            }
            ((OutputStream)outputStream).close();
        }
        catch (IOException ioe) {
            throw new MavenReportException("Error file handling: ", (Exception)ioe);
        }
    }

    private void checkOutputdir() throws MojoExecutionException {
        boolean success;
        File outputDirFile = new File(this.outputDirectory);
        if (!outputDirFile.exists() && !(success = outputDirFile.mkdirs())) {
            throw new MojoExecutionException("Could not create directory " + this.outputDirectory);
        }
    }

    public String[] getFilesAsArray(List<File> filesAsList) {
        String[] filesAsArray = new String[filesAsList.size()];
        for (int i = 0; i < filesAsList.size(); ++i) {
            filesAsArray[i] = filesAsList.get(i).getPath();
        }
        return filesAsArray;
    }

    public MavenProject getProject() {
        return this.project;
    }

    public void setProject(MavenProject project) {
        this.project = project;
    }

    public String getOutputDirectory() {
        return this.outputDirectory;
    }

    public void setOutputDirectory(String outputDirectory) {
        this.outputDirectory = outputDirectory;
    }

    public String getReportFile() {
        return this.reportFile;
    }

    public void setReportFile(String reportFile) {
        this.reportFile = reportFile;
    }

    public String getProjectDirectory() {
        return this.projectDirectory;
    }

    public void setProjectDirectory(String projectDirectory) {
        this.projectDirectory = projectDirectory;
    }

    public File getClassDirectory() {
        return this.classDirectory;
    }

    public void setClassDirectory(File classDirectory) {
        this.classDirectory = classDirectory;
    }

    public List getClasspathElements() {
        return this.classpathElements;
    }
}

