/*
 * Decompiled with CFR 0.152.
 */
package org.displaytag.sample.decorators;

import com.lowagie.text.BadElementException;
import com.lowagie.text.Cell;
import com.lowagie.text.Chunk;
import com.lowagie.text.Element;
import com.lowagie.text.Font;
import com.lowagie.text.FontFactory;
import com.lowagie.text.Table;
import java.awt.Color;
import org.displaytag.render.ItextTableWriter;
import org.displaytag.sample.decorators.TotalWrapperTemplate;

public class ItextTotalWrapper
extends TotalWrapperTemplate
implements ItextTableWriter.ItextDecorator {
    private Table table;
    private Font font;

    public void setTable(Table table) {
        this.table = table;
    }

    public void setFont(Font font) {
        this.font = font;
    }

    public String startRow() {
        this.table.setDefaultCellBorder(2);
        return null;
    }

    protected void writeCityTotal(String city, double total) {
        this.writeTotal(city, total);
    }

    protected void writeGrandTotal(double total) {
        this.writeTotal("Grand", total);
    }

    private void writeTotal(String value, double total) {
        if (this.assertRequiredState()) {
            try {
                this.font = FontFactory.getFont((String)this.font.getFamilyname(), (float)this.font.size(), (int)1, (Color)this.font.color());
                this.table.addCell(this.getCell(""));
                this.table.addCell(this.getCell(""));
                this.table.addCell(this.getCell("-------------"));
                this.table.addCell(this.getCell(""));
                this.table.addCell(this.getCell(""));
                this.table.addCell(this.getCell(value + " Total:"));
                this.table.addCell(this.getCell(total + ""));
                this.table.addCell(this.getCell(""));
            }
            catch (BadElementException e) {
                // empty catch block
            }
        }
    }

    private Cell getCell(String value) throws BadElementException {
        Cell cell = new Cell((Element)new Chunk(value, this.font));
        cell.setLeading(8.0f);
        cell.setHorizontalAlignment(0);
        return cell;
    }

    private boolean assertRequiredState() {
        return this.table != null && this.font != null;
    }
}

