/*
 * Decompiled with CFR 0.152.
 */
package net.java.nativelibsupport;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.ref.WeakReference;
import java.util.List;
import java.util.Properties;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import net.java.nativelibsupport.LibDeploymentException;
import net.java.nativelibsupport.natives_config.Library;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.JarFileSystem;

public class NativeLibSupport {
    private static WeakReference<JAXBContext> reference;

    private NativeLibSupport() {
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void deploy(String libraryName, InputStream configFile, File distributionFolder) throws LibDeploymentException {
        assert (libraryName != null);
        assert (configFile != null);
        assert (distributionFolder != null);
        try {
            JarFileSystem jarSystem = new JarFileSystem();
            jarSystem.setJarFile(new File(distributionFolder + File.separator + libraryName + ".jar"));
            String jarVersion = jarSystem.getManifest().getMainAttributes().getValue("Implementation-Version");
            if (jarVersion == null) {
                throw new NullPointerException(jarSystem.getJarFile() + " has no 'Implementation-Version' property in manifest file");
            }
            String root = distributionFolder.getCanonicalPath();
            root = root.substring(0, root.lastIndexOf(File.separator));
            String libFolderPath = root + File.separator + "modules" + File.separator + "lib";
            File propertyFile = new File(libFolderPath + File.separator + "deployed-natives.properties");
            Properties properties = new Properties();
            if (propertyFile.exists()) {
                properties.load(new FileInputStream(propertyFile));
            } else {
                propertyFile.getParentFile().mkdirs();
                propertyFile.createNewFile();
            }
            String deployedLibVersion = properties.getProperty(libraryName + ".jar", null);
            if (deployedLibVersion != null && jarVersion.equals(deployedLibVersion)) {
                Logger.getLogger(NativeLibSupport.class.getName()).info(libraryName + " version " + jarVersion + " is up to date");
                return;
            }
            Object obj = null;
            try {
                JAXBContext jc = NativeLibSupport.getJAXBContext();
                Unmarshaller unmarshaller = jc.createUnmarshaller();
                obj = unmarshaller.unmarshal(configFile);
            }
            catch (JAXBException ex) {
                throw new RuntimeException("error reading deployment file", ex);
            }
            if (!(obj instanceof Library)) {
                throw new IllegalArgumentException("wrong root element in config file. 'Library' expected but got " + obj);
            }
            Library lib = (Library)obj;
            StringBuilder nativesFolderPath = new StringBuilder();
            nativesFolderPath.append(distributionFolder.getName());
            nativesFolderPath.append(File.separatorChar);
            nativesFolderPath.append(lib.getName());
            if (!lib.isFlat()) {
                nativesFolderPath.append(File.separatorChar);
            }
            String osName = System.getProperty("os.name");
            String cpuName = System.getProperty("os.arch");
            NativeLibSupport.assambleLibPath(lib, osName, cpuName, nativesFolderPath);
            FileObject libSourceFolder = FileUtil.toFileObject((File)new File(root + File.separator + nativesFolderPath.toString()));
            if (libSourceFolder != null) {
                FileObject libTargetFolder = FileUtil.createFolder((File)new File(libFolderPath));
                NativeLibSupport.copyFolderEntries(libSourceFolder, libTargetFolder);
                properties.put(lib.getName(), jarVersion);
                properties.store(new FileOutputStream(propertyFile), "deployed native libraries (remove entry and restart to force re-deployment)");
                Logger.getLogger(NativeLibSupport.class.getName()).info("deployed " + lib.getName() + " version: " + jarVersion);
                return;
            }
            String os = System.getProperty("os.name");
            String arch = System.getProperty("os.arch");
            throw new LibDeploymentException(String.format("The %1$s native libraries are either not available for this system (OS: %2$s CPU: %3$s) or an error accrued while deploying", lib.getName(), os, arch));
        }
        catch (Exception ex) {
            throw new LibDeploymentException("can not deploy " + libraryName + " natives", ex);
        }
    }

    private static final void copyFolderEntries(FileObject srcFolder, FileObject targetFolder) throws IOException {
        FileObject[] entries = srcFolder.getChildren();
        for (int i = 0; i < entries.length; ++i) {
            FileObject entry = entries[i];
            FileObject old = targetFolder.getFileObject(entry.getNameExt());
            if (old != null) {
                Logger.getLogger(NativeLibSupport.class.getName()).info("remove old file: " + old.getPath());
                old.delete();
            }
            Logger.getLogger(NativeLibSupport.class.getName()).info("copy " + entry.getPath() + " to " + targetFolder.getPath());
            FileUtil.copyFile((FileObject)entry, (FileObject)targetFolder, (String)entry.getName());
        }
    }

    private static final void assambleLibPath(Library lib, String osName, String cpuName, StringBuilder nativesFolderPath) {
        List<Library.Os> oses = lib.getOs();
        block0: for (Library.Os os : oses) {
            Matcher osMatcher = Pattern.compile(os.getRegex()).matcher(osName);
            if (!osMatcher.find()) continue;
            nativesFolderPath.append(os.getFolder());
            if (!lib.isFlat()) {
                nativesFolderPath.append(File.separatorChar);
            }
            List<Library.Os.Cpu> cpus = os.getCpu();
            for (Library.Os.Cpu cpu : cpus) {
                Matcher cpuMatcher = Pattern.compile(cpu.getRegex()).matcher(cpuName);
                if (!cpuMatcher.find()) continue;
                nativesFolderPath.append(cpu.getFolder());
                break block0;
            }
        }
    }

    private static final synchronized JAXBContext getJAXBContext() throws JAXBException {
        JAXBContext jc;
        if (reference == null) {
            jc = NativeLibSupport.createJAXBContext();
            reference = new WeakReference<JAXBContext>(jc);
        } else {
            jc = (JAXBContext)reference.get();
            if (jc == null) {
                jc = NativeLibSupport.createJAXBContext();
                reference = new WeakReference<JAXBContext>(jc);
            }
        }
        System.out.println(jc);
        return jc;
    }

    private static final JAXBContext createJAXBContext() throws JAXBException {
        return JAXBContext.newInstance((String)"net.java.nativelibsupport.natives_config", (ClassLoader)NativeLibSupport.class.getClassLoader());
    }
}

