/*
 * Decompiled with CFR 0.152.
 */
package net.java.nboglpack.jogl.util;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum JOGLDistribution {
    WINDOWS_AMD64("windows", "amd64"),
    WINDOWS_I586("windows", "i586"),
    LINUX_I586("linux", "i586"),
    LINUX_AMD64("linux", "amd64"),
    MACOSX_UNIVERSAL("macosx", "universal"),
    MACOSX_PPC("macosx", "ppc"),
    SOLARIS_AMD64("solaris", "amd64"),
    SOLARIS_I586("solaris", "i586"),
    SOLARIS_SPARC("solaris", "sparc"),
    SOLARIS_SPARC_V9("solaris", "sparcv9");

    public final String os;
    public final String arch;

    private JOGLDistribution(String os, String arch) {
        this.os = os;
        this.arch = arch;
    }

    public String toString() {
        String osName = this.os.equals(JOGLDistribution.MACOSX_UNIVERSAL.os) ? "MacOS X" : this.os.substring(0, 1).toUpperCase() + this.os.substring(1);
        return osName + " (" + this.arch + ")";
    }

    public String key() {
        return this.os + "-" + this.arch;
    }

    public static JOGLDistribution parseKey(String key) {
        JOGLDistribution[] values = JOGLDistribution.values();
        for (int i = 0; i < values.length; ++i) {
            JOGLDistribution value = values[i];
            if (!value.key().equals(key)) continue;
            return value;
        }
        return null;
    }

    public static JOGLDistribution getCompatible() {
        String os = System.getProperty("os.name").toLowerCase();
        String arch = System.getProperty("os.arch").toLowerCase();
        if (os == null || arch == null) {
            return null;
        }
        if (os.contains("mac")) {
            if (arch.contains("ppc")) {
                return MACOSX_PPC;
            }
            return MACOSX_UNIVERSAL;
        }
        if (os.contains("windows")) {
            if (JOGLDistribution.isAMD64bit(arch)) {
                return WINDOWS_AMD64;
            }
            return WINDOWS_I586;
        }
        if (os.contains("linux")) {
            if (JOGLDistribution.isAMD64bit(arch)) {
                return LINUX_AMD64;
            }
            return LINUX_I586;
        }
        if (os.contains("solaris") || os.contains("sunos")) {
            if (JOGLDistribution.isAMD64bit(arch)) {
                return SOLARIS_AMD64;
            }
            if (arch.equals("sparcv9")) {
                return SOLARIS_SPARC_V9;
            }
            if (arch.endsWith("sparc")) {
                return SOLARIS_SPARC;
            }
            return SOLARIS_I586;
        }
        return null;
    }

    private static final boolean isAMD64bit(String arch) {
        return arch.contains("amd64") || arch.endsWith("_64");
    }
}

