/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.dependency;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.DependencyManagement;
import org.apache.maven.model.Exclusion;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.util.StringUtils;

public class AnalyzeDepMgt
extends AbstractMojo {
    private MavenProject project;
    private boolean failBuild = false;
    private boolean ignoreDirect = true;

    public void execute() throws MojoExecutionException, MojoFailureException {
        boolean result = this.checkDependencyManagement();
        if (result) {
            if (this.failBuild) {
                throw new MojoExecutionException("Found Dependency errors.");
            }
            this.getLog().warn((CharSequence)"Potential problems found in Dependency Management ");
        }
    }

    private boolean checkDependencyManagement() throws MojoExecutionException {
        boolean foundError = false;
        this.getLog().info((CharSequence)"Found Resolved Dependency / DependencyManagement mismatches:");
        List depMgtDependencies = null;
        DependencyManagement depMgt = this.project.getDependencyManagement();
        if (depMgt != null) {
            depMgtDependencies = depMgt.getDependencies();
        }
        if (depMgtDependencies != null && !depMgtDependencies.isEmpty()) {
            HashMap<String, Dependency> depMgtMap = new HashMap<String, Dependency>();
            HashMap exclusions = new HashMap();
            Iterator iter = depMgtDependencies.iterator();
            while (iter.hasNext()) {
                Dependency depMgtDependency = (Dependency)iter.next();
                depMgtMap.put(depMgtDependency.getManagementKey(), depMgtDependency);
                exclusions.putAll(this.addExclusions(depMgtDependency.getExclusions()));
            }
            HashSet allDependencyArtifacts = new HashSet(this.project.getArtifacts());
            if (this.ignoreDirect) {
                this.getLog().info((CharSequence)"\tIgnoring Direct Dependencies.");
                Set directDependencies = this.project.getDependencyArtifacts();
                allDependencyArtifacts.removeAll(directDependencies);
            }
            List exclusionErrors = this.getExclusionErrors(exclusions, allDependencyArtifacts);
            Iterator exclusionIter = exclusionErrors.iterator();
            while (exclusionIter.hasNext()) {
                Artifact exclusion = (Artifact)exclusionIter.next();
                this.getLog().info((CharSequence)(StringUtils.stripEnd((String)this.getArtifactManagementKey(exclusion), (String)":") + " was excluded in DepMgt, but version " + exclusion.getVersion() + " has been found in the dependency tree."));
                foundError = true;
            }
            Map mismatch = this.getMismatch(depMgtMap, allDependencyArtifacts);
            Iterator mismatchIter = mismatch.keySet().iterator();
            while (mismatchIter.hasNext()) {
                Artifact resolvedArtifact = (Artifact)mismatchIter.next();
                Dependency depMgtDependency = (Dependency)mismatch.get(resolvedArtifact);
                this.logMismatch(resolvedArtifact, depMgtDependency);
            }
            if (!foundError) {
                this.getLog().info((CharSequence)"   None");
            }
        } else {
            this.getLog().info((CharSequence)"   Nothing in DepMgt.");
        }
        return foundError;
    }

    public Map addExclusions(List exclusionList) {
        HashMap<String, Exclusion> exclusions = new HashMap<String, Exclusion>();
        if (exclusionList != null) {
            Iterator exclusionIter = exclusionList.iterator();
            while (exclusionIter.hasNext()) {
                Exclusion exclusion = (Exclusion)exclusionIter.next();
                exclusions.put(this.getExclusionKey(exclusion), exclusion);
            }
        }
        return exclusions;
    }

    public List getExclusionErrors(Map exclusions, Set allDependencyArtifacts) {
        ArrayList<Artifact> list = new ArrayList<Artifact>();
        Iterator iter = allDependencyArtifacts.iterator();
        while (iter.hasNext()) {
            Artifact artifact = (Artifact)iter.next();
            if (!exclusions.containsKey(this.getExclusionKey(artifact))) continue;
            list.add(artifact);
        }
        return list;
    }

    public String getExclusionKey(Artifact artifact) {
        return artifact.getGroupId() + ":" + artifact.getArtifactId();
    }

    public String getExclusionKey(Exclusion ex) {
        return ex.getGroupId() + ":" + ex.getArtifactId();
    }

    public Map getMismatch(Map depMgtMap, Set allDependencyArtifacts) {
        HashMap<Artifact, Dependency> mismatchMap = new HashMap<Artifact, Dependency>();
        Iterator iter = allDependencyArtifacts.iterator();
        while (iter.hasNext()) {
            Artifact dependencyArtifact = (Artifact)iter.next();
            Dependency depFromDepMgt = (Dependency)depMgtMap.get(this.getArtifactManagementKey(dependencyArtifact));
            if (depFromDepMgt == null) continue;
            dependencyArtifact.isSnapshot();
            if (depFromDepMgt.getVersion().equals(dependencyArtifact.getBaseVersion())) continue;
            mismatchMap.put(dependencyArtifact, depFromDepMgt);
        }
        return mismatchMap;
    }

    public void logMismatch(Artifact dependencyArtifact, Dependency dependencyFromDepMgt) throws MojoExecutionException {
        if (dependencyArtifact == null || dependencyFromDepMgt == null) {
            throw new MojoExecutionException("Invalid params: Artifact:" + dependencyArtifact + " Dependency:" + dependencyFromDepMgt);
        }
        this.getLog().info((CharSequence)("\tDependency: " + StringUtils.stripEnd((String)dependencyFromDepMgt.getManagementKey(), (String)":")));
        this.getLog().info((CharSequence)("\t\tDepMgt  : " + dependencyFromDepMgt.getVersion()));
        this.getLog().info((CharSequence)("\t\tResolved: " + dependencyArtifact.getBaseVersion()));
    }

    public String getArtifactManagementKey(Artifact artifact) {
        return artifact.getGroupId() + ":" + artifact.getArtifactId() + ":" + artifact.getType() + (artifact.getClassifier() != null ? ":" + artifact.getClassifier() : "");
    }

    public boolean isFailBuild() {
        return this.failBuild;
    }

    public void setFailBuild(boolean theFailBuild) {
        this.failBuild = theFailBuild;
    }

    public MavenProject getProject() {
        return this.project;
    }

    public void setProject(MavenProject theProject) {
        this.project = theProject;
    }

    public boolean isIgnoreDirect() {
        return this.ignoreDirect;
    }

    public void setIgnoreDirect(boolean theIgnoreDirect) {
        this.ignoreDirect = theIgnoreDirect;
    }
}

