/*
 * Decompiled with CFR 0.152.
 */
package foxtrot.examples;

import foxtrot.Job;
import foxtrot.Worker;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;

public class ProgressExample
extends JFrame {
    private JButton button = new JButton("Run Task !");
    private JProgressBar bar;
    private boolean running;
    private boolean taskInterrupted;

    public static void main(String[] args) {
        ProgressExample example = new ProgressExample();
        example.setVisible(true);
    }

    public ProgressExample() {
        super("Foxtrot Example");
        this.button.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (ProgressExample.this.running) {
                    ProgressExample.this.onCancelClicked();
                } else {
                    ProgressExample.this.onRunClicked();
                }
            }
        });
        this.bar = new JProgressBar();
        this.bar.setStringPainted(true);
        this.setDefaultCloseOperation(2);
        Container c = this.getContentPane();
        c.setLayout(new BorderLayout(0, 0));
        JPanel main = new JPanel(new BorderLayout(0, 0));
        main.setBorder(new EmptyBorder(35, 35, 35, 35));
        c.add((Component)main, "Center");
        JPanel p = new JPanel(new BorderLayout(20, 20));
        p.add((Component)this.bar, "North");
        p.add((Component)this.button, "South");
        main.add(p);
        this.setSize(300, 200);
        Dimension screen = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension size = this.getSize();
        int x = screen.width - size.width >> 1;
        int y = screen.height - size.height >> 1;
        this.setLocation(x, y);
    }

    private void onRunClicked() {
        this.running = true;
        this.setTaskInterrupted(false);
        this.button.setText("Cancel");
        ArrayList list = this.getData();
        this.button.setText("Run Task !");
        this.running = false;
        if (list != null) {
            DefaultComboBoxModel<Object> defaultComboBoxModel = new DefaultComboBoxModel<Object>(list.toArray());
        }
    }

    private void onCancelClicked() {
        this.setTaskInterrupted(true);
    }

    private ArrayList getData() {
        return (ArrayList)Worker.post((Job)new Job(){

            public Object run() {
                ArrayList<Object> list = new ArrayList<Object>();
                StringBuffer buffer = new StringBuffer();
                int max = 20;
                for (int i = 1; i <= max; ++i) {
                    try {
                        Thread.sleep(250L);
                    }
                    catch (InterruptedException ignored) {
                        // empty catch block
                    }
                    Object data = new Object();
                    list.add(data);
                    buffer.setLength(0);
                    buffer.append("Step ").append(i).append(" of ").append(max);
                    if (ProgressExample.this.isTaskInterrupted()) {
                        buffer.append(" - Interrupted !");
                        ProgressExample.this.update(i, max, buffer.toString());
                        break;
                    }
                    ProgressExample.this.update(i, max, buffer.toString());
                }
                if (ProgressExample.this.isTaskInterrupted()) {
                    list.clear();
                    return null;
                }
                return list;
            }
        });
    }

    private void update(final int index, final int max, final String string) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                ProgressExample.this.bar.setMaximum(max);
                ProgressExample.this.bar.setValue(index);
                ProgressExample.this.bar.setString(string);
            }
        });
    }

    private synchronized boolean isTaskInterrupted() {
        return this.taskInterrupted;
    }

    private synchronized void setTaskInterrupted(boolean value) {
        this.taskInterrupted = value;
    }
}

