/*
 * Decompiled with CFR 0.152.
 */
package foxtrot.examples;

import foxtrot.ConcurrentWorker;
import foxtrot.Job;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagLayout;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.SwingUtilities;

public class ConcurrentWorkerExample
extends JFrame {
    private JButton button;

    public static void main(String[] args) {
        ConcurrentWorkerExample example = new ConcurrentWorkerExample();
        example.setVisible(true);
    }

    public ConcurrentWorkerExample() {
        super("ConcurrentWorker Foxtrot Example");
        this.init();
    }

    private void init() {
        this.button = new JButton("Start long task");
        this.button.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ConcurrentWorkerExample.this.startLongTask();
            }
        });
        Container content = this.getContentPane();
        content.setLayout(new GridBagLayout());
        content.add(this.button);
        this.setDefaultCloseOperation(2);
        this.setSize(300, 200);
        Dimension screen = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension size = this.getSize();
        int x = screen.width - size.width >> 1;
        int y = screen.height - size.height >> 1;
        this.setLocation(x, y);
    }

    private void startLongTask() {
        final CancelDialog dialog = new CancelDialog();
        System.out.println("Posting task...");
        ConcurrentWorker.post((Job)new Job(){

            public Object run() {
                Thread workerThread = Thread.currentThread();
                ConcurrentWorkerExample.this.showDialogInEventThread(dialog, workerThread);
                try {
                    Thread.sleep(5000L);
                    System.out.println("Task ended");
                }
                catch (InterruptedException x) {
                    System.out.println("Task interrupted");
                }
                ConcurrentWorkerExample.this.hideDialogInEventThread(dialog);
                return null;
            }
        });
        System.out.println("Task finished");
    }

    private void showDialogInEventThread(final CancelDialog dialog, final Thread workerThread) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                System.out.println("Showing the dialog");
                dialog.display(workerThread);
            }
        });
    }

    private void hideDialogInEventThread(final CancelDialog dialog) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                System.out.println("Hiding the dialog");
                dialog.undisplay();
            }
        });
    }

    private void cancelLongTask(CancelDialog dialog, final Thread workerThread) {
        dialog.cancelling();
        ConcurrentWorker.post((Job)new Job(){

            public Object run() {
                ConcurrentWorkerExample.this.sleep(1000L);
                if (workerThread != null) {
                    workerThread.interrupt();
                }
                return null;
            }
        });
    }

    private void sleep(long millis) {
        try {
            Thread.sleep(millis);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }

    private class CancelDialog
    extends JDialog {
        private JButton button;
        private volatile Thread workerThread;

        public CancelDialog() {
            super(ConcurrentWorkerExample.this, "Cancel Task ?", true);
            this.init();
        }

        private void init() {
            this.button = new JButton("Cancel");
            this.button.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    ConcurrentWorkerExample.this.cancelLongTask(CancelDialog.this, CancelDialog.this.workerThread);
                }
            });
            Container content = this.getContentPane();
            content.setLayout(new GridBagLayout());
            content.add(this.button);
            this.setSize(200, 150);
            this.setLocationRelativeTo(ConcurrentWorkerExample.this);
            this.setDefaultCloseOperation(0);
        }

        private void cancelling() {
            this.button.setEnabled(false);
            this.button.setText("Cancelling...");
        }

        public void display(Thread workerThread) {
            this.workerThread = workerThread;
            this.setVisible(true);
        }

        public void undisplay() {
            this.workerThread = null;
            if (this.isVisible()) {
                this.dispose();
            }
        }
    }
}

