/*
 * Decompiled with CFR 0.152.
 */
package foxtrot.examples;

import foxtrot.AsyncTask;
import foxtrot.AsyncWorker;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class AsyncExample
extends JFrame {
    private JLabel tasksSending;
    private JLabel tasksSent;
    private JButton button;
    private boolean sent;

    public static void main(String[] args) {
        AsyncExample example = new AsyncExample();
        example.setVisible(true);
    }

    public AsyncExample() {
        super("Async Foxtrot Example");
        this.init();
    }

    private void init() {
        this.tasksSending = new JLabel();
        this.tasksSent = new JLabel();
        this.setDefaultCloseOperation(2);
        JPanel panel = new JPanel(new GridLayout(2, 0));
        panel.add(this.tasksSending);
        panel.add(this.tasksSent);
        Container c = this.getContentPane();
        c.setLayout(new BorderLayout());
        c.add((Component)panel, "North");
        this.button = new JButton();
        c.add((Component)this.button, "South");
        this.button.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (AsyncExample.this.sent) {
                    AsyncExample.this.reset();
                } else {
                    AsyncExample.this.send();
                }
            }
        });
        this.reset();
        this.setSize(300, 200);
        Dimension screen = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension size = this.getSize();
        int x = screen.width - size.width >> 1;
        int y = screen.height - size.height >> 1;
        this.setLocation(x, y);
    }

    public void send() {
        this.tasksSending.setText("Task submitted, waiting for result...");
        this.button.setText("Sending...");
        AsyncWorker.post((AsyncTask)new AsyncTask(){

            public Object run() throws Exception {
                Thread.sleep(2000L);
                return System.getProperty("user.dir");
            }

            public void success(Object result) {
                String data = (String)result;
                AsyncExample.this.tasksSent.setText("Result: " + data);
                AsyncExample.this.button.setText("Reset");
                AsyncExample.this.sent = true;
            }

            public void failure(Throwable x) {
                x.printStackTrace();
            }
        });
    }

    public void reset() {
        this.sent = false;
        this.tasksSending.setText("No tasks submitted");
        this.tasksSent.setText("Result:");
        this.button.setText("Click Me !");
    }
}

