/*
 * Decompiled with CFR 0.152.
 */
package org.dstovall;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.jar.JarInputStream;
import java.util.jar.JarOutputStream;
import java.util.jar.Manifest;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipInputStream;
import org.apache.commons.io.IOUtils;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.FileSet;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.MavenProjectHelper;
import org.codehaus.plexus.util.FileUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OneJarMojo
extends AbstractMojo {
    private Collection<Artifact> artifacts;
    private Collection<Dependency> dependencies;
    private FileSet[] binlibs;
    private File outputDirectory;
    private String mainJarFilename;
    private String implementationVersion;
    private String filename;
    private String onejarVersion;
    private boolean attachToBuild;
    private String classifier;
    private MavenProject project;
    private MavenProjectHelper projectHelper;
    private String mainClass;
    private final AtomicInteger alternativeEntryCounter = new AtomicInteger(0);

    public void execute() throws MojoExecutionException {
        File onejarFile;
        this.displayPluginInfo();
        JarOutputStream out = null;
        JarInputStream template = null;
        try {
            ZipEntry entry;
            onejarFile = new File(this.outputDirectory, this.filename);
            out = new JarOutputStream((OutputStream)new FileOutputStream(onejarFile, false), this.getManifest());
            if (this.getLog().isDebugEnabled()) {
                this.getLog().debug((CharSequence)("Adding main jar main/[" + this.mainJarFilename + "]"));
            }
            this.addToZip(new File(this.outputDirectory, this.mainJarFilename), "main/", out);
            List<File> dependencyJars = this.extractDependencyFiles(this.artifacts);
            if (this.getLog().isDebugEnabled()) {
                this.getLog().debug((CharSequence)("Adding [" + dependencyJars.size() + "] dependency libraries..."));
            }
            for (File jar : dependencyJars) {
                this.addToZip(jar, "lib/", out);
            }
            List<File> systemDependencyJars = this.extractSystemDependencyFiles(this.dependencies);
            if (this.getLog().isDebugEnabled()) {
                this.getLog().debug((CharSequence)("Adding [" + systemDependencyJars.size() + "] system dependency libraries..."));
            }
            for (File jar : systemDependencyJars) {
                this.addToZip(jar, "lib/", out);
            }
            if (this.binlibs != null) {
                for (FileSet eachFileSet : this.binlibs) {
                    List<File> includedFiles = OneJarMojo.toFileList(eachFileSet);
                    if (this.getLog().isDebugEnabled()) {
                        this.getLog().debug((CharSequence)("Adding [" + includedFiles.size() + "] native libraries..."));
                    }
                    for (File eachIncludedFile : includedFiles) {
                        this.addToZip(eachIncludedFile, "binlib/", out);
                    }
                }
            }
            this.getLog().debug((CharSequence)"Adding one-jar components...");
            template = this.openOnejarTemplateArchive();
            while ((entry = template.getNextEntry()) != null) {
                if ("boot-manifest.mf".equals(entry.getName())) continue;
                this.addToZip(out, entry, template);
            }
        }
        catch (IOException e) {
            try {
                this.getLog().error((Throwable)e);
                throw new MojoExecutionException("One-jar Mojo failed.", (Exception)e);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(out);
                IOUtils.closeQuietly(template);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((OutputStream)out);
        IOUtils.closeQuietly((InputStream)template);
        if (this.attachToBuild) {
            this.projectHelper.attachArtifact(this.project, "jar", this.classifier, onejarFile);
        }
    }

    private void displayPluginInfo() {
        this.getLog().info((CharSequence)"Using One-Jar to create a single-file distribution");
        this.getLog().info((CharSequence)("Implementation Version: " + this.implementationVersion));
        this.getLog().info((CharSequence)("Using One-Jar version: " + this.onejarVersion));
        this.getLog().info((CharSequence)"More info on One-Jar: http://one-jar.sourceforge.net/");
        this.getLog().info((CharSequence)"License for One-Jar:  http://one-jar.sourceforge.net/one-jar-license.txt");
        this.getLog().info((CharSequence)("One-Jar file: " + this.outputDirectory.getAbsolutePath() + File.separator + this.filename));
    }

    private String getOnejarArchiveName() {
        return "one-jar-boot-" + this.onejarVersion + ".jar";
    }

    private JarInputStream openOnejarTemplateArchive() throws IOException {
        return new JarInputStream(((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream(this.getOnejarArchiveName()));
    }

    private Manifest getManifest() throws IOException {
        JarInputStream zipIS = this.openOnejarTemplateArchive();
        Manifest manifest = new Manifest(this.getFileBytes(zipIS, "boot-manifest.mf"));
        IOUtils.closeQuietly((InputStream)zipIS);
        if (this.mainClass != null) {
            manifest.getMainAttributes().putValue("One-Jar-Main-Class", this.mainClass);
        }
        if (this.implementationVersion != null) {
            manifest.getMainAttributes().putValue("ImplementationVersion", this.implementationVersion);
        }
        return manifest;
    }

    private void addToZip(File sourceFile, String zipfilePath, JarOutputStream out) throws IOException {
        this.addToZip(out, new ZipEntry(zipfilePath + sourceFile.getName()), new FileInputStream(sourceFile));
    }

    private void addToZip(JarOutputStream out, ZipEntry entry, InputStream in) throws IOException {
        try {
            out.putNextEntry(entry);
            IOUtils.copy((InputStream)in, (OutputStream)out);
            out.closeEntry();
        }
        catch (ZipException e) {
            if (e.getMessage().startsWith("duplicate entry")) {
                ZipEntry alternativeEntry = new ZipEntry(entry.getName() + "-DUPLICATE-FILENAME-" + this.alternativeEntryCounter.incrementAndGet() + ".jar");
                this.addToZip(out, alternativeEntry, in);
            }
            throw e;
        }
    }

    private InputStream getFileBytes(ZipInputStream is, String name) throws IOException {
        ZipEntry entry = null;
        while ((entry = is.getNextEntry()) != null) {
            if (!entry.getName().equals(name)) continue;
            byte[] data = IOUtils.toByteArray((InputStream)is);
            return new ByteArrayInputStream(data);
        }
        return null;
    }

    private List<File> extractDependencyFiles(Collection<Artifact> artifacts) {
        ArrayList<File> files = new ArrayList<File>();
        if (artifacts == null) {
            return files;
        }
        for (Artifact artifact : artifacts) {
            File file = artifact.getFile();
            if (!file.isFile()) continue;
            files.add(file);
        }
        return files;
    }

    private List<File> extractSystemDependencyFiles(Collection<Dependency> systemDependencies) {
        ArrayList<File> files = new ArrayList<File>();
        if (systemDependencies == null) {
            return files;
        }
        for (Dependency systemDependency : systemDependencies) {
            if (systemDependency == null || !"system".equals(systemDependency.getScope())) continue;
            files.add(new File(systemDependency.getSystemPath()));
        }
        return files;
    }

    private static List<File> toFileList(FileSet fileSet) throws IOException {
        File directory = new File(fileSet.getDirectory());
        String includes = OneJarMojo.toString(fileSet.getIncludes());
        String excludes = OneJarMojo.toString(fileSet.getExcludes());
        return FileUtils.getFiles((File)directory, (String)includes, (String)excludes);
    }

    private static String toString(List<String> strings) {
        StringBuilder sb = new StringBuilder();
        for (String string : strings) {
            if (sb.length() > 0) {
                sb.append(", ");
            }
            sb.append(string);
        }
        return sb.toString();
    }
}

