/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.runner.cache;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.BasicFileAttributes;
import org.sonar.runner.cache.PersistentCacheInvalidation;

class TTLCacheInvalidation
implements PersistentCacheInvalidation {
    private final long durationToExpireMs;

    TTLCacheInvalidation(long durationToExpireMs) {
        this.durationToExpireMs = durationToExpireMs;
    }

    @Override
    public boolean test(Path cacheEntryPath) throws IOException {
        BasicFileAttributes attr = Files.readAttributes(cacheEntryPath, BasicFileAttributes.class, new LinkOption[0]);
        long modTime = attr.lastModifiedTime().toMillis();
        long age = System.currentTimeMillis() - modTime;
        return age > this.durationToExpireMs;
    }
}

