/*
 * Decompiled with CFR 0.152.
 */
package jogamp.opengl.util.pngj;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import java.util.zip.CRC32;
import jogamp.opengl.util.pngj.PngjInputException;
import jogamp.opengl.util.pngj.PngjOutputException;

public class PngHelper {
    public static Charset charsetLatin1 = Charset.forName("ISO-8859-1");
    public static Charset charsetUTF8 = Charset.forName("UTF-8");
    static boolean DEBUG = false;
    private static final ThreadLocal<CRC32> crcProvider = new ThreadLocal<CRC32>(){

        @Override
        protected CRC32 initialValue() {
            return new CRC32();
        }
    };
    static final byte[] pngIdBytes = new byte[]{-119, 80, 78, 71, 13, 10, 26, 10};

    public static int readByte(InputStream inputStream) {
        try {
            return inputStream.read();
        }
        catch (IOException iOException) {
            throw new PngjOutputException(iOException);
        }
    }

    public static int readInt2(InputStream inputStream) {
        try {
            int n = inputStream.read();
            int n2 = inputStream.read();
            if (n == -1 || n2 == -1) {
                return -1;
            }
            return (n << 8) + n2;
        }
        catch (IOException iOException) {
            throw new PngjInputException("error reading readInt2", iOException);
        }
    }

    public static int readInt4(InputStream inputStream) {
        try {
            int n = inputStream.read();
            int n2 = inputStream.read();
            int n3 = inputStream.read();
            int n4 = inputStream.read();
            if (n == -1 || n2 == -1 || n3 == -1 || n4 == -1) {
                return -1;
            }
            return (n << 24) + (n2 << 16) + (n3 << 8) + n4;
        }
        catch (IOException iOException) {
            throw new PngjInputException("error reading readInt4", iOException);
        }
    }

    public static int readInt1fromByte(byte[] byArray, int n) {
        return byArray[n] & 0xFF;
    }

    public static int readInt2fromBytes(byte[] byArray, int n) {
        return (byArray[n] & 0xFF) << 16 | byArray[n + 1] & 0xFF;
    }

    public static int readInt4fromBytes(byte[] byArray, int n) {
        return (byArray[n] & 0xFF) << 24 | (byArray[n + 1] & 0xFF) << 16 | (byArray[n + 2] & 0xFF) << 8 | byArray[n + 3] & 0xFF;
    }

    public static void writeByte(OutputStream outputStream, byte by) {
        try {
            outputStream.write(by);
        }
        catch (IOException iOException) {
            throw new PngjOutputException(iOException);
        }
    }

    public static void writeInt2(OutputStream outputStream, int n) {
        byte[] byArray = new byte[]{(byte)(n >> 8 & 0xFF), (byte)(n & 0xFF)};
        PngHelper.writeBytes(outputStream, byArray);
    }

    public static void writeInt4(OutputStream outputStream, int n) {
        byte[] byArray = new byte[4];
        PngHelper.writeInt4tobytes(n, byArray, 0);
        PngHelper.writeBytes(outputStream, byArray);
    }

    public static void writeInt2tobytes(int n, byte[] byArray, int n2) {
        byArray[n2] = (byte)(n >> 8 & 0xFF);
        byArray[n2 + 1] = (byte)(n & 0xFF);
    }

    public static void writeInt4tobytes(int n, byte[] byArray, int n2) {
        byArray[n2] = (byte)(n >> 24 & 0xFF);
        byArray[n2 + 1] = (byte)(n >> 16 & 0xFF);
        byArray[n2 + 2] = (byte)(n >> 8 & 0xFF);
        byArray[n2 + 3] = (byte)(n & 0xFF);
    }

    public static void readBytes(InputStream inputStream, byte[] byArray, int n, int n2) {
        if (n2 == 0) {
            return;
        }
        try {
            int n3;
            for (int i = 0; i < n2; i += n3) {
                n3 = inputStream.read(byArray, n + i, n2 - i);
                if (n3 >= 1) continue;
                throw new RuntimeException("error reading bytes, " + n3 + " !=" + n2);
            }
        }
        catch (IOException iOException) {
            throw new PngjInputException("error reading", iOException);
        }
    }

    public static void writeBytes(OutputStream outputStream, byte[] byArray) {
        try {
            outputStream.write(byArray);
        }
        catch (IOException iOException) {
            throw new PngjOutputException(iOException);
        }
    }

    public static void writeBytes(OutputStream outputStream, byte[] byArray, int n, int n2) {
        try {
            outputStream.write(byArray, n, n2);
        }
        catch (IOException iOException) {
            throw new PngjOutputException(iOException);
        }
    }

    public static void logdebug(String string) {
        if (DEBUG) {
            System.out.println(string);
        }
    }

    public static Set<String> asSet(String ... stringArray) {
        return new HashSet<String>(Arrays.asList(stringArray));
    }

    public static Set<String> unionSets(Set<String> set, Set<String> set2) {
        HashSet<String> hashSet = new HashSet<String>();
        hashSet.addAll(set);
        hashSet.addAll(set2);
        return hashSet;
    }

    public static Set<String> unionSets(Set<String> set, Set<String> set2, Set<String> set3) {
        HashSet<String> hashSet = new HashSet<String>();
        hashSet.addAll(set);
        hashSet.addAll(set2);
        hashSet.addAll(set3);
        return hashSet;
    }

    public static CRC32 getCRC() {
        return crcProvider.get();
    }

    public static double resMetersToDpi(long l) {
        return (double)l * 0.0254;
    }

    public static long resDpiToMeters(double d) {
        return (long)(d / 0.0254 + 0.5);
    }

    public static int doubleToInt100000(double d) {
        return (int)(d * 100000.0 + 0.5);
    }

    public static double intToDouble100000(int n) {
        return (double)n / 100000.0;
    }

    public static int clampTo_0_255(int n) {
        return n > 255 ? 255 : (n < 0 ? 0 : n);
    }

    public static int clampTo_0_65535(int n) {
        return n > 65535 ? 65535 : (n < 0 ? 0 : n);
    }

    public static int clampTo_128_127(int n) {
        return n > 127 ? 127 : (n < -128 ? -128 : n);
    }
}

