/*
 * Decompiled with CFR 0.152.
 */
package jogamp.opengl.egl;

import com.jogamp.nativewindow.egl.EGLGraphicsDevice;
import javax.media.nativewindow.AbstractGraphicsConfiguration;
import javax.media.nativewindow.AbstractGraphicsDevice;
import javax.media.nativewindow.DefaultGraphicsScreen;
import javax.media.nativewindow.NativeSurface;
import javax.media.nativewindow.ProxySurface;
import javax.media.nativewindow.UpstreamSurfaceHook;
import javax.media.nativewindow.VisualIDHolder;
import javax.media.opengl.GLCapabilitiesImmutable;
import javax.media.opengl.GLException;
import jogamp.opengl.egl.EGL;
import jogamp.opengl.egl.EGLContext;
import jogamp.opengl.egl.EGLDisplayUtil;
import jogamp.opengl.egl.EGLDrawable;
import jogamp.opengl.egl.EGLDrawableFactory;
import jogamp.opengl.egl.EGLGLCapabilities;
import jogamp.opengl.egl.EGLGraphicsConfiguration;
import jogamp.opengl.egl.EGLGraphicsConfigurationFactory;

public class EGLUpstreamSurfaceHook
implements UpstreamSurfaceHook.MutableSize {
    protected static final boolean DEBUG = EGLDrawableFactory.DEBUG;
    private final NativeSurface upstreamSurface;
    private final UpstreamSurfaceHook.MutableSize upstreamSurfaceHookMutableSize;

    public EGLUpstreamSurfaceHook(NativeSurface nativeSurface) {
        UpstreamSurfaceHook upstreamSurfaceHook;
        this.upstreamSurface = nativeSurface;
        this.upstreamSurfaceHookMutableSize = this.upstreamSurface instanceof ProxySurface ? ((upstreamSurfaceHook = ((ProxySurface)this.upstreamSurface).getUpstreamSurfaceHook()) instanceof UpstreamSurfaceHook.MutableSize ? (UpstreamSurfaceHook.MutableSize)upstreamSurfaceHook : null) : null;
    }

    public final NativeSurface getUpstreamSurface() {
        return this.upstreamSurface;
    }

    static String getThreadName() {
        return Thread.currentThread().getName();
    }

    @Override
    public final void setSize(int n, int n2) {
        if (null != this.upstreamSurfaceHookMutableSize) {
            this.upstreamSurfaceHookMutableSize.setSize(n, n2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void create(ProxySurface proxySurface) {
        String string;
        if (DEBUG) {
            string = EGLUpstreamSurfaceHook.getThreadName() + ": EGLUpstreamSurfaceHook.create(" + proxySurface.getClass().getSimpleName() + "): ";
            System.err.println(string + this);
        } else {
            string = null;
        }
        if (this.upstreamSurface instanceof ProxySurface) {
            ((ProxySurface)this.upstreamSurface).createNotify();
        }
        if (1 >= this.upstreamSurface.lockSurface()) {
            throw new GLException("Could not lock: " + this.upstreamSurface);
        }
        try {
            this.evalUpstreamSurface(string, proxySurface);
        }
        finally {
            this.upstreamSurface.unlockSurface();
        }
    }

    private final void evalUpstreamSurface(String string, ProxySurface proxySurface) {
        EGLGraphicsConfiguration eGLGraphicsConfiguration;
        EGLGraphicsDevice eGLGraphicsDevice;
        boolean bl = true;
        AbstractGraphicsConfiguration abstractGraphicsConfiguration = this.upstreamSurface.getGraphicsConfiguration();
        AbstractGraphicsDevice abstractGraphicsDevice = abstractGraphicsConfiguration.getScreen().getDevice();
        if (abstractGraphicsDevice instanceof EGLGraphicsDevice) {
            eGLGraphicsDevice = (EGLGraphicsDevice)abstractGraphicsDevice;
            if (DEBUG) {
                System.err.println(string + "Reusing eglDevice: " + eGLGraphicsDevice);
            }
            if (0L == eGLGraphicsDevice.getHandle()) {
                eGLGraphicsDevice.open();
                bl = false;
                proxySurface.addUpstreamOptionBits(128);
            }
        } else {
            eGLGraphicsDevice = EGLDisplayUtil.eglCreateEGLGraphicsDevice(this.upstreamSurface);
            bl = false;
            proxySurface.addUpstreamOptionBits(128);
        }
        GLCapabilitiesImmutable gLCapabilitiesImmutable = (GLCapabilitiesImmutable)abstractGraphicsConfiguration.getRequestedCapabilities();
        if (abstractGraphicsConfiguration instanceof EGLGraphicsConfiguration) {
            EGLGLCapabilities eGLGLCapabilities = (EGLGLCapabilities)abstractGraphicsConfiguration.getChosenCapabilities();
            if (!bl || !EGLGraphicsConfiguration.isEGLConfigValid(eGLGraphicsDevice.getHandle(), eGLGLCapabilities.getEGLConfig())) {
                eGLGLCapabilities.setEGLConfig(EGLGraphicsConfiguration.EGLConfigId2EGLConfig(eGLGraphicsDevice.getHandle(), eGLGLCapabilities.getEGLConfigID()));
                if (0L == eGLGLCapabilities.getEGLConfig()) {
                    throw new GLException("Refreshing native EGLConfig handle failed with error " + EGLContext.toHexString(EGL.eglGetError()) + ": " + eGLGraphicsDevice + ", " + eGLGLCapabilities + " of " + abstractGraphicsConfiguration);
                }
                DefaultGraphicsScreen defaultGraphicsScreen = new DefaultGraphicsScreen(eGLGraphicsDevice, abstractGraphicsConfiguration.getScreen().getIndex());
                eGLGraphicsConfiguration = new EGLGraphicsConfiguration(defaultGraphicsScreen, eGLGLCapabilities, gLCapabilitiesImmutable, null);
                if (DEBUG) {
                    System.err.println(string + "Refreshing eglConfig: " + eGLGraphicsConfiguration);
                }
                bl = false;
            } else {
                eGLGraphicsConfiguration = (EGLGraphicsConfiguration)abstractGraphicsConfiguration;
                if (DEBUG) {
                    System.err.println(string + "Reusing eglConfig: " + eGLGraphicsConfiguration);
                }
            }
        } else {
            DefaultGraphicsScreen defaultGraphicsScreen = new DefaultGraphicsScreen(eGLGraphicsDevice, abstractGraphicsConfiguration.getScreen().getIndex());
            eGLGraphicsConfiguration = EGLGraphicsConfigurationFactory.chooseGraphicsConfigurationStatic(gLCapabilitiesImmutable, gLCapabilitiesImmutable, null, defaultGraphicsScreen, abstractGraphicsConfiguration.getVisualID(VisualIDHolder.VIDType.NATIVE), false);
            if (null == eGLGraphicsConfiguration) {
                throw new GLException("Couldn't create EGLGraphicsConfiguration from " + defaultGraphicsScreen);
            }
            if (DEBUG) {
                System.err.println(string + "Chosen eglConfig: " + eGLGraphicsConfiguration);
            }
            bl = false;
        }
        proxySurface.setGraphicsConfiguration(eGLGraphicsConfiguration);
        if (bl) {
            bl = EGLDrawable.isValidEGLSurface(eGLGraphicsDevice.getHandle(), this.upstreamSurface.getSurfaceHandle());
        }
        if (bl) {
            proxySurface.setSurfaceHandle(this.upstreamSurface.getSurfaceHandle());
            proxySurface.clearUpstreamOptionBits(64);
            if (DEBUG) {
                System.err.println(string + "Fin: Already valid EGL surface - use as-is: " + this.upstreamSurface);
            }
        } else {
            proxySurface.setSurfaceHandle(0L);
            proxySurface.addUpstreamOptionBits(64);
            if (DEBUG) {
                System.err.println(string + "Fin: EGL surface n/a - TBD: " + this.upstreamSurface);
            }
        }
    }

    @Override
    public final void destroy(ProxySurface proxySurface) {
        if (EGLDrawableFactory.DEBUG) {
            System.err.println("EGLUpstreamSurfaceHook.destroy(" + proxySurface.getClass().getSimpleName() + "): " + this);
        }
        proxySurface.clearUpstreamOptionBits(64);
        if (this.upstreamSurface instanceof ProxySurface) {
            ((ProxySurface)this.upstreamSurface).destroyNotify();
        }
    }

    @Override
    public final int getWidth(ProxySurface proxySurface) {
        return this.upstreamSurface.getWidth();
    }

    @Override
    public final int getHeight(ProxySurface proxySurface) {
        return this.upstreamSurface.getHeight();
    }

    public String toString() {
        String string = null != this.upstreamSurface ? this.upstreamSurface.getClass().getName() + ": 0x" + Long.toHexString(this.upstreamSurface.getSurfaceHandle()) : "nil";
        return "EGLUpstreamSurfaceHook[ " + this.upstreamSurface.getWidth() + "x" + this.upstreamSurface.getHeight() + ", " + string + "]";
    }
}

