/*
 * Decompiled with CFR 0.152.
 */
package jogamp.graph.font.typecast.ot;

import com.jogamp.graph.geom.AABBox;
import jogamp.graph.font.typecast.ot.Point;
import jogamp.graph.font.typecast.ot.table.Charstring;
import jogamp.graph.font.typecast.ot.table.CharstringType2;
import jogamp.graph.font.typecast.ot.table.GlyphDescription;
import jogamp.graph.font.typecast.t2.T2Interpreter;

public class OTGlyph {
    protected short _leftSideBearing;
    protected int _advanceWidth;
    private Point[] _points;
    AABBox _bbox;

    public OTGlyph(GlyphDescription glyphDescription, short s, int n) {
        this._leftSideBearing = s;
        this._advanceWidth = n;
        this.describe(glyphDescription);
    }

    public OTGlyph(Charstring charstring, short s, int n) {
        this._leftSideBearing = s;
        this._advanceWidth = n;
        if (charstring instanceof CharstringType2) {
            T2Interpreter t2Interpreter = new T2Interpreter();
            this._points = t2Interpreter.execute((CharstringType2)charstring);
        }
    }

    public AABBox getBBox() {
        return this._bbox;
    }

    public int getAdvanceWidth() {
        return this._advanceWidth;
    }

    public short getLeftSideBearing() {
        return this._leftSideBearing;
    }

    public Point getPoint(int n) {
        return this._points[n];
    }

    public int getPointCount() {
        return this._points.length;
    }

    public void reset() {
    }

    public void scale(int n) {
        for (int i = 0; i < this._points.length; ++i) {
            this._points[i].x = (this._points[i].x << 10) * n >> 26;
            this._points[i].y = (this._points[i].y << 10) * n >> 26;
        }
        this._leftSideBearing = (short)(this._leftSideBearing * n >> 6);
        this._advanceWidth = this._advanceWidth * n >> 6;
    }

    private void describe(GlyphDescription glyphDescription) {
        int n = 0;
        this._points = new Point[glyphDescription.getPointCount()];
        for (int i = 0; i < glyphDescription.getPointCount(); ++i) {
            boolean bl;
            boolean bl2 = bl = glyphDescription.getEndPtOfContours(n) == i;
            if (bl) {
                ++n;
            }
            this._points[i] = new Point(glyphDescription.getXCoordinate(i), glyphDescription.getYCoordinate(i), (glyphDescription.getFlags(i) & 1) != 0, bl);
        }
        this._bbox = new AABBox(glyphDescription.getXMinimum(), glyphDescription.getYMinimum(), 0.0f, glyphDescription.getXMaximum(), glyphDescription.getYMaximum(), 0.0f);
    }
}

