/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.opengl.util.texture.spi;

import com.jogamp.common.nio.Buffers;
import com.jogamp.common.util.IOUtil;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import jogamp.opengl.util.pngj.ImageInfo;
import jogamp.opengl.util.pngj.ImageLine;
import jogamp.opengl.util.pngj.PngReader;
import jogamp.opengl.util.pngj.PngWriter;

public class PNGImage {
    private final int pixelWidth;
    private final int pixelHeight;
    private final int glFormat;
    private final int bytesPerPixel;
    private boolean reversedChannels;
    private final double[] dpi;
    private final ByteBuffer data;

    public static PNGImage createFromData(int n, int n2, double d, double d2, int n3, boolean bl, ByteBuffer byteBuffer) {
        return new PNGImage(n, n2, d, d2, n3, bl, byteBuffer);
    }

    public static PNGImage read(InputStream inputStream) throws IOException {
        return new PNGImage(inputStream);
    }

    private static final int getPixelRGBA8(ByteBuffer byteBuffer, int n, ImageLine imageLine, int n2, boolean bl) {
        if (bl) {
            byteBuffer.put(n--, (byte)imageLine.scanline[n2 + 3]);
        }
        byteBuffer.put(n--, (byte)imageLine.scanline[n2 + 2]);
        byteBuffer.put(n--, (byte)imageLine.scanline[n2 + 1]);
        byteBuffer.put(n--, (byte)imageLine.scanline[n2]);
        return n;
    }

    private static int setPixelRGBA8(ImageLine imageLine, int n, ByteBuffer byteBuffer, int n2, boolean bl, boolean bl2) {
        if (bl2) {
            imageLine.scanline[n] = byteBuffer.get(n2--);
            imageLine.scanline[n + 1] = byteBuffer.get(n2--);
            imageLine.scanline[n + 2] = byteBuffer.get(n2--);
            if (bl) {
                imageLine.scanline[n + 3] = byteBuffer.get(n2--);
            }
        } else {
            if (bl) {
                imageLine.scanline[n + 3] = byteBuffer.get(n2--);
            }
            imageLine.scanline[n + 2] = byteBuffer.get(n2--);
            imageLine.scanline[n + 1] = byteBuffer.get(n2--);
            imageLine.scanline[n] = byteBuffer.get(n2--);
        }
        return n2;
    }

    private PNGImage(int n, int n2, double d, double d2, int n3, boolean bl, ByteBuffer byteBuffer) {
        this.pixelWidth = n;
        this.pixelHeight = n2;
        this.dpi = new double[]{d, d2};
        if (4 == n3) {
            this.glFormat = 6408;
        } else if (3 == n3) {
            this.glFormat = 6407;
        } else {
            throw new InternalError("XXX: bytesPerPixel " + n3);
        }
        this.bytesPerPixel = n3;
        this.reversedChannels = bl;
        this.data = byteBuffer;
    }

    private PNGImage(InputStream inputStream) {
        PngReader pngReader = new PngReader(new BufferedInputStream(inputStream), null);
        int n = pngReader.imgInfo.channels;
        if (1 != n && 3 != n && 4 != n) {
            throw new RuntimeException("PNGImage can only handle Lum/RGB/RGBA [1/3/4 channels] images for now. Channels " + n);
        }
        this.bytesPerPixel = pngReader.imgInfo.bytesPixel;
        if (1 != this.bytesPerPixel && 3 != this.bytesPerPixel && 4 != this.bytesPerPixel) {
            throw new RuntimeException("PNGImage can only handle Lum/RGB/RGBA [1/3/4 bpp] images for now. BytesPerPixel " + this.bytesPerPixel);
        }
        if (n != this.bytesPerPixel) {
            throw new RuntimeException("PNGImage currently only handles Channels [1/3/4] == BytePerPixel [1/3/4], channels: " + n + ", bytesPerPixel " + this.bytesPerPixel);
        }
        this.pixelWidth = pngReader.imgInfo.cols;
        this.pixelHeight = pngReader.imgInfo.rows;
        this.dpi = new double[2];
        double[] dArray = pngReader.getMetadata().getDpi();
        this.dpi[0] = dArray[0];
        this.dpi[1] = dArray[1];
        switch (n) {
            case 1: {
                this.glFormat = 6409;
                break;
            }
            case 3: {
                this.glFormat = 6407;
                break;
            }
            case 4: {
                this.glFormat = 6408;
                break;
            }
            default: {
                throw new InternalError("XXX: channels: " + n + ", bytesPerPixel " + this.bytesPerPixel);
            }
        }
        this.data = Buffers.newDirectByteBuffer((int)(this.bytesPerPixel * this.pixelWidth * this.pixelHeight));
        this.reversedChannels = false;
        boolean bl = 4 == n;
        int n2 = this.bytesPerPixel * this.pixelWidth * this.pixelHeight - 1;
        for (int i = 0; i < this.pixelHeight; ++i) {
            int n3;
            ImageLine imageLine = pngReader.readRow(i);
            int n4 = (this.pixelWidth - 1) * this.bytesPerPixel;
            if (1 == n) {
                for (n3 = this.pixelWidth - 1; n3 >= 0; --n3) {
                    this.data.put(n2--, (byte)imageLine.scanline[n4--]);
                }
                continue;
            }
            for (n3 = this.pixelWidth - 1; n3 >= 0; --n3) {
                n2 = PNGImage.getPixelRGBA8(this.data, n2, imageLine, n4, bl);
                n4 -= this.bytesPerPixel;
            }
        }
        pngReader.end();
    }

    public int getWidth() {
        return this.pixelWidth;
    }

    public int getHeight() {
        return this.pixelHeight;
    }

    public boolean getHasReversedChannels() {
        return this.reversedChannels;
    }

    public double[] getDpi() {
        return this.dpi;
    }

    public int getGLFormat() {
        return this.glFormat;
    }

    public int getGLType() {
        return 5121;
    }

    public int getBytesPerPixel() {
        return this.bytesPerPixel;
    }

    public ByteBuffer getData() {
        return this.data;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(File file, boolean bl) throws IOException {
        ImageInfo imageInfo = new ImageInfo(this.pixelWidth, this.pixelHeight, 8, 4 == this.bytesPerPixel);
        BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(IOUtil.getFileOutputStream((File)file, (boolean)bl));
        try {
            PngWriter pngWriter = new PngWriter(bufferedOutputStream, imageInfo);
            pngWriter.getMetadata().setDpi(this.dpi[0], this.dpi[1]);
            pngWriter.getMetadata().setTimeNow(0);
            pngWriter.getMetadata().setText("Title", "JogAmp PNGImage");
            boolean bl2 = 4 == this.bytesPerPixel;
            ImageLine imageLine = new ImageLine(imageInfo);
            int n = this.bytesPerPixel * this.pixelWidth * this.pixelHeight - 1;
            for (int i = 0; i < this.pixelHeight; ++i) {
                int n2;
                int n3 = (this.pixelWidth - 1) * this.bytesPerPixel;
                if (1 == this.bytesPerPixel) {
                    for (n2 = this.pixelWidth - 1; n2 >= 0; --n2) {
                        imageLine.scanline[n3--] = this.data.get(n--);
                    }
                } else {
                    for (n2 = this.pixelWidth - 1; n2 >= 0; --n2) {
                        n = PNGImage.setPixelRGBA8(imageLine, n3, this.data, n, bl2, this.reversedChannels);
                        n3 -= this.bytesPerPixel;
                    }
                }
                pngWriter.writeRow(imageLine, i);
            }
            pngWriter.end();
        }
        finally {
            IOUtil.close((Closeable)bufferedOutputStream, (boolean)false);
        }
    }

    public String toString() {
        return "PNGImage[" + this.pixelWidth + "x" + this.pixelHeight + ", dpi " + this.dpi[0] + " x " + this.dpi[1] + ", bytesPerPixel " + this.bytesPerPixel + ", reversedChannels " + this.reversedChannels + ", " + this.data + "]";
    }
}

