/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.newt.awt;

import com.jogamp.nativewindow.awt.AWTWindowClosingProtocol;
import com.jogamp.nativewindow.awt.JAWTWindow;
import com.jogamp.newt.Display;
import com.jogamp.newt.Window;
import com.jogamp.newt.event.InputEvent;
import com.jogamp.newt.event.KeyEvent;
import com.jogamp.newt.event.KeyListener;
import com.jogamp.newt.event.WindowAdapter;
import com.jogamp.newt.event.WindowEvent;
import com.jogamp.newt.event.WindowListener;
import com.jogamp.newt.event.awt.AWTAdapter;
import com.jogamp.newt.event.awt.AWTKeyAdapter;
import com.jogamp.newt.event.awt.AWTMouseAdapter;
import java.awt.AWTKeyStroke;
import java.awt.Canvas;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.GraphicsConfiguration;
import java.awt.Insets;
import java.awt.KeyboardFocusManager;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Set;
import javax.media.nativewindow.NativeWindow;
import javax.media.nativewindow.NativeWindowFactory;
import javax.media.nativewindow.OffscreenLayerOption;
import javax.media.nativewindow.OffscreenLayerSurface;
import javax.media.nativewindow.WindowClosingProtocol;
import javax.swing.MenuSelectionManager;
import jogamp.nativewindow.awt.AWTMisc;
import jogamp.newt.Debug;
import jogamp.newt.awt.NewtFactoryAWT;
import jogamp.newt.awt.event.AWTParentWindowAdapter;
import jogamp.newt.driver.DriverClearFocus;

public class NewtCanvasAWT
extends Canvas
implements WindowClosingProtocol,
OffscreenLayerOption {
    public static final boolean DEBUG = Debug.debug("Window");
    private JAWTWindow jawtWindow = null;
    private boolean shallUseOffscreenLayer = false;
    private Window newtChild = null;
    private boolean isOnscreen = true;
    private WindowClosingProtocol.WindowClosingMode newtChildCloseOp;
    private AWTAdapter awtAdapter = null;
    private AWTAdapter awtMouseAdapter = null;
    private AWTAdapter awtKeyAdapter = null;
    private AWTWindowClosingProtocol awtWindowClosingProtocol = new AWTWindowClosingProtocol(this, new Runnable(){

        @Override
        public void run() {
            NewtCanvasAWT.this.destroy();
        }
    });
    private FocusAction focusAction = new FocusAction();
    WindowListener clearAWTMenusOnNewtFocus = new WindowAdapter(){

        @Override
        public void windowGainedFocus(WindowEvent windowEvent) {
            if (NewtCanvasAWT.this.isParent() && !NewtCanvasAWT.this.isFullscreen()) {
                MenuSelectionManager.defaultManager().clearSelectedPath();
            }
        }
    };
    private final FocusTraversalKeyListener newtFocusTraversalKeyListener = new FocusTraversalKeyListener();
    private final FocusPropertyChangeListener focusPropertyChangeListener = new FocusPropertyChangeListener();
    private volatile KeyboardFocusManager keyboardFocusManager = null;
    private static boolean disableBackgroundEraseInitialized;
    private static Method disableBackgroundEraseMethod;

    public NewtCanvasAWT() {
    }

    public NewtCanvasAWT(GraphicsConfiguration graphicsConfiguration) {
        super(graphicsConfiguration);
    }

    public NewtCanvasAWT(Window window) {
        this.setNEWTChild(window);
    }

    public NewtCanvasAWT(GraphicsConfiguration graphicsConfiguration, Window window) {
        super(graphicsConfiguration);
        this.setNEWTChild(window);
    }

    @Override
    public void setShallUseOffscreenLayer(boolean bl) {
        this.shallUseOffscreenLayer = bl;
    }

    @Override
    public final boolean getShallUseOffscreenLayer() {
        return this.shallUseOffscreenLayer;
    }

    @Override
    public final boolean isOffscreenLayerSurfaceEnabled() {
        return this.jawtWindow.isOffscreenLayerSurfaceEnabled();
    }

    public boolean isApplet() {
        return this.jawtWindow.isApplet();
    }

    boolean isParent() {
        return null != this.newtChild && this.jawtWindow == this.newtChild.getParent();
    }

    boolean isFullscreen() {
        return null != this.newtChild && this.newtChild.isFullscreen();
    }

    public Window setNEWTChild(Window window) {
        Window window2 = this.newtChild;
        if (DEBUG) {
            System.err.println("NewtCanvasAWT.setNEWTChild.0: win " + NewtCanvasAWT.newtWinHandleToHexString(window2) + " -> " + NewtCanvasAWT.newtWinHandleToHexString(window));
        }
        Container container = AWTMisc.getContainer(this);
        if (null != this.newtChild) {
            this.reparentWindow(false, container);
            this.newtChild = null;
        }
        this.newtChild = window;
        if (this.isDisplayable() && null != window) {
            this.reparentWindow(true, container);
        }
        return window2;
    }

    public Window getNEWTChild() {
        return this.newtChild;
    }

    public NativeWindow getNativeWindow() {
        return this.jawtWindow;
    }

    @Override
    public WindowClosingProtocol.WindowClosingMode getDefaultCloseOperation() {
        return this.awtWindowClosingProtocol.getDefaultCloseOperation();
    }

    @Override
    public WindowClosingProtocol.WindowClosingMode setDefaultCloseOperation(WindowClosingProtocol.WindowClosingMode windowClosingMode) {
        return this.awtWindowClosingProtocol.setDefaultCloseOperation(windowClosingMode);
    }

    void configureNewtChild(boolean bl) {
        if (null != this.awtAdapter) {
            this.awtAdapter.removeFrom(this);
            this.awtAdapter = null;
        }
        if (null != this.awtMouseAdapter) {
            this.awtMouseAdapter.removeFrom(this);
            this.awtMouseAdapter = null;
        }
        if (null != this.awtKeyAdapter) {
            this.awtKeyAdapter.removeFrom(this);
            this.awtKeyAdapter = null;
        }
        if (null != this.keyboardFocusManager) {
            this.keyboardFocusManager.removePropertyChangeListener("focusOwner", this.focusPropertyChangeListener);
            this.keyboardFocusManager = null;
        }
        if (null != this.newtChild) {
            this.newtChild.setKeyboardFocusHandler(null);
            if (bl) {
                if (null == this.jawtWindow.getGraphicsConfiguration()) {
                    throw new InternalError("XXX");
                }
                this.isOnscreen = this.jawtWindow.getGraphicsConfiguration().getChosenCapabilities().isOnscreen();
                this.awtAdapter = new AWTParentWindowAdapter(this.jawtWindow, this.newtChild).addTo(this);
                this.newtChild.addWindowListener(this.clearAWTMenusOnNewtFocus);
                this.newtChild.setFocusAction(this.focusAction);
                this.newtChildCloseOp = this.newtChild.setDefaultCloseOperation(WindowClosingProtocol.WindowClosingMode.DO_NOTHING_ON_CLOSE);
                this.awtWindowClosingProtocol.addClosingListenerOneShot();
                this.keyboardFocusManager = KeyboardFocusManager.getCurrentKeyboardFocusManager();
                this.keyboardFocusManager.addPropertyChangeListener("focusOwner", this.focusPropertyChangeListener);
                if (this.isOnscreen) {
                    this.newtChild.setKeyboardFocusHandler(this.newtFocusTraversalKeyListener);
                } else {
                    this.awtMouseAdapter = new AWTMouseAdapter(this.newtChild).addTo(this);
                    this.awtKeyAdapter = new AWTKeyAdapter(this.newtChild).addTo(this);
                }
            } else {
                this.newtChild.removeWindowListener(this.clearAWTMenusOnNewtFocus);
                this.newtChild.setFocusAction(null);
                this.newtChild.setDefaultCloseOperation(this.newtChildCloseOp);
                this.awtWindowClosingProtocol.removeClosingListener();
            }
        }
    }

    @Override
    public void addNotify() {
        this.disableBackgroundErase();
        super.addNotify();
        this.disableBackgroundErase();
        Container container = AWTMisc.getContainer(this);
        if (DEBUG) {
            System.err.println("NewtCanvasAWT.addNotify: " + this.newtChild + ", " + this + ", visible " + this.isVisible() + ", showing " + this.isShowing() + ", displayable " + this.isDisplayable() + " -> " + container);
        }
        this.reparentWindow(true, container);
    }

    @Override
    public void removeNotify() {
        OffscreenLayerSurface offscreenLayerSurface;
        Container container = AWTMisc.getContainer(this);
        if (DEBUG) {
            System.err.println("NewtCanvasAWT.removeNotify: " + this.newtChild + ", from " + container);
        }
        if (null != (offscreenLayerSurface = NativeWindowFactory.getOffscreenLayerSurface(this.newtChild, true)) && offscreenLayerSurface.isSurfaceLayerAttached()) {
            offscreenLayerSurface.detachSurfaceLayer();
        }
        this.reparentWindow(false, container);
        if (null != this.jawtWindow) {
            NewtFactoryAWT.destroyNativeWindow(this.jawtWindow);
            this.jawtWindow = null;
        }
        super.removeNotify();
    }

    void reparentWindow(boolean bl, Container container) {
        if (null == this.newtChild) {
            return;
        }
        if (DEBUG) {
            System.err.println("NewtCanvasAWT.reparentWindow.0: add=" + bl + ", win " + NewtCanvasAWT.newtWinHandleToHexString(this.newtChild) + ", EDTUtil: cur " + this.newtChild.getScreen().getDisplay().getEDTUtil());
        }
        this.newtChild.setFocusAction(null);
        if (bl) {
            int n;
            int n2;
            if (DEBUG) {
                System.err.println("NewtCanvasAWT.reparentWindow: newtChild: " + this.newtChild);
            }
            if (null == this.jawtWindow) {
                this.jawtWindow = NewtFactoryAWT.getNativeWindow(this, this.newtChild.getRequestedCapabilities());
                this.jawtWindow.setShallUseOffscreenLayer(this.shallUseOffscreenLayer);
            }
            if (this.isPreferredSizeSet()) {
                Dimension dimension = this.getPreferredSize();
                n2 = dimension.width;
                n = dimension.height;
            } else {
                Dimension dimension = this.isMinimumSizeSet() ? this.getMinimumSize() : new Dimension(0, 0);
                Insets insets = container.getInsets();
                n2 = Math.max(dimension.width, container.getWidth() - insets.left - insets.right);
                n = Math.max(dimension.height, container.getHeight() - insets.top - insets.bottom);
            }
            this.setSize(n2, n);
            this.newtChild.setSize(n2, n);
            this.newtChild.reparentWindow(this.jawtWindow);
            this.newtChild.setVisible(true);
            this.configureNewtChild(true);
            this.newtChild.sendWindowEvent(100);
            this.setFocusable(true);
        } else {
            this.configureNewtChild(false);
            this.newtChild.setVisible(false);
            this.newtChild.reparentWindow(null);
        }
        if (DEBUG) {
            System.err.println("NewtCanvasAWT.reparentWindow.X: add=" + bl + ", win " + NewtCanvasAWT.newtWinHandleToHexString(this.newtChild) + ", EDTUtil: cur " + this.newtChild.getScreen().getDisplay().getEDTUtil());
        }
    }

    public final void destroy() {
        if (null != this.newtChild) {
            Container container = AWTMisc.getContainer(this);
            if (DEBUG) {
                System.err.println("NewtCanvasAWT.destroy(): " + this.newtChild + ", from " + container);
            }
            this.configureNewtChild(false);
            if (null != this.jawtWindow) {
                NewtFactoryAWT.destroyNativeWindow(this.jawtWindow);
                this.jawtWindow = null;
            }
            this.newtChild.setVisible(false);
            this.newtChild.reparentWindow(null);
            this.newtChild.destroy();
            this.newtChild = null;
            if (null != container) {
                container.remove(this);
            }
        }
    }

    @Override
    public void paint(Graphics graphics) {
        this.awtWindowClosingProtocol.addClosingListenerOneShot();
        if (null != this.newtChild) {
            this.newtChild.windowRepaint(0, 0, this.getWidth(), this.getHeight());
        }
    }

    @Override
    public void update(Graphics graphics) {
        this.awtWindowClosingProtocol.addClosingListenerOneShot();
        if (null != this.newtChild) {
            this.newtChild.windowRepaint(0, 0, this.getWidth(), this.getHeight());
        }
    }

    private final void requestFocusNEWTChild() {
        if (null != this.newtChild) {
            this.newtChild.setFocusAction(null);
            if (this.isOnscreen) {
                KeyboardFocusManager.getCurrentKeyboardFocusManager().clearGlobalFocusOwner();
            }
            this.newtChild.requestFocus();
            this.newtChild.setFocusAction(this.focusAction);
        }
    }

    @Override
    public void requestFocus() {
        super.requestFocus();
        this.requestFocusNEWTChild();
    }

    @Override
    public boolean requestFocus(boolean bl) {
        boolean bl2 = super.requestFocus(bl);
        if (bl2) {
            this.requestFocusNEWTChild();
        }
        return bl2;
    }

    @Override
    public boolean requestFocusInWindow() {
        boolean bl = super.requestFocusInWindow();
        if (bl) {
            this.requestFocusNEWTChild();
        }
        return bl;
    }

    @Override
    public boolean requestFocusInWindow(boolean bl) {
        boolean bl2 = super.requestFocusInWindow(bl);
        if (bl2) {
            this.requestFocusNEWTChild();
        }
        return bl2;
    }

    private void disableBackgroundErase() {
        if (!disableBackgroundEraseInitialized) {
            try {
                AccessController.doPrivileged(new PrivilegedAction<Object>(){

                    @Override
                    public Object run() {
                        try {
                            Class<?> clazz = NewtCanvasAWT.this.getToolkit().getClass();
                            while (clazz != null && disableBackgroundEraseMethod == null) {
                                try {
                                    disableBackgroundEraseMethod = clazz.getDeclaredMethod("disableBackgroundErase", Canvas.class);
                                    disableBackgroundEraseMethod.setAccessible(true);
                                }
                                catch (Exception exception) {
                                    clazz = clazz.getSuperclass();
                                }
                            }
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        return null;
                    }
                });
            }
            catch (Exception exception) {
                // empty catch block
            }
            disableBackgroundEraseInitialized = true;
            if (DEBUG) {
                System.err.println("NewtCanvasAWT: TK disableBackgroundErase method found: " + (null != disableBackgroundEraseMethod));
            }
        }
        if (disableBackgroundEraseMethod != null) {
            Exception exception = null;
            try {
                disableBackgroundEraseMethod.invoke((Object)this.getToolkit(), this);
            }
            catch (Exception exception2) {
                exception = exception2;
            }
            if (DEBUG) {
                System.err.println("NewtCanvasAWT: TK disableBackgroundErase error: " + exception);
            }
        }
    }

    static String newtWinHandleToHexString(Window window) {
        return null != window ? NewtCanvasAWT.toHexString(window.getWindowHandle()) : "nil";
    }

    static String toHexString(long l) {
        return "0x" + Long.toHexString(l);
    }

    class FocusPropertyChangeListener
    implements PropertyChangeListener {
        FocusPropertyChangeListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            Object object = propertyChangeEvent.getOldValue();
            Object object2 = propertyChangeEvent.getNewValue();
            boolean bl = NewtCanvasAWT.this.isParent();
            boolean bl2 = NewtCanvasAWT.this.isFullscreen();
            if (DEBUG) {
                System.err.println("NewtCanvasAWT.FocusProperty: " + propertyChangeEvent.getPropertyName() + ", src " + propertyChangeEvent.getSource() + ", " + object + " -> " + object2 + ", isParent " + bl + ", isFS " + bl2);
            }
            if (bl && !bl2) {
                if (object == NewtCanvasAWT.this && object2 == null) {
                    if (DEBUG) {
                        System.err.println("NewtCanvasAWT.FocusProperty: NEWT focus traversal");
                    }
                } else if (null != object2 && object2 != NewtCanvasAWT.this) {
                    if (DEBUG) {
                        System.err.println("NewtCanvasAWT.FocusProperty: lost focus - clear focus");
                    }
                    if (NewtCanvasAWT.this.newtChild.getDelegatedWindow() instanceof DriverClearFocus) {
                        ((DriverClearFocus)((Object)NewtCanvasAWT.this.newtChild.getDelegatedWindow())).clearFocus();
                    }
                }
            }
        }
    }

    class FocusTraversalKeyListener
    implements KeyListener {
        boolean suppress = false;

        FocusTraversalKeyListener() {
        }

        @Override
        public void keyPressed(KeyEvent keyEvent) {
            if (NewtCanvasAWT.this.isParent() && !NewtCanvasAWT.this.isFullscreen()) {
                this.handleKey(keyEvent, false);
            }
        }

        @Override
        public void keyReleased(KeyEvent keyEvent) {
            if (NewtCanvasAWT.this.isParent() && !NewtCanvasAWT.this.isFullscreen()) {
                this.handleKey(keyEvent, true);
            }
        }

        @Override
        public void keyTyped(KeyEvent keyEvent) {
            if (this.suppress) {
                keyEvent.setAttachment(InputEvent.consumedTag);
                this.suppress = false;
            }
        }

        void handleKey(KeyEvent keyEvent, boolean bl) {
            if (null == NewtCanvasAWT.this.keyboardFocusManager) {
                throw new InternalError("XXX");
            }
            AWTKeyStroke aWTKeyStroke = AWTKeyStroke.getAWTKeyStroke(keyEvent.getKeyCode(), keyEvent.getModifiers(), bl);
            if (null != aWTKeyStroke) {
                Set<AWTKeyStroke> set = NewtCanvasAWT.this.keyboardFocusManager.getDefaultFocusTraversalKeys(0);
                Set<AWTKeyStroke> set2 = NewtCanvasAWT.this.keyboardFocusManager.getDefaultFocusTraversalKeys(1);
                if (set.contains(aWTKeyStroke)) {
                    if (DEBUG) {
                        System.err.println("NewtCanvasAWT.focusKey (fwd): " + aWTKeyStroke + ", current focusOwner " + NewtCanvasAWT.this.keyboardFocusManager.getFocusOwner());
                    }
                    NewtCanvasAWT.this.transferFocus();
                    this.suppress = true;
                } else if (set2.contains(aWTKeyStroke)) {
                    if (DEBUG) {
                        System.err.println("NewtCanvasAWT.focusKey (bwd): " + aWTKeyStroke + ", current focusOwner " + NewtCanvasAWT.this.keyboardFocusManager.getFocusOwner());
                    }
                    NewtCanvasAWT.this.transferFocusBackward();
                    this.suppress = true;
                }
            }
            if (this.suppress) {
                keyEvent.setAttachment(InputEvent.consumedTag);
            }
            if (DEBUG) {
                System.err.println("NewtCanvasAWT.focusKey: XXX: " + aWTKeyStroke);
            }
        }
    }

    class FocusAction
    implements Window.FocusRunnable {
        FocusAction() {
        }

        @Override
        public boolean run() {
            boolean bl = NewtCanvasAWT.this.isParent();
            boolean bl2 = NewtCanvasAWT.this.isFullscreen();
            if (DEBUG) {
                System.err.println("NewtCanvasAWT.FocusAction: " + Display.getThreadName() + ", isOnscreen " + NewtCanvasAWT.this.isOnscreen + ", hasFocus " + NewtCanvasAWT.this.hasFocus() + ", isParent " + bl + ", isFS " + bl2);
            }
            if (bl && !bl2) {
                if (!NewtCanvasAWT.this.hasFocus()) {
                    NewtCanvasAWT.super.requestFocus();
                }
                if (NewtCanvasAWT.this.isOnscreen) {
                    KeyboardFocusManager.getCurrentKeyboardFocusManager().clearGlobalFocusOwner();
                }
            }
            return false;
        }
    }
}

